/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableRow;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class CucumberQuery {
    private final Map<String, Step> gherkinStepById = new HashMap<String, Step>();
    private final Map<String, Scenario> gherkinScenarioById = new HashMap<String, Scenario>();
    private final Map<String, Location> locationBySourceId = new HashMap<String, Location>();

    CucumberQuery() {
    }

    void update(Feature feature) {
        feature.getChildren().forEach(featureChild -> {
            featureChild.getBackground().ifPresent(this::updateBackground);
            featureChild.getScenario().ifPresent(this::updateScenario);
            featureChild.getRule().ifPresent(rule -> rule.getChildren().forEach(ruleChild -> {
                ruleChild.getBackground().ifPresent(this::updateBackground);
                ruleChild.getScenario().ifPresent(this::updateScenario);
            }));
        });
    }

    private void updateBackground(Background background) {
        this.updateStep(background.getSteps());
    }

    private void updateScenario(Scenario scenario) {
        this.gherkinScenarioById.put(Objects.requireNonNull(scenario.getId()), scenario);
        this.locationBySourceId.put(Objects.requireNonNull(scenario.getId()), scenario.getLocation());
        this.updateStep(scenario.getSteps());
        for (Examples examples : scenario.getExamples()) {
            for (TableRow tableRow : examples.getTableBody()) {
                this.locationBySourceId.put(Objects.requireNonNull(tableRow.getId()), tableRow.getLocation());
            }
        }
    }

    private void updateStep(List<Step> stepsList) {
        for (Step step : stepsList) {
            this.locationBySourceId.put(Objects.requireNonNull(step.getId()), step.getLocation());
            this.gherkinStepById.put(Objects.requireNonNull(step.getId()), step);
        }
    }

    Step getGherkinStep(String sourceId) {
        return Objects.requireNonNull(this.gherkinStepById.get(Objects.requireNonNull(sourceId)));
    }

    Scenario getGherkinScenario(String sourceId) {
        return Objects.requireNonNull(this.gherkinScenarioById.get(Objects.requireNonNull(sourceId)));
    }

    Location getLocation(String sourceId) {
        Location location = this.locationBySourceId.get(Objects.requireNonNull(sourceId));
        return Objects.requireNonNull(location);
    }
}

