/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class CachingFunction<T, R>
implements Function<T, R> {
    private final Function<T, R> wrapped;
    private final Map<T, R> cache = new HashMap<T, R>();

    public CachingFunction(Function<T, R> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    @SuppressFBWarnings(value={"MUI_CONTAINSKEY_BEFORE_GET"}, justification="Deliberate to all null values")
    public R apply(T t) {
        R result;
        if (this.cache.containsKey(t)) {
            result = this.cache.get(t);
        } else {
            result = this.wrapped.apply(t);
            this.cache.put(t, result);
        }
        return result;
    }
}

