/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.info;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import tim.prune.App;
import tim.prune.ExternalTools;
import tim.prune.GenericFunction;
import tim.prune.GpsPrune;
import tim.prune.I18nManager;
import tim.prune.threedee.WindowFactory;

public class AboutScreen
extends GenericFunction {
    private JDialog _dialog = null;
    private JTabbedPane _tabs = null;
    private JButton _okButton = null;
    private JTextArea _aboutTextArea = null;
    private JLabel[] _installedLabels = null;

    public AboutScreen(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.about";
    }

    private Component makeContents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._tabs = new JTabbedPane();
        jPanel.add((Component)this._tabs, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel = new JLabel("GpsPrune");
        jLabel.setFont(new Font("SansSerif", 1, 24));
        jLabel.setAlignmentX(0.5f);
        jPanel2.add(jLabel);
        JLabel jLabel2 = new JLabel(String.valueOf(I18nManager.getText("dialog.about.version")) + ": " + "26.1");
        jLabel2.setAlignmentX(0.5f);
        jPanel2.add(jLabel2);
        JLabel jLabel3 = new JLabel(String.valueOf(I18nManager.getText("dialog.about.build")) + ": " + "433");
        jLabel3.setAlignmentX(0.5f);
        jPanel2.add(jLabel3);
        jPanel2.add(new JLabel(" "));
        JEditorPane jEditorPane = new JEditorPane("text/html", this.getDescHtml());
        jEditorPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        jEditorPane.setEditable(false);
        jEditorPane.setOpaque(false);
        jEditorPane.setAlignmentX(0.5f);
        jPanel2.add(jEditorPane);
        jPanel2.add(new JLabel(" "));
        this._tabs.add(I18nManager.getText("function.about"), jPanel2);
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        AboutScreen.addToGridBagPanel(jPanel3, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(I18nManager.getText("dialog.about.systeminfo.os")) + " : "), 0, 0);
        AboutScreen.addToGridBagPanel(jPanel3, gridBagLayout, gridBagConstraints, new JLabel(System.getProperty("os.name")), 1, 0);
        AboutScreen.addToGridBagPanel(jPanel3, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(I18nManager.getText("dialog.about.systeminfo.java")) + " : "), 0, 1);
        AboutScreen.addToGridBagPanel(jPanel3, gridBagLayout, gridBagConstraints, new JLabel(System.getProperty("java.runtime.version")), 1, 1);
        this._installedLabels = new JLabel[5];
        int n = 0;
        while (n < 5) {
            this._installedLabels[n] = new JLabel("...");
            ++n;
        }
        AboutScreen.addToGridBagPanel(jPanel3, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(I18nManager.getText("dialog.about.systeminfo.java3d")) + " : "), 0, 2);
        AboutScreen.addToGridBagPanel(jPanel3, gridBagLayout, gridBagConstraints, this._installedLabels[0], 1, 2);
        AboutScreen.addToGridBagPanel(jPanel3, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(I18nManager.getText("dialog.about.systeminfo.exiftool")) + " : "), 0, 3);
        AboutScreen.addToGridBagPanel(jPanel3, gridBagLayout, gridBagConstraints, this._installedLabels[1], 1, 3);
        AboutScreen.addToGridBagPanel(jPanel3, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(I18nManager.getText("dialog.about.systeminfo.gpsbabel")) + " : "), 0, 4);
        AboutScreen.addToGridBagPanel(jPanel3, gridBagLayout, gridBagConstraints, this._installedLabels[2], 1, 4);
        AboutScreen.addToGridBagPanel(jPanel3, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(I18nManager.getText("dialog.about.systeminfo.gnuplot")) + " : "), 0, 5);
        AboutScreen.addToGridBagPanel(jPanel3, gridBagLayout, gridBagConstraints, this._installedLabels[3], 1, 5);
        AboutScreen.addToGridBagPanel(jPanel3, gridBagLayout, gridBagConstraints, new JLabel("Xerces : "), 0, 6);
        AboutScreen.addToGridBagPanel(jPanel3, gridBagLayout, gridBagConstraints, this._installedLabels[4], 1, 6);
        this._tabs.add(I18nManager.getText("dialog.about.systeminfo"), jPanel3);
        JPanel jPanel4 = new JPanel();
        gridBagLayout = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipady = 3;
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(I18nManager.getText("dialog.about.credits.code")) + " : "), 0, 0);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel("activityworkshop.net"), 1, 0);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(I18nManager.getText("dialog.about.credits.exifcode")) + " : "), 0, 1);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel("Drew Noakes"), 1, 1);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(I18nManager.getText("dialog.about.credits.icons")) + " : "), 0, 2);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel("Fontawesome.com"), 1, 2);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(I18nManager.getText("dialog.about.credits.translators")) + " : "), 0, 3);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel("Ramon, Miguel, In\u00e9s, Piotr, Petrovsk, Josatoc, Weehal,"), 1, 3);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel(" theYinYeti, Rothermographer, Sam, Rudolph, nazotoko,"), 1, 4);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel(" katpatuka, R\u00e9mi, Marcus, Ali, Javier, Jeroen, prot_d,"), 1, 5);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel(" Gy\u00f6rgy, HooAU, Sergey, P\u00e9ter, serhijdubyk, Peter, Cristian,"), 1, 6);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel(" Roman, Erkki, Carlos, Tche333, J.M., edelsteen, Sprinto"), 1, 7);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(I18nManager.getText("dialog.about.credits.translations")) + " : "), 0, 8);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel("Open Office, Gpsdrive, Babelfish, Leo, Launchpad, DeepL"), 1, 8);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(I18nManager.getText("dialog.about.credits.devtools")) + " : "), 0, 9);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel("Debian Linux, Sun Java, OpenJDK, Eclipse, Svn, Gimp, Inkscape"), 1, 9);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(I18nManager.getText("dialog.about.credits.othertools")) + " : "), 0, 10);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel("Openstreetmap, Povray, Exiftool, Gpsbabel, Gnuplot"), 1, 10);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel(String.valueOf(I18nManager.getText("dialog.about.credits.thanks")) + " : "), 0, 11);
        AboutScreen.addToGridBagPanel(jPanel4, gridBagLayout, gridBagConstraints, new JLabel("Friends and loved ones, for encouragement and support"), 1, 11);
        this._tabs.add(I18nManager.getText("dialog.about.credits"), jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        this._aboutTextArea = new JTextArea(I18nManager.getText("details.photo.loading"));
        new Thread(() -> this._aboutTextArea.setText(this.getReadmeText())).start();
        this._aboutTextArea.setEditable(false);
        this._aboutTextArea.setLineWrap(true);
        this._aboutTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this._aboutTextArea);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(new Dimension(600, 130));
        jPanel5.add((Component)jScrollPane, "Center");
        this._tabs.add(I18nManager.getText("dialog.about.readme"), jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(1));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(actionEvent -> this._dialog.dispose());
        this._okButton.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    AboutScreen.this._dialog.dispose();
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        jPanel6.add(this._okButton);
        jPanel.add((Component)jPanel6, "South");
        return jPanel;
    }

    private String getDescHtml() {
        return "<p>" + I18nManager.getText("dialog.about.summarytext1") + "</p>" + "<p>" + I18nManager.getText("dialog.about.summarytext2") + "</p>" + "<p>" + I18nManager.getText("dialog.about.summarytext3") + "</p>" + "<p>" + I18nManager.getText("dialog.about.languages") + " : " + "afrikaans, catal\u00e0, \u010de\u0161tina, deutsch, english, espa\u00f1ol, fran\u00e7ais,<br>" + " italiano, magyar, nederlands, norsk bokm\u00e5l, polski, portugu\u00eas, rom\u00e2n\u0103, suomi,<br>" + " svenska, \u0440\u0443\u0441\u0441\u043a\u0438\u0439 (russian), \u4e2d\u6587 (chinese), schwiizerd\u00fc\u00fctsch</p>" + "<p>" + I18nManager.getText("dialog.about.translatedby") + "</p>";
    }

    private static void addToGridBagPanel(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JLabel jLabel, int n, int n2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.anchor = n == 0 ? 13 : 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
    }

    /*
     * Loose catch block
     */
    private String getReadmeText() {
        String string = null;
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try {
                String string2;
                BufferedReader bufferedReader;
                InputStream inputStream;
                block38: {
                    block37: {
                        inputStream = GpsPrune.class.getResourceAsStream("readme.txt");
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        string2 = this.readFromReader(bufferedReader);
                        if (bufferedReader == null) break block37;
                        bufferedReader.close();
                    }
                    if (inputStream == null) break block38;
                    inputStream.close();
                }
                return string2;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
        }
        catch (NullPointerException nullPointerException) {
            string = "Local readme file not found";
        }
        File file = new File("/usr/share/doc/gpsprune/readme.txt.gz");
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var4_13 = null;
                try {
                    String string3;
                    BufferedReader bufferedReader;
                    GZIPInputStream gZIPInputStream;
                    block40: {
                        block39: {
                            gZIPInputStream = new GZIPInputStream(new FileInputStream(file));
                            bufferedReader = new BufferedReader(new InputStreamReader(gZIPInputStream));
                            string3 = this.readFromReader(bufferedReader);
                            if (bufferedReader == null) break block39;
                            bufferedReader.close();
                        }
                        if (gZIPInputStream == null) break block40;
                        ((InputStream)gZIPInputStream).close();
                    }
                    return string3;
                    {
                        catch (Throwable throwable5) {
                            try {
                                if (bufferedReader != null) {
                                    bufferedReader.close();
                                }
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                if (throwable == null) {
                                    throwable = throwable6;
                                } else if (throwable != throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                if (gZIPInputStream != null) {
                                    ((InputStream)gZIPInputStream).close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable == null) {
                        throwable = throwable7;
                    } else if (throwable != throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                System.err.println("Exception trying to get readme.gz : " + iOException.getMessage());
            }
        }
        if (string != null) {
            System.err.println("Exception trying to get readme: " + string);
        }
        return I18nManager.getText("error.readme.notfound");
    }

    private String readFromReader(BufferedReader bufferedReader) throws IOException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string).append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog((Frame)this._parentFrame, this.getName());
            this._dialog.getContentPane().add(this.makeContents());
            this._dialog.pack();
        }
        this._tabs.setSelectedIndex(0);
        this.checkInstalls();
        this._dialog.setVisible(true);
        this._okButton.requestFocus();
    }

    private void checkInstalls() {
        String string = I18nManager.getText("dialog.about.yes");
        String string2 = I18nManager.getText("dialog.about.no");
        this._installedLabels[0].setText(WindowFactory.isJava3dEnabled() ? string : string2);
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] nArray2 = nArray;
        int n = 0;
        while (n < nArray2.length) {
            this._installedLabels[n + 1].setText(ExternalTools.isToolInstalled(this.getConfig(), nArray2[n]) ? string : string2);
            ++n;
        }
    }
}

