/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife;

import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.sf.juife.Task;
import net.sf.juife.event.TaskQueueEvent;
import net.sf.juife.event.TaskQueueListener;

public class TaskQueue {
    private final String name;
    private final LinkedList<Task> taskQueue = new LinkedList();
    private Task currentTask;
    private boolean started = false;
    private boolean cancel = false;
    private boolean stop = false;
    private boolean idle = true;
    private static int serial = 0;
    private final Vector<TaskQueueListener> listenerList = new Vector();
    private ActionEvent e = null;

    public TaskQueue() {
        this("TaskQueue-" + TaskQueue.getSerialNumber());
    }

    public TaskQueue(String name) {
        this(name, (Task[])null);
    }

    public TaskQueue(Task ... tasks) {
        this("TaskQueue-" + TaskQueue.getSerialNumber(), tasks);
    }

    public TaskQueue(String name, Task ... tasks) {
        this.name = name;
        if (tasks == null) {
            return;
        }
        for (Task t : tasks) {
            this.add(t);
        }
    }

    public String getName() {
        return this.name;
    }

    public synchronized void add(Task task) {
        if (this.isStopped()) {
            throw new IllegalStateException(this.getName() + " queue is stopped");
        }
        this.taskQueue.add(task);
        if (this.taskQueue.size() == 1) {
            this.fireTaskQueueEvent(new TaskQueueEvent(this, TaskQueueEvent.ID.FILLED));
        }
        if (this.isIdle()) {
            this.idle = false;
            this.fireTaskQueueEvent(new TaskQueueEvent(this, TaskQueueEvent.ID.NOT_IDLE));
        }
        this.notifyAll();
    }

    public synchronized void start() {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getName() + " queue is already running");
        }
        if (this.isStarted()) {
            if (!this.isStopped()) {
                this.stop = false;
            }
            this.cancel = false;
        }
        this.started = true;
        this.fireTaskQueueEvent(new TaskQueueEvent(this, TaskQueueEvent.ID.STARTED));
        new Thread(this.name){

            @Override
            public void run() {
                TaskQueue.this.start0();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start0() {
        while (true) {
            this.processTheQueue();
            if (this.isStopped()) {
                if (this.isCancelled() || this.isEmpty()) break;
                this.processTheQueue();
                break;
            }
            TaskQueue taskQueue = this;
            synchronized (taskQueue) {
                if (!this.isEmpty()) {
                    continue;
                }
                try {
                    this.wait();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTheQueue() {
        if (this.isEmpty()) {
            return;
        }
        while (!this.isCancelled()) {
            TaskQueue taskQueue = this;
            synchronized (taskQueue) {
                this.currentTask = this.taskQueue.poll();
                this.fireTaskQueueEvent(new TaskQueueEvent(this.currentTask, TaskQueueEvent.ID.TASK_FETCHED));
                if (this.isEmpty()) {
                    this.fireTaskQueueEvent(new TaskQueueEvent(this, TaskQueueEvent.ID.EMPTY));
                }
            }
            this.currentTask.invokeAndWait();
            taskQueue = this;
            synchronized (taskQueue) {
                this.fireTaskQueueEvent(new TaskQueueEvent(this.currentTask, TaskQueueEvent.ID.TASK_DONE));
                this.currentTask = null;
                if (this.isEmpty()) {
                    this.idle = true;
                    this.fireTaskQueueEvent(new TaskQueueEvent(this, TaskQueueEvent.ID.IDLE));
                    return;
                }
            }
        }
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized void cancel() {
        this.cancel = true;
        this.stop();
    }

    public synchronized boolean isCancelled() {
        return this.cancel;
    }

    public synchronized void stop() {
        this.stop = true;
        this.fireTaskQueueEvent(new TaskQueueEvent(this, TaskQueueEvent.ID.STOPPED));
        this.notifyAll();
    }

    public synchronized boolean isStopped() {
        return this.stop;
    }

    public synchronized boolean isRunning() {
        return this.isStarted() && !this.isStopped();
    }

    public synchronized boolean isEmpty() {
        return this.taskQueue.isEmpty();
    }

    public synchronized boolean isIdle() {
        return this.idle;
    }

    public synchronized int getPendingTaskCount() {
        return this.taskQueue.size();
    }

    public synchronized Task[] getPendingTasks() {
        return this.taskQueue.toArray(new Task[this.taskQueue.size()]);
    }

    public synchronized Task getRunningTask() {
        return this.currentTask;
    }

    public synchronized void removePendingTasks() {
        this.taskQueue.clear();
    }

    public synchronized boolean removeTask(Task t) {
        return this.taskQueue.remove(t);
    }

    private static synchronized int getSerialNumber() {
        return ++serial;
    }

    public void addTaskQueueListener(TaskQueueListener l) {
        this.listenerList.add(l);
    }

    public void removeTaskQueueListener(TaskQueueListener l) {
        this.listenerList.remove(l);
    }

    private synchronized void fireTaskQueueEvent(final TaskQueueEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (TaskQueueListener l : TaskQueue.this.listenerList) {
                    l.stateChanged(e);
                }
            }
        });
    }
}

