/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.fileformats.data;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.IndexOutput;
import org.opensearch.index.compositeindex.datacube.startree.node.InMemoryTreeNode;

public class StarTreeDataWriter {
    private static final Logger logger = LogManager.getLogger(StarTreeDataWriter.class);

    public static long writeStarTree(IndexOutput indexOutput, InMemoryTreeNode rootNode, int numNodes, String name) throws IOException {
        long totalSizeInBytes = (long)numNodes * 33L;
        logger.debug("Star tree data size in bytes : {} for star-tree field {}", (Object)totalSizeInBytes, (Object)name);
        StarTreeDataWriter.writeStarTreeNodes(indexOutput, rootNode);
        return totalSizeInBytes;
    }

    private static void writeStarTreeNodes(IndexOutput output, InMemoryTreeNode rootNode) throws IOException {
        LinkedList<InMemoryTreeNode> queue = new LinkedList<InMemoryTreeNode>();
        queue.add(rootNode);
        int currentNodeId = 0;
        while (!queue.isEmpty()) {
            InMemoryTreeNode node = (InMemoryTreeNode)queue.remove();
            if (!node.hasChild()) {
                StarTreeDataWriter.writeStarTreeNode(output, node, -1, -1);
            } else {
                int totalNumberOfChildren = 0;
                int firstChildId = currentNodeId + queue.size() + 1;
                if (node.getChildStarNode() != null) {
                    ++totalNumberOfChildren;
                    queue.add(node.getChildStarNode());
                }
                if (node.getChildren() != null) {
                    totalNumberOfChildren += node.getChildren().values().size();
                    queue.addAll(node.getChildren().values());
                }
                int lastChildId = firstChildId + totalNumberOfChildren - 1;
                StarTreeDataWriter.writeStarTreeNode(output, node, firstChildId, lastChildId);
            }
            ++currentNodeId;
        }
    }

    private static void writeStarTreeNode(IndexOutput output, InMemoryTreeNode node, int firstChildId, int lastChildId) throws IOException {
        output.writeInt(node.getDimensionId());
        output.writeLong(node.getDimensionValue());
        output.writeInt(node.getStartDocId());
        output.writeInt(node.getEndDocId());
        output.writeInt(node.getAggregatedDocId());
        output.writeByte(node.getNodeType());
        output.writeInt(firstChildId);
        output.writeInt(lastChildId);
    }
}

