# _ActorStats
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-1)</span>

Pony struct for the Pony actor stats C struct that can be used to
inspect statistics about an actor.


```pony
struct ref _ActorStats
```

## Constructors

### create
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-1)</span>


```pony
new iso create()
: _ActorStats iso^
```

#### Returns

* [_ActorStats](runtime_info-_ActorStats.md) iso^

---

## Public fields

### var heap_mem_allocated: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-7)</span>

Memory currently allocated by objects on the actor heap




---

### var heap_mem_used: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-12)</span>

Memory currently used by objects on the actor heap




---

### var heap_num_allocated: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-17)</span>

Number of objects currently on the actor heap




---

### var heap_realloc_counter: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-22)</span>

Number of heap re-allocations made on the actor heap during the
lifetime of the actor




---

### var heap_alloc_counter: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-28)</span>

Number of heap allocations made on the actor heap during the
lifetime of the actor




---

### var heap_free_counter: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-34)</span>

Number of heap allocations freed on the actor heap during the
lifetime of the actor




---

### var heap_gc_counter: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-40)</span>

Number of times the heap has been garbage collected




---

### var system_cpu: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-45)</span>

Amount of cpu used to process system messages




---

### var app_cpu: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-50)</span>

Amount of cpu used to process app messages




---

### var gc_mark_cpu: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-55)</span>

Amount of cpu used for mark phase to garbage collect actor heap




---

### var gc_sweep_cpu: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-60)</span>

Amount of cpu used for sweep phase to garbage collect actor heap




---

### var messages_sent_counter: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-65)</span>

Number of messages the actor has sent




---

### var system_messages_processed_counter: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-70)</span>

Number of system messages the actor has processed




---

### var app_messages_processed_counter: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-75)</span>

Number of app messages the actor has processed




---

### var foreign_actormap_objectmap_mem_used: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-80)</span>

Memory in use by the objectmaps stored in the foreign actormap




---

### var foreign_actormap_objectmap_mem_allocated: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_actor_stats.md#L-0-85)</span>

Memory allocated by the objectmaps stored in the foreign actormap




---

