/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.messages;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.editorconfig.common.plugin.EditorConfigFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.io.IOException;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.filetype.EditorConfigFileConstants;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J,\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0017\u0010\u0016\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002R!\u0010\u001f\u001a\u0015\u0012\f\u0012\n !*\u0004\u0018\u00010\u001d0\u001d0 \u00a2\u0006\u0002\b\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/editorconfig/language/messages/EditorConfigWrongFileNameNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createNotificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "fileEditor", "renameAction", "Lcom/intellij/ui/EditorNotificationPanel$ActionHandler;", "createRenameAction", "buildPanel", "editor", "Lcom/intellij/openapi/editor/Editor;", "findEditorConfig", "Lorg/jetbrains/annotations/Nullable;", "error", "", "message", "", "nameMatches", "", "update", "HIDDEN_KEY", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.editorconfig.backend"})
public final class EditorConfigWrongFileNameNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    @NotNull
    private final Key<Boolean> HIDDEN_KEY;

    public EditorConfigWrongFileNameNotificationProvider() {
        Key key = Key.create((String)"editorconfig.wrong.name.notification.hidden");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.HIDDEN_KEY = key;
    }

    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (PropertiesComponent.getInstance().isTrueValue("editorconfig.wrong.name.notification.disabled")) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)file.getExtension(), (Object)EditorConfigFileType.INSTANCE.getFileExtension())) {
            return null;
        }
        if (this.nameMatches(file)) {
            return null;
        }
        EditorNotificationPanel.ActionHandler renameAction = this.createRenameAction(project, file);
        return arg_0 -> EditorConfigWrongFileNameNotificationProvider.collectNotificationData$lambda$0(this, file, project, renameAction, arg_0);
    }

    private final EditorNotificationPanel createNotificationPanel(VirtualFile file, FileEditor fileEditor, Project project, EditorNotificationPanel.ActionHandler renameAction) {
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        if (editor2.getUserData(this.HIDDEN_KEY) != null) {
            return null;
        }
        return this.buildPanel(editor2, file, project, renameAction);
    }

    private final EditorNotificationPanel.ActionHandler createRenameAction(Project project, VirtualFile file) {
        if (this.findEditorConfig(file) == null) {
            Runnable fn = () -> EditorConfigWrongFileNameNotificationProvider.createRenameAction$lambda$0(file, this, project);
            return new EditorNotificationPanel.ActionHandler(fn){
                final /* synthetic */ Runnable $fn;
                {
                    this.$fn = $fn;
                }

                public void handlePanelActionClick(EditorNotificationPanel panel, HyperlinkEvent event) {
                    Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.$fn.run();
                }

                public void handleQuickFixClick(Editor editor, PsiFile psiFile) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                    this.$fn.run();
                }

                public IntentionPreviewInfo generatePreview(Editor editor, PsiFile psiFile) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                    IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.rename((PsiFile)psiFile, (String)EditorConfigFileConstants.INSTANCE.getFILE_NAME());
                    Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"rename(...)");
                    return intentionPreviewInfo;
                }
            };
        }
        return null;
    }

    private final EditorNotificationPanel buildPanel(Editor editor, VirtualFile file, Project project, EditorNotificationPanel.ActionHandler renameAction) {
        EditorNotificationPanel result2 = new EditorNotificationPanel(editor, null, null, EditorNotificationPanel.Status.Warning);
        if (renameAction != null) {
            String rename = EditorConfigBundle.INSTANCE.get("notification.action.rename", new Object[0]);
            result2.createActionLabel(rename, renameAction, true);
        }
        String hide = EditorConfigBundle.INSTANCE.get("notification.action.hide.once", new Object[0]);
        result2.createActionLabel(hide, () -> EditorConfigWrongFileNameNotificationProvider.buildPanel$lambda$0(editor, this, file, project));
        String hideForever = EditorConfigBundle.INSTANCE.get("notification.action.hide.forever", new Object[0]);
        result2.createActionLabel(hideForever, () -> EditorConfigWrongFileNameNotificationProvider.buildPanel$lambda$1(this, file, project));
        EditorNotificationPanel editorNotificationPanel = result2.text(EditorConfigBundle.INSTANCE.get("notification.rename.message", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)editorNotificationPanel, (String)"text(...)");
        return editorNotificationPanel;
    }

    private final VirtualFile findEditorConfig(VirtualFile file) {
        return file.getParent().findChild(EditorConfigFileConstants.INSTANCE.getFILE_NAME());
    }

    private final void error(@Nls String message, Project project) {
        Notification notification = new Notification("editorconfig", "EditorConfig", message, NotificationType.ERROR);
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    private final boolean nameMatches(VirtualFile file) {
        return Intrinsics.areEqual((Object)file.getNameWithoutExtension(), (Object)"");
    }

    private final void update(VirtualFile file, Project project) {
        EditorNotifications.getInstance((Project)project).updateNotifications(file);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$0(EditorConfigWrongFileNameNotificationProvider this$0, VirtualFile $file, Project $project, EditorNotificationPanel.ActionHandler $renameAction, FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createNotificationPanel($file, it, $project, $renameAction);
    }

    private static final void createRenameAction$lambda$0(VirtualFile $file, EditorConfigWrongFileNameNotificationProvider this$0, Project $project) {
        if (ActionsKt.runReadAction(() -> EditorConfigWrongFileNameNotificationProvider.createRenameAction$lambda$0$0(this$0, $file)) != null) {
            $file.getParent().findChild(EditorConfigFileConstants.INSTANCE.getFILE_NAME());
            String message = EditorConfigBundle.INSTANCE.get("notification.error.file.already.exists", new Object[0]);
            this$0.error(message, $project);
            return;
        }
        try {
            ActionsKt.runWriteAction(() -> EditorConfigWrongFileNameNotificationProvider.createRenameAction$lambda$0$1($file, this$0));
        }
        catch (IOException ex) {
            Object[] objectArray = new Object[1];
            String string = ex.getMessage();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            String message = EditorConfigBundle.INSTANCE.get("notification.error.ioexception", objectArray);
            throw new IllegalStateException(message.toString());
        }
        this$0.update($file, $project);
    }

    private static final VirtualFile createRenameAction$lambda$0$0(EditorConfigWrongFileNameNotificationProvider this$0, VirtualFile $file) {
        return this$0.findEditorConfig($file);
    }

    private static final Unit createRenameAction$lambda$0$1(VirtualFile $file, EditorConfigWrongFileNameNotificationProvider this$0) {
        $file.rename((Object)this$0, EditorConfigFileConstants.INSTANCE.getFILE_NAME());
        return Unit.INSTANCE;
    }

    private static final void buildPanel$lambda$0(Editor $editor, EditorConfigWrongFileNameNotificationProvider this$0, VirtualFile $file, Project $project) {
        $editor.putUserData(this$0.HIDDEN_KEY, (Object)true);
        this$0.update($file, $project);
    }

    private static final void buildPanel$lambda$1(EditorConfigWrongFileNameNotificationProvider this$0, VirtualFile $file, Project $project) {
        PropertiesComponent.getInstance().setValue("editorconfig.wrong.name.notification.disabled", true);
        this$0.update($file, $project);
    }
}

