from cffi import FFI

ffi = FFI()

ffi.set_source("_syslog_cffi", """
#include <syslog.h>

#ifndef LOG_NOWAIT
#define LOG_NOWAIT -919919
#endif
#ifndef LOG_PERROR
#define LOG_PERROR -919919
#endif
#ifndef LOG_SYSLOG
#define LOG_SYSLOG LOG_DAEMON
#endif
#ifndef LOG_CRON
#define LOG_CRON LOG_DAEMON
#endif
#ifndef LOG_UUCP
#define LOG_UUCP LOG_MAIL
#endif
#ifndef LOG_NEWS
#define LOG_NEWS LOG_MAIL
#endif
""")

ffi.cdef("""
/* mandatory constants */
#define LOG_EMERG ...
#define LOG_ALERT ...
#define LOG_CRIT ...
#define LOG_ERR ...
#define LOG_WARNING ...
#define LOG_NOTICE ...
#define LOG_INFO ...
#define LOG_DEBUG ...

#define LOG_PID ...
#define LOG_CONS ...
#define LOG_NDELAY ...

#define LOG_KERN ...
#define LOG_USER ...
#define LOG_MAIL ...
#define LOG_DAEMON ...
#define LOG_AUTH ...
#define LOG_LPR ...
#define LOG_LOCAL0 ...
#define LOG_LOCAL1 ...
#define LOG_LOCAL2 ...
#define LOG_LOCAL3 ...
#define LOG_LOCAL4 ...
#define LOG_LOCAL5 ...
#define LOG_LOCAL6 ...
#define LOG_LOCAL7 ...

/* optional constants, gets defined to -919919 if missing */
#define LOG_NOWAIT ...
#define LOG_PERROR ...

/* aliased constants, gets defined as some other constant if missing */
#define LOG_SYSLOG ...
#define LOG_CRON ...
#define LOG_UUCP ...
#define LOG_NEWS ...

/* functions */
void openlog(const char *ident, int option, int facility);
void syslog(int priority, const char *format, const char *string);
// NB. the signature of syslog() is specialized to the only case we use
void closelog(void);
int setlogmask(int mask);
""")

if __name__ == "__main__":
    ffi.compile()
