/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.io.ByteArrayInputStream;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkSingle;

public class PngChunkIHDR
extends PngChunkSingle {
    public static final String ID = "IHDR";
    private int cols;
    private int rows;
    private int bitspc;
    private int colormodel;
    private int compmeth;
    private int filmeth;
    private int interlaced;

    public PngChunkIHDR(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NA;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = new ChunkRaw(13, ChunkHelper.b_IHDR, true);
        int n = 0;
        PngHelperInternal.writeInt4tobytes(this.cols, chunkRaw.data, n);
        PngHelperInternal.writeInt4tobytes(this.rows, chunkRaw.data, n += 4);
        n += 4;
        chunkRaw.data[n++] = (byte)this.bitspc;
        chunkRaw.data[n++] = (byte)this.colormodel;
        chunkRaw.data[n++] = (byte)this.compmeth;
        chunkRaw.data[n++] = (byte)this.filmeth;
        chunkRaw.data[n++] = (byte)this.interlaced;
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 13) {
            throw new PngjException("Bad IDHR len " + chunkRaw.len);
        }
        ByteArrayInputStream byteArrayInputStream = chunkRaw.getAsByteStream();
        this.cols = PngHelperInternal.readInt4(byteArrayInputStream);
        this.rows = PngHelperInternal.readInt4(byteArrayInputStream);
        this.bitspc = PngHelperInternal.readByte(byteArrayInputStream);
        this.colormodel = PngHelperInternal.readByte(byteArrayInputStream);
        this.compmeth = PngHelperInternal.readByte(byteArrayInputStream);
        this.filmeth = PngHelperInternal.readByte(byteArrayInputStream);
        this.interlaced = PngHelperInternal.readByte(byteArrayInputStream);
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkIHDR pngChunkIHDR = (PngChunkIHDR)pngChunk;
        this.cols = pngChunkIHDR.cols;
        this.rows = pngChunkIHDR.rows;
        this.bitspc = pngChunkIHDR.bitspc;
        this.colormodel = pngChunkIHDR.colormodel;
        this.compmeth = pngChunkIHDR.compmeth;
        this.filmeth = pngChunkIHDR.filmeth;
        this.interlaced = pngChunkIHDR.interlaced;
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int n) {
        this.cols = n;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public int getBitspc() {
        return this.bitspc;
    }

    public void setBitspc(int n) {
        this.bitspc = n;
    }

    public int getColormodel() {
        return this.colormodel;
    }

    public void setColormodel(int n) {
        this.colormodel = n;
    }

    public int getCompmeth() {
        return this.compmeth;
    }

    public void setCompmeth(int n) {
        this.compmeth = n;
    }

    public int getFilmeth() {
        return this.filmeth;
    }

    public void setFilmeth(int n) {
        this.filmeth = n;
    }

    public int getInterlaced() {
        return this.interlaced;
    }

    public void setInterlaced(int n) {
        this.interlaced = n;
    }
}

