/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import org.apache.tomcat.Jar;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.scan.JarFileUrlJar;
import org.apache.tomcat.util.scan.JarFileUrlNestedJar;
import org.apache.tomcat.util.scan.UrlJar;

public class JarFactory {
    private JarFactory() {
    }

    public static Jar newInstance(URL uRL) throws IOException {
        String string = uRL.toString();
        if (string.startsWith("jar:file:")) {
            if (string.endsWith("!/")) {
                return new JarFileUrlJar(uRL, true);
            }
            return new JarFileUrlNestedJar(uRL);
        }
        if (string.startsWith("war:file:")) {
            URL uRL2 = UriUtil.warToJar((URL)uRL);
            return new JarFileUrlNestedJar(uRL2);
        }
        if (string.startsWith("file:")) {
            return new JarFileUrlJar(uRL, false);
        }
        return new UrlJar(uRL);
    }

    public static URL getJarEntryURL(URL uRL, String string) throws MalformedURLException {
        String string2 = uRL.toExternalForm();
        if (string2.startsWith("jar")) {
            string2 = string2.replaceFirst("^jar:", "war:");
            string2 = string2.replaceFirst("!/", Matcher.quoteReplacement(UriUtil.getWarSeparator()));
        }
        return new URL("jar:" + string2 + "!/" + string);
    }
}

