/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.Command;

public class InitiateProfilingCommand
extends Command {
    private String[] classNames;
    private String[] profilingPointHandlers;
    private int[] profilingPointIDs;
    private String[] profilingPointInfos;
    private boolean instrSpawnedThreads;
    private boolean startProfilingPointsActive;
    private int instrType;

    public InitiateProfilingCommand(int instrType, String[] classNames, int[] ppIDs, String[] ppHandlers, String[] ppInfos, boolean instrSpawnedThreads, boolean startProfilingPointsActive) {
        super(13);
        if (classNames == null) {
            classNames = new String[]{" "};
        } else if (classNames[0] == null) {
            classNames[0] = " ";
        }
        this.instrType = instrType;
        this.classNames = classNames;
        this.profilingPointIDs = ppIDs;
        this.profilingPointHandlers = ppHandlers;
        this.profilingPointInfos = ppInfos;
        this.instrSpawnedThreads = instrSpawnedThreads;
        this.startProfilingPointsActive = startProfilingPointsActive;
    }

    public InitiateProfilingCommand(int instrType, String className, boolean instrSpawnedThreads, boolean startProfilingPointsActive) {
        String[] stringArray;
        if (className == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = " ";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = className;
        }
        this(instrType, stringArray, null, null, null, instrSpawnedThreads, startProfilingPointsActive);
    }

    public InitiateProfilingCommand(int instrType, String className) {
        this(instrType, className, false, false);
    }

    public InitiateProfilingCommand(int instrType) {
        this(instrType, null);
    }

    InitiateProfilingCommand() {
        super(13);
    }

    public boolean getInstrSpawnedThreads() {
        return this.instrSpawnedThreads;
    }

    public void setInstrType(int t) {
        this.instrType = t;
    }

    public int getInstrType() {
        return this.instrType;
    }

    public String[] getProfilingPointHandlers() {
        return this.profilingPointHandlers;
    }

    public int[] getProfilingPointIDs() {
        return this.profilingPointIDs;
    }

    public String[] getProfilingPointInfos() {
        return this.profilingPointInfos;
    }

    public String getRootClassName() {
        return this.classNames[0];
    }

    public String[] getRootClassNames() {
        return this.classNames;
    }

    public boolean isStartProfilingPointsActive() {
        return this.startProfilingPointsActive;
    }

    public String toString() {
        return super.toString() + ", instrType = " + this.instrType;
    }

    void readObject(ObjectInputStream in) throws IOException {
        this.instrType = in.readInt();
        int len = in.readInt();
        this.classNames = new String[len];
        for (int i = 0; i < len; ++i) {
            this.classNames[i] = in.readUTF().intern();
        }
        this.instrSpawnedThreads = in.readBoolean();
        this.startProfilingPointsActive = in.readBoolean();
        try {
            this.profilingPointIDs = (int[])in.readObject();
            this.profilingPointHandlers = (String[])in.readObject();
            this.profilingPointInfos = (String[])in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.instrType);
        out.writeInt(this.classNames.length);
        for (int i = 0; i < this.classNames.length; ++i) {
            out.writeUTF(this.classNames[i]);
        }
        out.writeBoolean(this.instrSpawnedThreads);
        out.writeBoolean(this.startProfilingPointsActive);
        out.writeObject(this.profilingPointIDs);
        out.writeObject(this.profilingPointHandlers);
        out.writeObject(this.profilingPointInfos);
    }
}

