/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.views.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.views.monitor.ApplicationMonitorModel;
import org.graalvm.visualvm.charts.ChartFactory;
import org.graalvm.visualvm.charts.SimpleXYChartDescriptor;
import org.graalvm.visualvm.charts.SimpleXYChartSupport;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.DataRemovedListener;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.NotSupportedDisplayer;
import org.graalvm.visualvm.heapdump.HeapDumpSupport;
import org.graalvm.visualvm.uisupport.HTMLTextArea;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

class ApplicationMonitorView
extends DataSourceView {
    private static final Logger LOGGER = Logger.getLogger(ApplicationMonitorView.class.getName());
    private static final String UNKNOWN = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Unknown");
    private static final String IMAGE_PATH = "org/graalvm/visualvm/application/views/resources/monitor.png";
    private final ApplicationMonitorModel model;

    ApplicationMonitorView(ApplicationMonitorModel model) {
        super(model.getSource(), NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Monitor"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 20, false);
        this.model = model;
    }

    protected void willBeAdded() {
        this.model.initialize();
    }

    protected void removed() {
        this.model.cleanup();
    }

    ApplicationMonitorModel getModel() {
        return this.model;
    }

    protected DataViewComponent createComponent() {
        final MasterViewSupport masterViewSupport = new MasterViewSupport(this.model);
        DataViewComponent dvc = new DataViewComponent(masterViewSupport.getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        final CpuViewSupport cpuViewSupport = new CpuViewSupport(this.model);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Cpu"), true), 1);
        dvc.addDetailsView(cpuViewSupport.getDetailsView(), 1);
        final HeapViewSupport heapViewSupport = new HeapViewSupport(this.model);
        final PermGenViewSupport permGenViewSupport = this.model.isMemoryMonitoringSupported() ? new PermGenViewSupport(this.model) : null;
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Memory"), true), 2);
        dvc.addDetailsView(heapViewSupport.getDetailsView(), 2);
        if (permGenViewSupport != null) {
            dvc.addDetailsView(permGenViewSupport.getDetailsView(), 2);
        }
        final ClassesViewSupport classesViewSupport = new ClassesViewSupport(this.model);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Classes"), true), 3);
        dvc.addDetailsView(classesViewSupport.getDetailsView(), 3);
        final ThreadsViewSupport threadsViewSupport = new ThreadsViewSupport(this.model);
        final VirtualThreadsViewSupport vThreadsViewSupport = this.model.isVirtualThreadsMonitoringSupported() ? new VirtualThreadsViewSupport(this.model) : null;
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Threads"), true), 4);
        dvc.addDetailsView(threadsViewSupport.getDetailsView(), 4);
        if (vThreadsViewSupport != null) {
            dvc.addDetailsView(vThreadsViewSupport.getDetailsView(), 4);
        }
        final Runnable refresher = new Runnable(){

            @Override
            public void run() {
                masterViewSupport.refresh(ApplicationMonitorView.this.model);
                cpuViewSupport.refresh(ApplicationMonitorView.this.model);
                heapViewSupport.refresh(ApplicationMonitorView.this.model);
                if (permGenViewSupport != null) {
                    permGenViewSupport.refresh(ApplicationMonitorView.this.model);
                }
                classesViewSupport.refresh(ApplicationMonitorView.this.model);
                threadsViewSupport.refresh(ApplicationMonitorView.this.model);
                if (vThreadsViewSupport != null) {
                    vThreadsViewSupport.refresh(ApplicationMonitorView.this.model);
                }
            }
        };
        refresher.run();
        this.model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                refresher.run();
            }
        });
        return dvc;
    }

    private static class VirtualThreadsViewSupport
    extends JPanel {
        private static final String PARALLELISM = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Parallelism");
        private static final String POOL_SIZE = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Pool_size");
        private static final String MOUNTED_VT_COUNT = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Mounted_virtual_thread_count");
        private static final String MOUNTED_VT_COUNT_LEG = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Mounted_virtual_thread_count_leg");
        private static final String QUEUED_VT_COUNT = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Queued_virtual_thread_count");
        private static final String QUEUED_VT_COUNT_LEG = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Queued_virtual_thread_count_leg");
        private static final String VIRTUAL_THREADS = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Virtual_Threads");
        private boolean liveModel;
        private boolean virtualThreadsMonitoringSupported;
        private SimpleXYChartSupport chartSupport;

        VirtualThreadsViewSupport(ApplicationMonitorModel model) {
            this.initModels(model);
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(VIRTUAL_THREADS, null, 10, (JComponent)this, null);
        }

        public void refresh(ApplicationMonitorModel model) {
            int parallelism = model.getParallelism();
            int poolSize = model.getPoolSize();
            int mountedVirtualThreadCount = model.getMountedVirtualThreadCount();
            long queuedVirtualThreadCount = model.getQueuedVirtualThreadCount();
            if (this.liveModel) {
                this.chartSupport.addValues(model.getTimestamp(), new long[]{mountedVirtualThreadCount, queuedVirtualThreadCount});
            }
            this.chartSupport.updateDetails(new String[]{this.chartSupport.formatDecimal((long)parallelism), this.chartSupport.formatDecimal((long)poolSize), this.chartSupport.formatDecimal((long)mountedVirtualThreadCount), this.chartSupport.formatDecimal(queuedVirtualThreadCount)});
        }

        private void initModels(ApplicationMonitorModel model) {
            this.liveModel = model.isLive();
            this.virtualThreadsMonitoringSupported = model.isVirtualThreadsMonitoringSupported();
            if (this.virtualThreadsMonitoringSupported) {
                SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.decimal((long)3L, (boolean)false, (int)model.getChartCache());
                chartDescriptor.addLineItems(new String[]{MOUNTED_VT_COUNT_LEG, QUEUED_VT_COUNT_LEG});
                chartDescriptor.setDetailsItems(new String[]{PARALLELISM, POOL_SIZE, MOUNTED_VT_COUNT, QUEUED_VT_COUNT});
                this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
                model.registerThreadsChartSupport(this.chartSupport);
                this.chartSupport.setZoomingEnabled(!this.liveModel);
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.add((Component)this.chartSupport.getChart(), "Center");
            this.chartSupport.updateDetails(new String[]{UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN});
        }
    }

    private static class ThreadsViewSupport
    extends JPanel {
        private static final String LIVE = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Live_threads");
        private static final String LIVE_LEG = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Live_threads_leg");
        private static final String DAEMON = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Daemon_threads");
        private static final String DAEMON_LEG = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Daemon_threads_leg");
        private static final String PEAK = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Live_threads_peak");
        private static final String STARTED = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Started_threads_total");
        private boolean liveModel;
        private boolean threadsMonitoringSupported;
        private SimpleXYChartSupport chartSupport;

        ThreadsViewSupport(ApplicationMonitorModel model) {
            this.initModels(model);
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Threads"), null, 10, (JComponent)this, null);
        }

        public void refresh(ApplicationMonitorModel model) {
            if (this.threadsMonitoringSupported) {
                long totalThreads = model.getTotalThreads();
                long daemonThreads = model.getDeamonThreads();
                long peakThreads = model.getPeakThreads();
                long startedThreads = model.getStartedThreads();
                if (this.liveModel) {
                    this.chartSupport.addValues(model.getTimestamp(), new long[]{totalThreads, daemonThreads});
                }
                this.chartSupport.updateDetails(new String[]{this.chartSupport.formatDecimal(totalThreads), this.chartSupport.formatDecimal(daemonThreads), this.chartSupport.formatDecimal(peakThreads), this.chartSupport.formatDecimal(startedThreads)});
            }
        }

        private void initModels(ApplicationMonitorModel model) {
            this.liveModel = model.isLive();
            this.threadsMonitoringSupported = model.isThreadsMonitoringSupported();
            if (this.threadsMonitoringSupported) {
                SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.decimal((long)3L, (boolean)false, (int)model.getChartCache());
                chartDescriptor.addLineItems(new String[]{LIVE_LEG, DAEMON_LEG});
                chartDescriptor.setDetailsItems(new String[]{LIVE, DAEMON, PEAK, STARTED});
                this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
                model.registerThreadsChartSupport(this.chartSupport);
                this.chartSupport.setZoomingEnabled(!this.liveModel);
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.threadsMonitoringSupported) {
                this.add((Component)this.chartSupport.getChart(), "Center");
                this.chartSupport.updateDetails(new String[]{UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN});
            } else {
                this.add((Component)new NotSupportedDisplayer(NotSupportedDisplayer.JVM), "Center");
            }
        }
    }

    private static class ClassesViewSupport
    extends JPanel {
        private static final String TOTAL_LOADED = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Total_loaded_classes");
        private static final String TOTAL_LOADED_LEG = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Total_loaded_classes_leg");
        private static final String SHARED_LOADED = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Shared_loaded_classes");
        private static final String SHARED_LOADED_LEG = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Shared_loaded_classes_leg");
        private static final String TOTAL_UNLOADED = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Total_unloaded_classes");
        private static final String SHARED_UNLOADED = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Shared_unloaded_classes");
        private boolean liveModel;
        private boolean classMonitoringSupported;
        private SimpleXYChartSupport chartSupport;

        ClassesViewSupport(ApplicationMonitorModel model) {
            this.initModels(model);
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Classes"), null, 10, (JComponent)this, null);
        }

        public void refresh(ApplicationMonitorModel model) {
            if (this.classMonitoringSupported) {
                long sharedUnloaded = model.getSharedUnloaded();
                long totalUnloaded = model.getTotalUnloaded();
                long sharedClasses = model.getSharedLoaded() - sharedUnloaded;
                long totalClasses = model.getTotalLoaded() - totalUnloaded + sharedClasses;
                if (this.liveModel) {
                    this.chartSupport.addValues(model.getTimestamp(), new long[]{totalClasses, sharedClasses});
                }
                this.chartSupport.updateDetails(new String[]{this.chartSupport.formatDecimal(totalClasses), this.chartSupport.formatDecimal(sharedClasses), this.chartSupport.formatDecimal(totalUnloaded), this.chartSupport.formatDecimal(sharedUnloaded)});
            }
        }

        private void initModels(ApplicationMonitorModel model) {
            this.liveModel = model.isLive();
            this.classMonitoringSupported = model.isClassMonitoringSupported();
            if (this.classMonitoringSupported) {
                SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.decimal((long)100L, (boolean)false, (int)model.getChartCache());
                chartDescriptor.addLineItems(new String[]{TOTAL_LOADED_LEG, SHARED_LOADED_LEG});
                chartDescriptor.setDetailsItems(new String[]{TOTAL_LOADED, SHARED_LOADED, TOTAL_UNLOADED, SHARED_UNLOADED});
                this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
                model.registerClassesChartSupport(this.chartSupport);
                this.chartSupport.setZoomingEnabled(!this.liveModel);
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.classMonitoringSupported) {
                this.add((Component)this.chartSupport.getChart(), "Center");
                this.chartSupport.updateDetails(new String[]{UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN});
            } else {
                this.add((Component)new NotSupportedDisplayer(NotSupportedDisplayer.JVM), "Center");
            }
        }
    }

    private static class PermGenViewSupport
    extends JPanel {
        private boolean liveModel;
        private boolean memoryMonitoringSupported;
        private String permgenName;
        private SimpleXYChartSupport chartSupport;

        PermGenViewSupport(ApplicationMonitorModel model) {
            this.initModels(model);
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(this.permgenName, null, 10, (JComponent)this, null);
        }

        public void refresh(ApplicationMonitorModel model) {
            if (this.memoryMonitoringSupported) {
                long permgenCapacity = model.getPermgenCapacity();
                long permgenUsed = model.getPermgenUsed();
                long permgenMax = model.getPermgenMax();
                if (this.liveModel) {
                    this.chartSupport.addValues(model.getTimestamp(), new long[]{permgenCapacity, permgenUsed});
                }
                this.chartSupport.updateDetails(new String[]{this.chartSupport.formatBytes(permgenCapacity), this.chartSupport.formatBytes(permgenUsed), this.chartSupport.formatBytes(permgenMax)});
            }
        }

        private void initModels(ApplicationMonitorModel model) {
            this.liveModel = model.isLive();
            this.memoryMonitoringSupported = model.isMemoryMonitoringSupported();
            this.permgenName = model.getPermgenName();
            if (this.memoryMonitoringSupported) {
                String PERM_SIZE = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_PermGen_size");
                String PERM_SIZE_LEG = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_PermGen_size_leg", (Object)this.permgenName);
                String USED_PERM = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Used_PermGen");
                String USED_PERM_LEG = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Used_PermGen_leg", (Object)this.permgenName);
                String MAX_PERM = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Max_PermGen_size");
                long permgenMax = model.getPermgenMax();
                SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.bytes((long)0xA00000L, (boolean)false, (int)model.getChartCache());
                chartDescriptor.addLineFillItems(new String[]{PERM_SIZE_LEG, USED_PERM_LEG});
                chartDescriptor.setDetailsItems(new String[]{PERM_SIZE, USED_PERM, MAX_PERM});
                if (permgenMax != -1L) {
                    chartDescriptor.setLimitYValue(permgenMax);
                }
                this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
                model.registerPermGenChartSupport(this.chartSupport);
                this.chartSupport.setZoomingEnabled(!this.liveModel);
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.memoryMonitoringSupported) {
                this.add((Component)this.chartSupport.getChart(), "Center");
                this.chartSupport.updateDetails(new String[]{UNKNOWN, UNKNOWN, UNKNOWN});
            } else {
                this.add((Component)new NotSupportedDisplayer(NotSupportedDisplayer.JVM), "Center");
            }
        }
    }

    private static class HeapViewSupport
    extends JPanel {
        private boolean liveModel;
        private boolean memoryMonitoringSupported;
        private String heapName;
        private SimpleXYChartSupport chartSupport;

        HeapViewSupport(ApplicationMonitorModel model) {
            this.initModels(model);
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(this.heapName, null, 10, (JComponent)this, null);
        }

        public void refresh(ApplicationMonitorModel model) {
            if (this.memoryMonitoringSupported) {
                long heapCapacity = model.getHeapCapacity();
                long heapUsed = model.getHeapUsed();
                long maxHeap = model.getMaxHeap();
                if (this.liveModel) {
                    this.chartSupport.addValues(model.getTimestamp(), new long[]{heapCapacity, heapUsed});
                }
                this.chartSupport.updateDetails(new String[]{this.chartSupport.formatBytes(heapCapacity), this.chartSupport.formatBytes(heapUsed), this.chartSupport.formatBytes(maxHeap)});
            }
        }

        private void initModels(ApplicationMonitorModel model) {
            this.liveModel = model.isLive();
            this.memoryMonitoringSupported = model.isMemoryMonitoringSupported();
            String string = this.heapName = this.memoryMonitoringSupported ? model.getHeapName() : NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Memory");
            if (this.memoryMonitoringSupported) {
                String HEAP_SIZE = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Heap_size");
                String HEAP_SIZE_LEG = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Heap_size_leg", (Object)this.heapName);
                String USED_HEAP = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Used_heap");
                String USED_HEAP_LEG = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Used_heap_leg", (Object)this.heapName.toLowerCase());
                String MAX_HEAP = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Max_Heap");
                SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.bytes((long)0xA00000L, (boolean)false, (int)model.getChartCache());
                chartDescriptor.addLineFillItems(new String[]{HEAP_SIZE_LEG, USED_HEAP_LEG});
                chartDescriptor.setDetailsItems(new String[]{HEAP_SIZE, USED_HEAP, MAX_HEAP});
                chartDescriptor.setLimitYValue(model.getMaxHeap());
                this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
                model.registerHeapChartSupport(this.chartSupport);
                this.chartSupport.setZoomingEnabled(!this.liveModel);
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.memoryMonitoringSupported) {
                this.add((Component)this.chartSupport.getChart(), "Center");
                this.chartSupport.updateDetails(new String[]{UNKNOWN, UNKNOWN, UNKNOWN});
            } else {
                this.add((Component)new NotSupportedDisplayer(NotSupportedDisplayer.JVM), "Center");
            }
        }
    }

    private static class CpuViewSupport
    extends JPanel {
        private static final String CPU = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Cpu");
        private static final String CPU_USAGE = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Cpu_Usage");
        private static final String GC_USAGE = NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Gc_Usage");
        private boolean liveModel;
        private int processorsCount;
        private boolean cpuMonitoringSupported;
        private boolean gcMonitoringSupported;
        private SimpleXYChartSupport chartSupport;

        CpuViewSupport(ApplicationMonitorModel model) {
            this.initModels(model);
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(CPU, null, 10, (JComponent)this, null);
        }

        public void refresh(ApplicationMonitorModel model) {
            if (this.cpuMonitoringSupported || this.gcMonitoringSupported) {
                long prevProcessGcTime;
                long upTime = model.getUpTime() * 1000000L;
                long prevUpTime = model.getPrevUpTime() * 1000000L;
                boolean tracksProcessCpuTime = this.cpuMonitoringSupported && model.getPrevProcessCpuTime() != -1L;
                long processCpuTime = tracksProcessCpuTime ? model.getProcessCpuTime() / (long)this.processorsCount : -1L;
                long prevProcessCpuTime = tracksProcessCpuTime ? model.getPrevProcessCpuTime() / (long)this.processorsCount : -1L;
                boolean tracksProcessGcTime = this.gcMonitoringSupported && model.getPrevProcessGcTime() != -1L;
                long processGcTime = tracksProcessGcTime ? model.getProcessGcTime() * 1000000L / (long)this.processorsCount : -1L;
                long l = prevProcessGcTime = tracksProcessGcTime ? model.getPrevProcessGcTime() * 1000000L / (long)this.processorsCount : -1L;
                if (prevUpTime != -1L && (tracksProcessCpuTime || tracksProcessGcTime)) {
                    long upTimeDiff = upTime - prevUpTime;
                    long cpuUsage = -1L;
                    long gcUsage = -1L;
                    String cpuDetail = UNKNOWN;
                    String gcDetail = UNKNOWN;
                    if (tracksProcessCpuTime) {
                        long processTimeDiff = processCpuTime - prevProcessCpuTime;
                        cpuUsage = upTimeDiff > 0L ? Math.min((long)(1000.0f * (float)processTimeDiff / (float)upTimeDiff), 1000L) : 0L;
                        String string = cpuDetail = cpuUsage == -1L ? UNKNOWN : this.chartSupport.formatPercent(cpuUsage);
                    }
                    if (tracksProcessGcTime) {
                        long processGcTimeDiff = processGcTime - prevProcessGcTime;
                        long l2 = gcUsage = upTimeDiff > 0L ? Math.min((long)(1000.0f * (float)processGcTimeDiff / (float)upTimeDiff), 1000L) : 0L;
                        if (cpuUsage != -1L && cpuUsage < gcUsage) {
                            gcUsage = cpuUsage;
                        }
                        String string = gcDetail = gcUsage == -1L ? UNKNOWN : this.chartSupport.formatPercent(gcUsage);
                    }
                    if (this.liveModel) {
                        this.chartSupport.addValues(model.getTimestamp(), new long[]{Math.max(cpuUsage, 0L), Math.max(gcUsage, 0L)});
                    }
                    this.chartSupport.updateDetails(new String[]{cpuDetail, gcDetail});
                }
            }
        }

        private void initModels(ApplicationMonitorModel model) {
            this.liveModel = model.isLive();
            this.processorsCount = model.getProcessorsCount();
            this.cpuMonitoringSupported = model.isCpuMonitoringSupported();
            this.gcMonitoringSupported = model.isGcMonitoringSupported();
            if (this.cpuMonitoringSupported || this.gcMonitoringSupported) {
                SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.percent((boolean)false, (double)0.1, (int)model.getChartCache());
                chartDescriptor.addLineItems(new String[]{CPU_USAGE, GC_USAGE});
                chartDescriptor.setDetailsItems(new String[]{CPU_USAGE, GC_USAGE});
                this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
                model.registerCpuChartSupport(this.chartSupport);
                this.chartSupport.setZoomingEnabled(!this.liveModel);
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.cpuMonitoringSupported || this.gcMonitoringSupported) {
                this.add((Component)this.chartSupport.getChart(), "Center");
                this.chartSupport.updateDetails(new String[]{UNKNOWN, UNKNOWN});
            } else {
                this.add((Component)new NotSupportedDisplayer(NotSupportedDisplayer.JVM), "Center");
            }
        }
    }

    private static class MasterViewSupport
    extends JPanel
    implements DataRemovedListener<DataSource>,
    PropertyChangeListener {
        private HTMLTextArea area;
        private JButton gcButton;
        private JButton heapDumpButton;

        MasterViewSupport(ApplicationMonitorModel model) {
            this.initComponents(model);
        }

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Monitor"), null, (JComponent)this);
        }

        public void refresh(ApplicationMonitorModel model) {
            int selStart = this.area.getSelectionStart();
            int selEnd = this.area.getSelectionEnd();
            this.area.setText(this.getBasicTelemetry(model));
            this.area.select(selStart, selEnd);
        }

        public void dataRemoved(DataSource dataSource) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    gcButton.setEnabled(false);
                    heapDumpButton.setEnabled(false);
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.dataRemoved(null);
        }

        private void initComponents(final ApplicationMonitorModel model) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea(this.getBasicTelemetry(model));
            this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)this.area, "Center");
            this.gcButton = new JButton(new AbstractAction(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Perform_GC")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new RequestProcessor("GC Processor").post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                model.getMemoryMXBean().gc();
                            }
                            catch (SecurityException ex) {
                                String err = NbBundle.getMessage(ApplicationMonitorView.class, (String)"TXT_Perform_GC_failed", (Object)ex.getLocalizedMessage());
                                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)err, 1);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                                gcButton.setEnabled(false);
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.WARNING, "initComponents", e);
                                gcButton.setEnabled(false);
                            }
                        }
                    });
                }
            });
            this.gcButton.setEnabled(model.getMemoryMXBean() != null);
            this.heapDumpButton = new JButton(new AbstractAction(NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Heap_Dump")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Application application = (Application)model.getSource();
                    boolean local = application.isLocalApplication();
                    boolean tagged = (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
                    HeapDumpSupport hds = HeapDumpSupport.getInstance();
                    if (local) {
                        hds.takeHeapDump(application, !tagged);
                    } else {
                        hds.takeRemoteHeapDump(application, null, !tagged);
                    }
                }
            });
            this.heapDumpButton.setEnabled(model.isTakeHeapDumpSupported());
            JPanel buttonsArea = new JPanel(new BorderLayout());
            buttonsArea.setOpaque(false);
            JPanel buttonsContainer = new JPanel(new BorderLayout(3, 0));
            buttonsContainer.setBackground(this.area.getBackground());
            buttonsContainer.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            buttonsContainer.add((Component)this.gcButton, "West");
            buttonsContainer.add((Component)this.heapDumpButton, "East");
            buttonsArea.add((Component)buttonsContainer, "North");
            this.add((Component)buttonsArea, "After");
            if (model.getSource() instanceof Application) {
                Application application = (Application)model.getSource();
                application.notifyWhenRemoved((DataRemovedListener)this);
                application.addPropertyChangeListener("prop_state", WeakListeners.propertyChange((PropertyChangeListener)this, (Object)application));
            }
        }

        private String getBasicTelemetry(ApplicationMonitorModel model) {
            String uptime = model.getUpTime() == -1L ? UNKNOWN : MasterViewSupport.getTime(model.getUpTime());
            return NbBundle.getMessage(ApplicationMonitorView.class, (String)"LBL_Uptime", (Object)uptime);
        }

        public static String getTime(long millis) {
            String sSeconds;
            long hours = millis / 3600000L;
            String sHours = hours == 0L ? "" : "" + hours;
            long minutes = (millis %= 3600000L) / 60000L;
            String sMinutes = hours > 0L && minutes < 10L ? "0" + minutes : "" + minutes;
            long seconds = (millis %= 60000L) / 1000L;
            String string = sSeconds = seconds < 10L ? "0" + seconds : "" + seconds;
            if (sHours.isEmpty()) {
                return NbBundle.getMessage(ApplicationMonitorView.class, (String)"FORMAT_ms", (Object[])new Object[]{sMinutes, sSeconds});
            }
            return NbBundle.getMessage(ApplicationMonitorView.class, (String)"FORMAT_hms", (Object[])new Object[]{sHours, sMinutes, sSeconds});
        }
    }
}

