/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.GraphPathImpl;

public class FloydWarshallShortestPaths<V, E> {
    private final Graph<V, E> graph;
    private final List<V> vertices;
    private final Map<V, Integer> vertexIndices;
    private int nShortestPaths = 0;
    private double diameter = Double.NaN;
    private double[][] d = null;
    private int[][] backtrace = null;
    private Map<V, List<GraphPath<V, E>>> paths = null;

    public FloydWarshallShortestPaths(Graph<V, E> graph) {
        this.graph = graph;
        this.vertices = new ArrayList<V>(graph.vertexSet());
        this.vertexIndices = new HashMap<V, Integer>(this.vertices.size());
        int i = 0;
        for (V vertex : this.vertices) {
            this.vertexIndices.put((Integer)vertex, i++);
        }
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public int getShortestPathsCount() {
        this.lazyCalculatePaths();
        return this.nShortestPaths;
    }

    private void lazyCalculateMatrix() {
        int i;
        if (this.d != null) {
            return;
        }
        int n = this.vertices.size();
        this.backtrace = new int[n][n];
        for (i = 0; i < n; ++i) {
            Arrays.fill(this.backtrace[i], -1);
        }
        this.d = new double[n][n];
        for (i = 0; i < n; ++i) {
            Arrays.fill(this.d[i], Double.POSITIVE_INFINITY);
        }
        for (i = 0; i < n; ++i) {
            this.d[i][i] = 0.0;
        }
        if (this.graph instanceof UndirectedGraph) {
            for (E edge : this.graph.edgeSet()) {
                int v_1 = this.vertexIndices.get(this.graph.getEdgeSource(edge));
                int v_2 = this.vertexIndices.get(this.graph.getEdgeTarget(edge));
                double d = this.graph.getEdgeWeight(edge);
                this.d[v_2][v_1] = d;
                this.d[v_1][v_2] = d;
                this.backtrace[v_1][v_2] = v_2;
                this.backtrace[v_2][v_1] = v_1;
            }
        } else {
            DirectedGraph directedGraph = (DirectedGraph)this.graph;
            for (Object v1 : directedGraph.vertexSet()) {
                int v_1 = this.vertexIndices.get(v1);
                for (Object v2 : Graphs.successorListOf(directedGraph, v1)) {
                    int v_2 = this.vertexIndices.get(v2);
                    this.d[v_1][v_2] = directedGraph.getEdgeWeight(directedGraph.getEdge(v1, v2));
                    this.backtrace[v_1][v_2] = v_2;
                }
            }
        }
        for (int k = 0; k < n; ++k) {
            for (int i2 = 0; i2 < n; ++i2) {
                for (int j = 0; j < n; ++j) {
                    double ik_kj = this.d[i2][k] + this.d[k][j];
                    if (!(ik_kj < this.d[i2][j])) continue;
                    this.d[i2][j] = ik_kj;
                    this.backtrace[i2][j] = this.backtrace[i2][k];
                }
            }
        }
    }

    public double shortestDistance(V a, V b) {
        this.lazyCalculateMatrix();
        return this.d[this.vertexIndices.get(a)][this.vertexIndices.get(b)];
    }

    public double getDiameter() {
        this.lazyCalculateMatrix();
        if (Double.isNaN(this.diameter)) {
            this.diameter = 0.0;
            int n = this.vertices.size();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (Double.isInfinite(this.d[i][j]) || !(this.d[i][j] > this.diameter)) continue;
                    this.diameter = this.d[i][j];
                }
            }
        }
        return this.diameter;
    }

    public GraphPath<V, E> getShortestPath(V a, V b) {
        this.lazyCalculateMatrix();
        int v_a = this.vertexIndices.get(a);
        int v_b = this.vertexIndices.get(b);
        if (this.backtrace[v_a][v_b] == -1) {
            return null;
        }
        ArrayList<E> edges = new ArrayList<E>();
        int u = v_a;
        while (u != v_b) {
            int v = this.backtrace[u][v_b];
            edges.add(this.graph.getEdge(this.vertices.get(u), this.vertices.get(v)));
            u = v;
        }
        return new GraphPathImpl<V, E>(this.graph, a, b, edges, this.d[v_a][v_b]);
    }

    public List<V> getShortestPathAsVertexList(V a, V b) {
        this.lazyCalculateMatrix();
        int v_a = this.vertexIndices.get(a);
        int v_b = this.vertexIndices.get(b);
        if (this.backtrace[v_a][v_b] == -1) {
            return null;
        }
        ArrayList<V> pathVertexList = new ArrayList<V>();
        pathVertexList.add(a);
        int u = v_a;
        while (u != v_b) {
            int v = this.backtrace[u][v_b];
            pathVertexList.add(this.vertices.get(v));
            u = v;
        }
        return pathVertexList;
    }

    public List<GraphPath<V, E>> getShortestPaths(V v) {
        this.lazyCalculatePaths();
        return Collections.unmodifiableList(this.paths.get(v));
    }

    public List<GraphPath<V, E>> getShortestPaths() {
        this.lazyCalculatePaths();
        ArrayList<GraphPath<V, GraphPath<V, E>>> allPaths = new ArrayList<GraphPath<V, GraphPath<V, E>>>();
        for (List<GraphPath<V, E>> pathSubset : this.paths.values()) {
            allPaths.addAll(pathSubset);
        }
        return allPaths;
    }

    private void lazyCalculatePaths() {
        if (this.paths != null) {
            return;
        }
        this.lazyCalculateMatrix();
        this.paths = new LinkedHashMap<V, List<GraphPath<V, E>>>();
        int n = this.vertices.size();
        for (int i = 0; i < n; ++i) {
            V v_i = this.vertices.get(i);
            this.paths.put(v_i, new ArrayList());
            for (int j = 0; j < n; ++j) {
                V v_j;
                GraphPath<V, E> path;
                if (i == j || (path = this.getShortestPath(v_i, v_j = this.vertices.get(j))) == null) continue;
                this.paths.get(v_i).add(path);
                ++this.nShortestPaths;
            }
        }
    }
}

