#*************************************************************************
#
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
# 
# Copyright 2008 by Sun Microsystems, Inc.
#
# OpenOffice.org - a multi-platform office productivity suite
#
# $RCSfile: target.mk,v $
#
# $Revision: 1.211.4.1 $
#
# This file is part of OpenOffice.org.
#
# OpenOffice.org is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# only, as published by the Free Software Foundation.
#
# OpenOffice.org is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License version 3 for more details
# (a copy is included in the LICENSE file that accompanied this code).
#
# You should have received a copy of the GNU Lesser General Public License
# version 3 along with OpenOffice.org.  If not, see
# <http://www.openoffice.org/license.html>
# for a copy of the LGPLv3 License.
#
#*************************************************************************

MKFILENAME:=TARGET.MK

# ------------------------------------------------------------------
# INCLUDE-Path
# ------------------------------------------------------------------

.IF "$(STL_OS2_BUILDING)" != ""
CDEFS+=-DSTL_OS2_BUILDING
.ENDIF
.IF "$(VISIBILITY_HIDDEN)" != ""
.IF "$(COMNAME)" == "gcc3" && "$(HAVE_GCC_VISIBILITY_FEATURE)" == "TRUE"
CFLAGS += -fvisibility=hidden
.ELIF "$(COMNAME)" == "sunpro5" && "$(CCNUMVER)" >= "00050005"
CFLAGS += -xldscope=hidden
.ENDIF
.ENDIF

.IF "$(TARGET)"==""
target_empty=warn_target_empty
.ENDIF

# all use solarinc
# no standalone -I flags!!
INCEXT*=.
INCPRE*=.
INCPOST*=.
.IF "$(PRE)"!=""
ENVINCPRE+=-I$(PRE)/inc
.ENDIF			# "$(PRE)"!=""
.IF "$(BOOTSTRAP_SERVICE)"!="TRUE" && "$(NO_OFFUH)"==""
UNOINCLUDES=$(SOLARINCDIR)/offuh
.ENDIF			# "$(BOOTSTRAP_SERVICE)"!="TRUE" && "$(NO_OFFUH)"==""
SOLARINC+=$(JDKINCS)
# make sure INCLUDE isn't set
INCLUDE:=
.EXPORT : INCLUDE
.IF "$(PRJINC)"!=""
INCLUDE!:=-I. $(ENVINCPRE) $(INCPRE:^"-I":s/-I-I/-I/) -I$(INCLOCAL) $(INCLOCPRJ:^"-I":s/-I-I/-I/) -I$(INCPCH) -I$(INC) -I$(INCGUI) -I$(INCCOM) $(SOLARINC) $(null,$(UNOINCLUDES) $(NULL) -I$(UNOINCLUDES)) -I$(INCEXT) -I$(PRJ)/res -I$(INCPOST)
.ELSE		# "$(PRJINC)"!=""
INCLUDE!:=-I. $(ENVINCPRE) $(INCPRE:^"-I":s/-I-I/-I/) -I$(INCLOCAL) -I$(INCPCH) -I$(INC) -I$(INCGUI) -I$(INCCOM) $(SOLARINC) $(null,$(UNOINCLUDES) $(NULL) -I$(UNOINCLUDES)) -I$(INCEXT) -I$(PRJ)/res -I$(INCPOST)
.ENDIF		# "$(PRJINC)"!=""
INCLUDE_C=$(subst,/stl$(SPACECHAR),dont_use_stl$(SPACECHAR) $(INCLUDE))
.EXPORT : LIB
# --- Compiler -----------------------------------------------------

.IF "$(RC_SUBDIRS)"!=""
SUBDIRS:=$(RC_SUBDIRS)
SUBDIRSDEPS=$(RC_SUBDIRSDEPS)
.ENDIF

.INCLUDE : pstrules.mk

.IF "$(YACCTARGET)"!=""
.INCLUDE : tg_yxx.mk
.ENDIF			# "$(YACCTARGET)"!=""

.IF "$(nodep)"==""

.IF "$(L10N_framework)"==""
.IF "$(DEPOBJFILES)"!=""
DEPCOLLECT_SLO+:=$(foreach,i,$(DEPOBJFILES) $(eq,$i,$(subst,$(SLO),ttt $i) $(NULL) $(subst,$(SLO)/,not_existing/s_ $(i:s/.obj/.dpcc/))))
DEPCOLLECT_OBJ+:=$(foreach,i,$(DEPOBJFILES) $(eq,$i,$(subst,$(OBJ),ttt $i) $(NULL) $(subst,$(OBJ)/,not_existing/o_ $(i:s/.obj/.dpcc/))))
.ENDIF			# "$(DEPOBJFILES)"!=""
# point to not existing directory as there is no creation intended anyway and
# stat call looks faster
DEPCOLLECT_SLO+:=$(subst,$(SLO)/,not_existing/s_ $(SLOFILES:s/.obj/.dpcc/))
DEPCOLLECT_OBJ+:=$(subst,$(OBJ)/,not_existing/o_ $(OBJFILES:s/.obj/.dpcc/))
.ENDIF			# "$(L10N_framework)"==""
DEPFILESx+:=$(subst,$(PAR),$(MISC) $(ALLPARFILES:s/.par/.dpsc/))
.IF "$(L10N_framework)"==""
.IF "$(RCFILES)"!=""
.IF "$(RESNAME)"!=""
DEPFILESx+:=$(MISC)/$(RESNAME).dpcc
.ELSE			# "$(RESNAME)"!=""
DEPFILESx+:=$(MISC)/$(TARGET).dprc
.ENDIF			# "$(RESNAME)"!=""
.ENDIF			# "$(RCFILES)"!=""
.ENDIF          # "$(L10N_framework)"==""
DEPFILES:=$(uniq $(DEPFILESx))
DEPCOLLECT_SLO!:=$(strip $(uniq $(DEPCOLLECT_SLO)))
.IF "$(DEPCOLLECT_SLO)"!=""
DEPFILE_SLO+:=$(MISC)/all_$(TARGET).dpslo
.ENDIF			# "$(DEPCOLLECT_SLO)"!=""
DEPCOLLECT_OBJ!:=$(strip $(uniq $(DEPCOLLECT_OBJ)))
.IF "$(DEPCOLLECT_OBJ)"!=""
DEPFILE_OBJ+:=$(MISC)/all_$(TARGET).dpobj
.ENDIF			# "$(DEPCOLLECT_OBJ)"!=""
.ENDIF			# "$(nodep)"==""

.IF "$(depend)" == ""

# -------
# - ALL -
# -------

# with VCL no resources are appended to the application
APP1RES=
APP2RES=
APP3RES=
APP4RES=
APP5RES=
APP6RES=
APP7RES=
APP8RES=
APP9RES=
# unfortunatly there are some applications which don't VCL resources but have
# resources of their own
.IF "$(APP1NOSVRES)" != ""
APP1RES=$(APP1NOSVRES)
.ENDIF
.IF "$(APP2NOSVRES)" != ""
APP2RES=$(APP2NOSVRES)
.ENDIF
.IF "$(APP3NOSVRES)" != ""
APP3RES=$(APP3NOSVRES)
.ENDIF

.IF "$(NO_APP)"!=""
APP1TARGET=
APP2TARGET=
APP3TARGET=
APP4TARGET=
APP5TARGET=
APP6TARGET=
APP7TARGET=
APP8TARGET=
APP9TARGET=
.ENDIF

.IF "$(IDLFILES)"!=""

URDFILES+=$(foreach,i,$(IDLFILES:s/.idl/.urd/:f) $(OUT)/ucr/$(IDLPACKAGE)/$i)
UNOIDLTARGETS+=$(URDFILES)

.IF "$(URDFILES)"!=""
LOCALDBTARGET=$(OUT)/ucr/$(TARGET).db
.ENDIF

.IF "$(URDDOC)" != ""
URDDOCFILES+=$(foreach,i,$(IDLFILES:s/.idl/.urd/:f) $(OUT)/ucrdoc/$(IDLPACKAGE)/$i)
UNOIDLTARGETS+=$(URDDOCFILES)

.IF "$(URDDOCFILES)"!=""
LOCALDOCDBTARGET=$(OUT)/ucrdoc/$(TARGET).db
.ENDIF

.ENDIF			# "$(URDDOC)" != ""

.ENDIF		# "$(IDLFILES)"!=""

.IF "$(UNOIDLDBFILES)"!=""
UNOIDLDBTARGET=$(OUT)/ucr/$(PRJNAME).db
.IF "$(URDDOC)" != ""
UNOIDLDBDOCFILES:=$(subst,/ucr/,/ucrdoc/ $(UNOIDLDBFILES))
UNOIDLDBDOCTARGET=$(OUT)/ucrdoc/$(PRJNAME)_doc.db
.IF "$(UNOIDLDBREGS)"!=""
UNOIDLDBDOCREGS=$(foreach,i,$(UNOIDLDBREGS) $(i:d)$(i:b)_doc$(i:e))
.ENDIF			# "$(UNOIDLDBREGS)"!=""
.ENDIF			# "$(URDDOC)" != ""
.ENDIF		# "$(UNOIDLDBFILES)"!=""

.IF "$(IDLFILES)"!=""
.IF "$(PACKAGE)"!=""
IDLDIRS=$(SOLARIDLDIR)/$(PACKAGE)
.ELSE			# "$(PACKAGE)"!=""
IDLDIRS=$(SOLARIDLDIR)
.ENDIF			# "$(PACKAGE)"!=""

.IF "$(LOCALIDLFILES)$(EXTERNIDLFILES)"!=""
.IF "$(EXTERNIDLFILES)"!=""
DEPIDLFILES:=$(foreach,i,$(IDLFILES) $(IDLDIRS)/$i)
.ELSE			# "$(EXTERNIDLFILES)"!=""
DEPIDLFILES:=$(IDLFILES)
.ENDIF			# "$(EXTERNIDLFILES)"!=""
.ELSE			# "$(LOCALIDLFILES)$(EXTERNIDLFILES)"!=""
.IF "$(GUI)"=="WNT" || "$(GUI)"=="OS2"
DEPIDLFILES:=$(foreach,i,$(IDLFILES) $(!null,$(shell @$(FIND) . -name $i) $i $(shell @($(FIND) $(IDLDIRS) -name $(i:f)) | $(SED) s/\//\\/g )))
.ELSE			# "$(GUI)"=="WNT"
DEPIDLFILES:=$(foreach,i,$(IDLFILES) $(!null,$(shell @$(FIND) . -name $i -print) $i $(shell @$(FIND) $(IDLDIRS) -name $(i:f) -print )  ))
.ENDIF			# "$(GUI)"=="WNT"
.ENDIF			# "$(LOCALIDLFILES)$(EXTERNIDLFILES)"!=""
.ENDIF			# "$(IDLFILES)"!=""

.IF "$(L10N_framework)"==""
.IF "$(JARFILES)"!=""
LOCALJARS:=$(foreach,i,$(shell @@-cd $(JARDIR) && ls -1 $(JARFILES) ) $(JARDIR)/$i)
NEWCLASS:=$(LOCALJARS)
NEWCLASS+:=$(foreach,i,$(JARFILES) $(eq,$(LOCALJARS),$(subst,$i, $(LOCALJARS)) $(SOLARBINDIR)/$i $(NULL)))
.ENDIF			# "$(JARFILES)"!=""
.IF "$(EXTRAJARFILES)"!=""
NEWCLASS+=$(foreach,i,$(EXTRAJARFILES) $(COMMON_BUILD_TOOLS)/$i)
.ENDIF			# "$(EXTRAJARFILES)"!=""
.IF "$(GENJAVACLASSFILES)"!=""
NEWCLASS+=$(CLASSGENDIR)
.ENDIF			# "$(GENJAVACLASSFILES)"!=""
.IF "$(NEWCLASS)"!=""
# See iz36027 for the reason for the strange $(subst ..) construct
CLASSPATH:=.$(PATH_SEPERATOR)$(CLASSDIR)$(PATH_SEPERATOR)$(XCLASSPATH)$(PATH_SEPERATOR){$(subst,%Z*Z%,$(PATH_SEPERATOR) $(NEWCLASS:s/ /%Z*Z%/))}$(PATH_SEPERATOR)$(SOLARLIBDIR)
.ENDIF			# "$(NEWCLASS)"!=""
.ENDIF			# "$(L10N_framework)"==""

.IF "$(NOOPTFILES)" != ""
NOOPTTARGET=do_it_noopt
.ENDIF

.IF "$(EXCEPTIONSNOOPTFILES)" != ""
EXCEPTIONSNOOPTTARGET=do_it_exceptions_noopt
.ENDIF

.IF "$(LIBTARGET)"==""
.IF "$(OBJFILES)$(IDLOBJFILES)"!=""
OBJTARGET=$(LB)/$(TARGET).lib
.ENDIF

.IF "$(SLOFILES)$(IDLSLOFILES)"!=""
SLOTARGET=$(SLB)/$(TARGET).lib
.ENDIF
.ENDIF			# "$(LIBTARGET)"==""

.IF "$(SECOND_BUILD)"!=""
.IF "$($(SECOND_BUILD)_SLOFILES)"!=""
.IF "$(LIBTARGET)"==""
$(SECOND_BUILD)SLOTARGET=$(SLB)/$(SECOND_BUILD)_$(TARGET).lib
.ENDIF			# "$(LIBTARGET)"==""
REAL_$(SECOND_BUILD)_SLOFILES=$(foreach,i,$($(SECOND_BUILD)_SLOFILES) $(i:d)$(SECOND_BUILD)_$(i:f))
.ENDIF

.IF "$($(SECOND_BUILD)_OBJFILES)"!=""
.IF "$(LIBTARGET)"==""
$(SECOND_BUILD)OBJTARGET=$(LB)/$(SECOND_BUILD)_$(TARGET).lib
.ENDIF			# "$(LIBTARGET)"==""
REAL_$(SECOND_BUILD)_OBJFILES=$(foreach,i,$($(SECOND_BUILD)_OBJFILES) $(i:d)$(SECOND_BUILD)_$(i:f))
.ENDIF
.ENDIF			# "$(SECOND_BUILD)"!=""

.IF "$(NOLIBOBJTARGET)$(NOLIBSLOTARGET)"!=""
dont_set_NOLIBOBJTARGET:
	@echo --------------------------------------------------
	@echo setting NOLIBOBJTARGET or NOLIBSLOTARGET in your makefile
	@echo will cause serious problems!
	@echo use DEPOBJFILES instead.
	@echo --------------------------------------------------
	force_dmake_to_error
.ENDIF			# "$(NOLIBTARGET)"!=""
.IF "$(OBJFILES)"!=""
.IF "$(LIBTARGET)" != ""
NOLIBOBJTARGET=$(OBJFILES)
.ENDIF
.ENDIF

.IF "$(SLOFILES)"!=""
.IF "$(LIBTARGET)" != ""
NOLIBSLOTARGET=$(SLOFILES)
.ENDIF
.ENDIF

.IF "$(SRC1FILES)"!=""
SRC1TARGET=$(SRS)/$(SRS1NAME).srs
DEPSRS1FILE+=$(MISC)/$(TARGET).$(SRS1NAME).dprr
DEPSRSFILES+=$(DEPSRS1FILE)
.ENDIF

.IF "$(SRC2FILES)"!=""
SRC2TARGET=$(SRS)/$(SRS2NAME).srs
DEPSRS2FILE+=$(MISC)/$(TARGET).$(SRS2NAME).dprr
DEPSRSFILES+=$(DEPSRS2FILE)
.ENDIF

.IF "$(SRC3FILES)"!=""
SRC3TARGET=$(SRS)/$(SRS3NAME).srs
DEPSRS3FILE+=$(MISC)/$(TARGET).$(SRS3NAME).dprr
DEPSRSFILES+=$(DEPSRS3FILE)
.ENDIF

.IF "$(SRC4FILES)"!=""
SRC4TARGET=$(SRS)/$(SRS4NAME).srs
DEPSRS4FILE+=$(MISC)/$(TARGET).$(SRS4NAME).dprr
DEPSRSFILES+=$(DEPSRS4FILE)
.ENDIF

.IF "$(SRC5FILES)"!=""
SRC5TARGET=$(SRS)/$(SRS5NAME).srs
DEPSRS5FILE+=$(MISC)/$(TARGET).$(SRS5NAME).dprr
DEPSRSFILES+=$(DEPSRS5FILE)
.ENDIF

.IF "$(SRC6FILES)"!=""
SRC6TARGET=$(SRS)/$(SRS6NAME).srs
DEPSRS6FILE+=$(MISC)/$(TARGET).$(SRS6NAME).dprr
DEPSRSFILES+=$(DEPSRS6FILE)
.ENDIF

.IF "$(SRC7FILES)"!=""
SRC7TARGET=$(SRS)/$(SRS7NAME).srs
DEPSRS7FILE+=$(MISC)/$(TARGET).$(SRS7NAME).dprr
DEPSRSFILES+=$(DEPSRS7FILE)
.ENDIF

.IF "$(SRC8FILES)"!=""
SRC8TARGET=$(SRS)/$(SRS8NAME).srs
DEPSRS8FILE+=$(MISC)/$(TARGET).$(SRS8NAME).dprr
DEPSRSFILES+=$(DEPSRS8FILE)
.ENDIF

.IF "$(SRC9FILES)"!=""
SRC9TARGET=$(SRS)/$(SRS9NAME).srs
DEPSRS9FILE+=$(MISC)/$(TARGET).$(SRS9NAME).dprr
DEPSRSFILES+=$(DEPSRS9FILE)
.ENDIF

.IF "$(SOLAR_JAVA)"!=""
.IF "$(JAVAFILES)$(JAVACLASSFILES)$(GENJAVAFILES)"!=""
.IF "$(JAVAFILES)$(JAVACLASSFILES)"=="$(JAVAFILES)"
JAVACLASSFILES=	$(foreach,i,$(JAVAFILES) $(CLASSDIR)/$(PACKAGE)/$(i:s/.java//).class)
.ELSE			# "$(JAVAFILES)$(JAVACLASSFILES)"=="$(JAVAFILES)"
.IF "$(JAVAFILES)$(JAVACLASSFILES)"=="$(JAVACLASSFILES)"
JAVAFILES=	$(foreach,i,$(JAVACLASSFILES) $(subst,$(CLASSDIR)/$(PACKAGE)/, $(i:s/.class//).java))
.ENDIF			# "$(JAVAFILES)$(JAVACLASSFILES)"=="$(JAVACLASSFILES)"
.ENDIF			# "$(JAVAFILES)$(JAVACLASSFILES)"=="$(JAVAFILES)"
JAVATARGET:=$(MISC)/$(TARGET)_dummy.java
.ENDIF			# "$(JAVAFILES)$(JAVACLASSFILES)$(GENJAVAFILES)"!=""

.IF "$(JARTARGET)"!=""
JARCLASSDIRS*=.
.IF "$(NEW_JAR_PACK)"!=""
JARMANIFEST*=$(CLASSDIR)/$(TARGET)/META-INF/MANIFEST.MF
.ENDIF			# "$(NEW_JAR_PACK)"!=""
JARTARGETN=$(CLASSDIR)/$(JARTARGET)
.IF "$(NOJARDEP)$(NEW_JAR_PACK)"==""
JARTARGETDEP=$(JARTARGET).dep
JARTARGETDEPN=$(MISC)/$(JARTARGET).dep
.ENDIF			# "$(NOJARDEP)$(NEW_JAR_PACK)"==""
.ENDIF			# "$(JARTARGET)"!=""
.ELSE			# "$(SOLAR_JAVA)"!=""
JAVACLASSFILES:=
JAVAFILES:=
javauno:=
.ENDIF			# "$(SOLAR_JAVA)"!=""

.IF "$(L10N_framework)"==""
.IF "$(RCFILES)"!=""
RESNAME*=$(TARGET)
.IF "$(RCFILES)" != "verinfo.rc"
RCTARGET=$(RES)/$(RESNAME).res
.ELSE           # "$(RCFILES)" != "verinfo.rc"
RCFILES=
.ENDIF          # "$(RCFILES)" != "verinfo.rc"
.ENDIF          # "$(RCFILES)"!=""
.ENDIF          # "$(L10N_framework)"==""

LOCALIZE_ME_DEST:=$(foreach,i,$(LOCALIZE_ME) $(INCCOM)/$(i:f:s/_tmpl//))

.IF "$(SCP1TARGET)"!=""
SCP1TARGETN:=$(foreach,i,$(SCP1LINK_PRODUCT_TYPE) $(BIN)/$i/$(SCP1TARGET)$(SCPPOST))
.ENDIF

.IF "$(SCP2TARGET)"!=""
SCP2TARGETN:=$(foreach,i,$(SCP2LINK_PRODUCT_TYPE) $(BIN)/$i/$(SCP2TARGET)$(SCPPOST))
.ENDIF

.IF "$(SCP3TARGET)"!=""
SCP3TARGETN:=$(foreach,i,$(SCP3LINK_PRODUCT_TYPE) $(BIN)/$i/$(SCP3TARGET)$(SCPPOST))
.ENDIF

.IF "$(SCP4TARGET)"!=""
SCP4TARGETN:=$(foreach,i,$(SCP4LINK_PRODUCT_TYPE) $(BIN)/$i/$(SCP4TARGET)$(SCPPOST))
.ENDIF

.IF "$(SCP5TARGET)"!=""
SCP5TARGETN:=$(foreach,i,$(SCP5LINK_PRODUCT_TYPE) $(BIN)/$i/$(SCP5TARGET)$(SCPPOST))
.ENDIF

.IF "$(SCP6TARGET)"!=""
SCP6TARGETN:=$(foreach,i,$(SCP6LINK_PRODUCT_TYPE) $(BIN)/$i/$(SCP6TARGET)$(SCPPOST))
.ENDIF

.IF "$(SCP7TARGET)"!=""
SCP7TARGETN:=$(foreach,i,$(SCP7LINK_PRODUCT_TYPE) $(BIN)/$i/$(SCP7TARGET)$(SCPPOST))
.ENDIF

.IF "$(SCP8TARGET)"!=""
SCP8TARGETN:=$(foreach,i,$(SCP8LINK_PRODUCT_TYPE) $(BIN)/$i/$(SCP8TARGET)$(SCPPOST))
.ENDIF

.IF "$(SCP9TARGET)"!=""
SCP9TARGETN:=$(foreach,i,$(SCP9LINK_PRODUCT_TYPE) $(BIN)/$i/$(SCP9TARGET)$(SCPPOST))
.ENDIF

.IF "$(ZIP1TARGET)$(ZIP2TARGET)$(ZIP3TARGET)$(ZIP4TARGET)$(ZIP5TARGET)$(ZIP6TARGET)$(ZIP7TARGET)$(ZIP8TARGET)$(ZIP9TARGET)"!="$(ZIP1LIST:s/LANGDIR//)$(ZIP2LIST:s/LANGDIR//)$(ZIP3LIST:s/LANGDIR//)$(ZIP4LIST:s/LANGDIR//)$(ZIP5LIST:s/LANGDIR//)$(ZIP6LIST:s/LANGDIR//)$(ZIP7LIST:s/LANGDIR//)$(ZIP8LIST:s/LANGDIR//)$(ZIP9LIST:s/LANGDIR//)"

ZIPALL=ZIPALLTARGET

.ENDIF			#

.IF "$(APP1TARGET)"!=""
APP1TARGETN=$(BIN)/$(APP1TARGET)$(EXECPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT"
.IF "$(APP1BASE)"==""
APP1BASE=$(BASE)
.ENDIF
APP1BASEX=/BASE:$(APP1BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(APP2TARGET)"!=""
APP2TARGETN=$(BIN)/$(APP2TARGET)$(EXECPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT"
.IF "$(APP2BASE)"==""
APP2BASE=$(BASE)
.ENDIF
APP2BASEX=/BASE:$(APP2BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(APP3TARGET)"!=""
APP3TARGETN=$(BIN)/$(APP3TARGET)$(EXECPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT" || "$(GUI)"=="OS2"
.IF "$(APP3BASE)"==""
APP3BASE=$(BASE)
.ENDIF
APP3BASEX=/BASE:$(APP3BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(APP4TARGET)"!=""
APP4TARGETN=$(BIN)/$(APP4TARGET)$(EXECPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT"
.IF "$(APP4BASE)"==""
APP4BASE=$(BASE)
.ENDIF
APP4BASEX=/BASE:$(APP4BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(APP5TARGET)"!=""
APP5TARGETN=$(BIN)/$(APP5TARGET)$(EXECPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT"
.IF "$(APP5BASE)"==""
APP5BASE=$(BASE)
.ENDIF
APP5BASEX=/BASE:$(APP5BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(APP6TARGET)"!=""
APP6TARGETN=$(BIN)/$(APP6TARGET)$(EXECPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT"
.IF "$(APP6BASE)"==""
APP6BASE=$(BASE)
.ENDIF
APP6BASEX=/BASE:$(APP6BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(APP7TARGET)"!=""
APP7TARGETN=$(BIN)/$(APP7TARGET)$(EXECPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT"
.IF "$(APP7BASE)"==""
APP7BASE=$(BASE)
.ENDIF
APP7BASEX=/BASE:$(APP7BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(APP8TARGET)"!=""
APP8TARGETN=$(BIN)/$(APP8TARGET)$(EXECPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT" || "$(GUI)"=="OS2"
.IF "$(APP8BASE)"==""
APP8BASE=$(BASE)
.ENDIF
APP8BASEX=/BASE:$(APP8BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(APP9TARGET)"!=""
APP9TARGETN=$(BIN)/$(APP9TARGET)$(EXECPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT" || "$(GUI)"=="OS2"
.IF "$(APP9BASE)"==""
APP9BASE=$(BASE)
.ENDIF
APP9BASEX=/BASE:$(APP9BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(SHL1TARGET)"!=""
.IF "$(WINVERSIONNAMES)"!=""
SHL1TARGET!:=$(SHL1TARGET)$($(WINVERSIONNAMES)_MAJOR)
.ENDIF			# "$(WINVERSIONNAMES)"!=""
SHL1DLLPRE*=$(DLLPRE)
SHL1TARGETN=$(DLLDEST)/$(SHL1DLLPRE)$(SHL1TARGET)$(DLLPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT" || "$(GUI)"=="OS2"
.IF "$(SHL1BASE)"==""
SHL1BASE=$(BASE)
.ENDIF
SHL1BASEX=/BASE:$(SHL1BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(SHL2TARGET)"!=""
.IF "$(WINVERSIONNAMES)"!=""
SHL2TARGET!:=$(SHL2TARGET)$($(WINVERSIONNAMES)_MAJOR)
.ENDIF			# "$(WINVERSIONNAMES)"!=""
SHL2DLLPRE*=$(DLLPRE)
SHL2TARGETN=$(DLLDEST)/$(SHL2DLLPRE)$(SHL2TARGET)$(DLLPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT" || "$(GUI)"=="OS2"
.IF "$(SHL2BASE)"==""
SHL2BASE=$(BASE)
.ENDIF
SHL2BASEX=/BASE:$(SHL2BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(SHL3TARGET)"!=""
.IF "$(WINVERSIONNAMES)"!=""
SHL3TARGET!:=$(SHL3TARGET)$($(WINVERSIONNAMES)_MAJOR)
.ENDIF			# "$(WINVERSIONNAMES)"!=""
SHL3DLLPRE*=$(DLLPRE)
SHL3TARGETN=$(DLLDEST)/$(SHL3DLLPRE)$(SHL3TARGET)$(DLLPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT" || "$(GUI)"=="OS2"
.IF "$(SHL3BASE)"==""
SHL3BASE=$(BASE)
.ENDIF
SHL3BASEX=/BASE:$(SHL3BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(SHL4TARGET)"!=""
.IF "$(WINVERSIONNAMES)"!=""
SHL4TARGET!:=$(SHL4TARGET)$($(WINVERSIONNAMES)_MAJOR)
.ENDIF			# "$(WINVERSIONNAMES)"!=""
SHL4DLLPRE*=$(DLLPRE)
SHL4TARGETN=$(DLLDEST)/$(SHL4DLLPRE)$(SHL4TARGET)$(DLLPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT" || "$(GUI)"=="OS2"
.IF "$(SHL4BASE)"==""
SHL4BASE=$(BASE)
.ENDIF
SHL4BASEX=/BASE:$(SHL4BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(SHL5TARGET)"!=""
.IF "$(WINVERSIONNAMES)"!=""
SHL5TARGET!:=$(SHL5TARGET)$($(WINVERSIONNAMES)_MAJOR)
.ENDIF			# "$(WINVERSIONNAMES)"!=""
SHL5DLLPRE*=$(DLLPRE)
SHL5TARGETN=$(DLLDEST)/$(SHL5DLLPRE)$(SHL5TARGET)$(DLLPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT" || "$(GUI)"=="OS2"
.IF "$(SHL5BASE)"==""
SHL5BASE=$(BASE)
.ENDIF
SHL5BASEX=/BASE:$(SHL5BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(SHL6TARGET)"!=""
.IF "$(WINVERSIONNAMES)"!=""
SHL6TARGET!:=$(SHL6TARGET)$($(WINVERSIONNAMES)_MAJOR)
.ENDIF			# "$(WINVERSIONNAMES)"!=""
SHL6DLLPRE*=$(DLLPRE)
SHL6TARGETN=$(DLLDEST)/$(SHL6DLLPRE)$(SHL6TARGET)$(DLLPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT" || "$(GUI)"=="OS2"
.IF "$(SHL6BASE)"==""
SHL6BASE=$(BASE)
.ENDIF
SHL6BASEX=/BASE:$(SHL6BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(SHL7TARGET)"!=""
.IF "$(WINVERSIONNAMES)"!=""
SHL7TARGET!:=$(SHL7TARGET)$($(WINVERSIONNAMES)_MAJOR)
.ENDIF			# "$(WINVERSIONNAMES)"!=""
SHL7DLLPRE*=$(DLLPRE)
SHL7TARGETN=$(DLLDEST)/$(SHL7DLLPRE)$(SHL7TARGET)$(DLLPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT" || "$(GUI)"=="OS2"
.IF "$(SHL7BASE)"==""
SHL7BASE=$(BASE)
.ENDIF
SHL7BASEX=/BASE:$(SHL7BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(SHL8TARGET)"!=""
.IF "$(WINVERSIONNAMES)"!=""
SHL8TARGET!:=$(SHL8TARGET)$($(WINVERSIONNAMES)_MAJOR)
.ENDIF			# "$(WINVERSIONNAMES)"!=""
SHL8DLLPRE*=$(DLLPRE)
SHL8TARGETN=$(DLLDEST)/$(SHL8DLLPRE)$(SHL8TARGET)$(DLLPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT" || "$(GUI)"=="OS2"
.IF "$(SHL8BASE)"==""
SHL8BASE=$(BASE)
.ENDIF
SHL8BASEX=/BASE:$(SHL8BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(SHL9TARGET)"!=""
.IF "$(WINVERSIONNAMES)"!=""
SHL9TARGET!:=$(SHL9TARGET)$($(WINVERSIONNAMES)_MAJOR)
.ENDIF			# "$(WINVERSIONNAMES)"!=""
SHL9DLLPRE*=$(DLLPRE)
SHL9TARGETN=$(DLLDEST)/$(SHL9DLLPRE)$(SHL9TARGET)$(DLLPOST)
.IF "$(BASE)" != ""
.IF "$(GUI)"=="WNT" || "$(GUI)"=="OS2"
.IF "$(SHL9BASE)"==""
SHL9BASE=$(BASE)
.ENDIF
SHL9BASEX=/BASE:$(SHL9BASE)
.ENDIF
.ENDIF
.ENDIF

.IF "$(COMP1TYPELIST)$(COMP2TYPELIST)$(COMP3TYPELIST)$(COMP4TYPELIST)$(COMP5TYPELIST)$(COMP6TYPELIST)$(COMP7TYPELIST)$(COMP8TYPELIST)$(COMP9TYPELIST)"!=""
.IF "$(UNOUCRRDB)"!=""
COMPRDB*:=$(UNOUCRRDB)
.ELSE			# "$(UNOUCRRDB)"!=""
COMPRDB*:=$(SOLARBINDIR)/types.rdb
.ENDIF			# "$(UNOUCRRDB)"!=""
.ENDIF          # "$(COMP1TYPELIST)$(COMP2TYPELIST)$(COMP3TYPELIST)$(COMP4TYPELIST)$(COMP5TYPELIST)$(COMP6TYPELIST)$(COMP7TYPELIST)$(COMP8TYPELIST)$(COMP9TYPELIST)"!=""
.IF "$(COMP1TYPELIST)"!=""
UNOTYPES+=$($(COMP1TYPELIST)_XML2CMPTYPES)
COMP1RDBTARGETN:=$(BIN)/$(COMP1TYPELIST).rdb
#COMP1TYPELISTN:=$(MISC)/$(COMP1TYPELIST).xml
.ENDIF

.IF "$(COMP2TYPELIST)"!=""
UNOTYPES+=$($(COMP2TYPELIST)_XML2CMPTYPES)
COMP2RDBTARGETN:=$(BIN)/$(COMP2TYPELIST).rdb
#COMP2TYPELISTN:=$(MISC)/$(COMP2TYPELIST).xml
.ENDIF

.IF "$(COMP3TYPELIST)"!=""
UNOTYPES+=$($(COMP3TYPELIST)_XML2CMPTYPES)
COMP3RDBTARGETN:=$(BIN)/$(COMP3TYPELIST).rdb
#COMP3TYPELISTN:=$(MISC)/$(COMP3TYPELIST).xml
.ENDIF

.IF "$(COMP4TYPELIST)"!=""
UNOTYPES+=$($(COMP4TYPELIST)_XML2CMPTYPES)
COMP4RDBTARGETN:=$(BIN)/$(COMP4TYPELIST).rdb
#COMP4TYPELISTN:=$(MISC)/$(COMP4TYPELIST).xml
.ENDIF

.IF "$(COMP5TYPELIST)"!=""
UNOTYPES+=$($(COMP5TYPELIST)_XML2CMPTYPES)
COMP5RDBTARGETN:=$(BIN)/$(COMP5TYPELIST).rdb
#COMP5TYPELISTN:=$(MISC)/$(COMP5TYPELIST).xml
.ENDIF

.IF "$(COMP6TYPELIST)"!=""
UNOTYPES+=$($(COMP6TYPELIST)_XML2CMPTYPES)
COMP6RDBTARGETN:=$(BIN)/$(COMP6TYPELIST).rdb
#COMP6TYPELISTN:=$(MISC)/$(COMP6TYPELIST).xml
.ENDIF

.IF "$(COMP7TYPELIST)"!=""
UNOTYPES+=$($(COMP7TYPELIST)_XML2CMPTYPES)
COMP7RDBTARGETN:=$(BIN)/$(COMP7TYPELIST).rdb
#COMP7TYPELISTN:=$(MISC)/$(COMP7TYPELIST).xml
.ENDIF

.IF "$(COMP8TYPELIST)"!=""
UNOTYPES+=$($(COMP8TYPELIST)_XML2CMPTYPES)
COMP8RDBTARGETN:=$(BIN)/$(COMP8TYPELIST).rdb
#COMP8TYPELISTN:=$(MISC)/$(COMP8TYPELIST).xml
.ENDIF

.IF "$(COMP9TYPELIST)"!=""
UNOTYPES+=$($(COMP9TYPELIST)_XML2CMPTYPES)
COMP9RDBTARGETN:=$(BIN)/$(COMP9TYPELIST).rdb
#COMP9TYPELISTN:=$(MISC)/$(COMP9TYPELIST).xml
.ENDIF

UNOTYPES!:=$(strip $(UNOTYPES))

#moved here to get UNOTYPES from COMPxTYPELIST
.IF "$(UNOTYPES)" != ""
UNOUCRHEADER=$(foreach,j,$(subst,.,/ $(UNOTYPES)) $(UNOUCROUT)/$(j:+".hpp"))
UNOUCRTARGET:=$(INCCOM)/$(TARGET)_headergen.done
.ENDIF			# "$(UNOTYPES)" != ""

.IF "$(HELPIDFILES)"!=""
MAKE_HELPIDS=$(MISC)/helpids.don
.ENDIF

.IF "$(HXXCOPYFILES)" != ""
HXXCOPYTARGET=	copy_hxxcopyfiles
.ENDIF

.IF "$(LIB1TARGET)" != ""
LIB1TARGETN=$(LIB1TARGET)
.ENDIF

.IF "$(LIB2TARGET)" != ""
LIB2TARGETN=$(LIB2TARGET)
.ENDIF

.IF "$(LIB3TARGET)" != ""
LIB3TARGETN=$(LIB3TARGET)
.ENDIF

.IF "$(LIB4TARGET)" != ""
LIB4TARGETN=$(LIB4TARGET)
.ENDIF

.IF "$(LIB5TARGET)" != ""
LIB5TARGETN=$(LIB5TARGET)
.ENDIF

.IF "$(LIB6TARGET)" != ""
LIB6TARGETN=$(LIB6TARGET)
.ENDIF

.IF "$(LIB7TARGET)" != ""
LIB7TARGETN=$(LIB7TARGET)
.ENDIF

.IF "$(LIB8TARGET)" != ""
LIB8TARGETN=$(LIB8TARGET)
.ENDIF

.IF "$(LIB9TARGET)" != ""
LIB9TARGETN=$(LIB9TARGET)
.ENDIF

.IF "$(GUI)"=="WNT" || "$(GUI)"=="OS2"
.IF "$(COM)"!="GCC"
LIB1ARCHIV=
LIB2ARCHIV=
LIB3ARCHIV=
LIB4ARCHIV=
LIB5ARCHIV=
LIB6ARCHIV=
LIB7ARCHIV=
LIB8ARCHIV=
LIB9ARCHIV=
.ENDIF
.ENDIF			# "$(GUI)"=="WNT"

.IF "$(RESLIB1NAME)" != ""
.IF "$(RESLIB1NOVERSION)"==""
.ENDIF			# "$(RESLIB1NOVERSION)"==""
.IF "$(common_build_reslib)"!=""
RESLIB1TARGETN=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(BIN))/$(RESLIB1NAME)LANGEXT.res
RSC_MULTI1=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(MISC))/rsc_$(RESLIB1NAME)
.ELSE			# "$(common_build_reslib)"!=""
RESLIB1TARGETN=$(BIN)/$(RESLIB1NAME)LANGEXT.res
RSC_MULTI1=$(MISC)/rsc_$(RESLIB1NAME)
.ENDIF			# "$(common_build_reslib)"!=""
# change to iso if resmgr is changed
RESLIB1TARGETN!:=$(foreach,i,$(alllangiso) $(subst,LANGEXT,$i $(RESLIB1TARGETN)))
.ENDIF

.IF "$(RESLIB2NAME)" != ""
.IF "$(RESLIB2NOVERSION)"==""
.ENDIF			# "$(RESLIB2NOVERSION)"==""
.IF "$(common_build_reslib)"!=""
RESLIB2TARGETN=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(BIN))/$(RESLIB2NAME)LANGEXT.res
RSC_MULTI2=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(MISC))/rsc_$(RESLIB2NAME)
.ELSE			# "$(common_build_reslib)"!=""
RESLIB2TARGETN=$(BIN)/$(RESLIB2NAME)LANGEXT.res
RSC_MULTI2=$(MISC)/rsc_$(RESLIB2NAME)
.ENDIF			# "$(common_build_reslib)"!=""
RESLIB2TARGETN!:=$(foreach,i,$(alllangiso) $(subst,LANGEXT,$i $(RESLIB2TARGETN)))
.ENDIF

.IF "$(RESLIB3NAME)" != ""
.IF "$(RESLIB3NOVERSION)"==""
.ENDIF			# "$(RESLIB3NOVERSION)"==""
.IF "$(common_build_reslib)"!=""
RESLIB3TARGETN=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(BIN))/$(RESLIB3NAME)LANGEXT.res
RSC_MULTI3=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(MISC))/rsc_$(RESLIB3NAME)
.ELSE			# "$(common_build_reslib)"!=""
RESLIB3TARGETN=$(BIN)/$(RESLIB3NAME)LANGEXT.res
RSC_MULTI3=$(MISC)/rsc_$(RESLIB3NAME)
.ENDIF			# "$(common_build_reslib)"!=""
RESLIB3TARGETN!:=$(foreach,i,$(alllangiso) $(subst,LANGEXT,$i $(RESLIB3TARGETN)))
.ENDIF

.IF "$(RESLIB4NAME)" != ""
.IF "$(RESLIB4NOVERSION)"==""
.ENDIF			# "$(RESLIB4NOVERSION)"==""
.IF "$(common_build_reslib)"!=""
RESLIB4TARGETN=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(BIN))/$(RESLIB4NAME)LANGEXT.res
RSC_MULTI4=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(MISC))/rsc_$(RESLIB4NAME)
.ELSE			# "$(common_build_reslib)"!=""
RESLIB4TARGETN=$(BIN)/$(RESLIB4NAME)LANGEXT.res
RSC_MULTI4=$(MISC)/rsc_$(RESLIB4NAME)
.ENDIF			# "$(common_build_reslib)"!=""
RESLIB4TARGETN!:=$(foreach,i,$(alllangiso) $(subst,LANGEXT,$i $(RESLIB4TARGETN)))
.ENDIF

.IF "$(RESLIB5NAME)" != ""
.IF "$(RESLIB5NOVERSION)"==""
.ENDIF			# "$(RESLIB5NOVERSION)"==""
.IF "$(common_build_reslib)"!=""
RESLIB5TARGETN=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(BIN))/$(RESLIB5NAME)LANGEXT.res
RSC_MULTI5=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(MISC))/rsc_$(RESLIB5NAME)
.ELSE			# "$(common_build_reslib)"!=""
RESLIB5TARGETN=$(BIN)/$(RESLIB5NAME)LANGEXT.res
RSC_MULTI5=$(MISC)/rsc_$(RESLIB5NAME)
.ENDIF			# "$(common_build_reslib)"!=""
RESLIB5TARGETN!:=$(foreach,i,$(alllangiso) $(subst,LANGEXT,$i $(RESLIB5TARGETN)))
.ENDIF

.IF "$(RESLIB6NAME)" != ""
.IF "$(RESLIB6NOVERSION)"==""
.ENDIF			# "$(RESLIB6NOVERSION)"==""
.IF "$(common_build_reslib)"!=""
RESLIB6TARGETN=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(BIN))/$(RESLIB6NAME)LANGEXT.res
RSC_MULTI6=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(MISC))/rsc_$(RESLIB6NAME)
.ELSE			# "$(common_build_reslib)"!=""
RESLIB6TARGETN=$(BIN)/$(RESLIB6NAME)LANGEXT.res
RSC_MULTI6=$(MISC)/rsc_$(RESLIB6NAME)
.ENDIF			# "$(common_build_reslib)"!=""
RESLIB6TARGETN!:=$(foreach,i,$(alllangiso) $(subst,LANGEXT,$i $(RESLIB6TARGETN)))
.ENDIF

.IF "$(RESLIB7NAME)" != ""
.IF "$(RESLIB7NOVERSION)"==""
.ENDIF			# "$(RESLIB7NOVERSION)"==""
.IF "$(common_build_reslib)"!=""
RESLIB7TARGETN=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(BIN))/$(RESLIB7NAME)LANGEXT.res
RSC_MULTI7=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(MISC))/rsc_$(RESLIB7NAME)
.ELSE			# "$(common_build_reslib)"!=""
RESLIB7TARGETN=$(BIN)/$(RESLIB7NAME)LANGEXT.res
RSC_MULTI7=$(MISC)/rsc_$(RESLIB7NAME)
.ENDIF			# "$(common_build_reslib)"!=""
RESLIB7TARGETN!:=$(foreach,i,$(alllangiso) $(subst,LANGEXT,$i $(RESLIB7TARGETN)))
.ENDIF

.IF "$(RESLIB8NAME)" != ""
.IF "$(RESLIB8NOVERSION)"==""
.ENDIF			# "$(RESLIB8NOVERSION)"==""
.IF "$(common_build_reslib)"!=""
RESLIB8TARGETN=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(BIN))/$(RESLIB8NAME)LANGEXT.res
RSC_MULTI8=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(MISC))/rsc_$(RESLIB8NAME)
.ELSE			# "$(common_build_reslib)"!=""
RESLIB8TARGETN=$(BIN)/$(RESLIB8NAME)LANGEXT.res
RSC_MULTI8=$(MISC)/rsc_$(RESLIB8NAME)
.ENDIF			# "$(common_build_reslib)"!=""
RESLIB8TARGETN!:=$(foreach,i,$(alllangiso) $(subst,LANGEXT,$i $(RESLIB8TARGETN)))
.ENDIF

.IF "$(RESLIB9NAME)" != ""
.IF "$(RESLIB9NOVERSION)"==""
.ENDIF			# "$(RESLIB9NOVERSION)"==""
.IF "$(common_build_reslib)"!=""
RESLIB9TARGETN=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(BIN))/$(RESLIB9NAME)LANGEXT.res
RSC_MULTI9=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(MISC))/rsc_$(RESLIB9NAME)
.ELSE			# "$(common_build_reslib)"!=""
RESLIB9TARGETN=$(BIN)/$(RESLIB9NAME)LANGEXT.res
RSC_MULTI9=$(MISC)/rsc_$(RESLIB9NAME)
.ENDIF			# "$(common_build_reslib)"!=""
RESLIB9TARGETN!:=$(foreach,i,$(alllangiso) $(subst,LANGEXT,$i $(RESLIB9TARGETN)))
.ENDIF

.IF "$(INDPRESLIB1NAME)"!=""
INDPRESLIB1TARGETN=$(BIN)/$(INDPRESLIB1NAME).dll
.ENDIF

.IF "$(DEF1NAME)"!=""
DEF1TARGETN=$(MISC)/$(DEF1NAME).def
.ENDIF

.IF "$(DEF2NAME)"!=""
DEF2TARGETN=$(MISC)/$(DEF2NAME).def
.ENDIF

.IF "$(DEF3NAME)"!=""
DEF3TARGETN=$(MISC)/$(DEF3NAME).def
.ENDIF

.IF "$(DEF4NAME)"!=""
DEF4TARGETN=$(MISC)/$(DEF4NAME).def
.ENDIF

.IF "$(DEF5NAME)"!=""
DEF5TARGETN=$(MISC)/$(DEF5NAME).def
.ENDIF

.IF "$(DEF6NAME)"!=""
DEF6TARGETN=$(MISC)/$(DEF6NAME).def
.ENDIF

.IF "$(DEF7NAME)"!=""
DEF7TARGETN=$(MISC)/$(DEF7NAME).def
.ENDIF

.IF "$(DEF8NAME)"!=""
DEF8TARGETN=$(MISC)/$(DEF8NAME).def
.ENDIF

.IF "$(DEF9NAME)"!=""
DEF9TARGETN=$(MISC)/$(DEF9NAME).def
.ENDIF

# IZ65415 - catch obsolete macro. Can be removed later.
.IF "$(SDINAME)"!=""
.ERROR : ; @echo Forced error: SDINAME was used! Change your project to use SDIxNAME instead!
NO_SDINAME_allowed
.ENDIF

.IF "$(SDI1NAME)"!=""
.DIRCACHE=no
SDI1TARGET=$(MISC)/$(SDI1NAME).don
HIDSID1PARTICLE=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(MISC))/$(SDI1NAME)_sid.hid
.ENDIF

.IF "$(SDI2NAME)"!=""
.DIRCACHE=no
SDI2TARGET=$(MISC)/$(SDI2NAME).don
HIDSID2PARTICLE=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(MISC))/$(SDI2NAME)_sid.hid
.ENDIF

.IF "$(SDI3NAME)"!=""
.DIRCACHE=no
SDI3TARGET=$(MISC)/$(SDI3NAME).don
HIDSID3PARTICLE=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(MISC))/$(SDI3NAME)_sid.hid
.ENDIF

.IF "$(SDI4NAME)"!=""
.DIRCACHE=no
SDI4TARGET=$(MISC)/$(SDI4NAME).don
HIDSID4PARTICLE=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(MISC))/$(SDI4NAME)_sid.hid
.ENDIF

.IF "$(SDI5NAME)"!=""
.DIRCACHE=no
SDI5TARGET=$(MISC)/$(SDI5NAME).don
HIDSID5PARTICLE=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(MISC))/$(SDI5NAME)_sid.hid
.ENDIF

.IF "$(XMLPROPERTIES)"!=""
XMLPROPERTIESN:=$(foreach,i,$(XMLPROPERTIES) $(MISC)/$(TARGET)_$(i:s/.xrb/.done/))
.ENDIF			# "$(XMLPROPERTIES)"!=""

.IF "$(UNIXTEXT)"!=""
.IF "$(GUI)"=="UNX"
CONVERTUNIXTEXT:=$(UNIXTEXT)
.ENDIF			# "$(GUI)"=="UNX"
.ENDIF			# "$(UNIXTEXT)"!=""

.IF "$(EXTUPDATEINFO_NAME)"!=""
EXTUPDATEINFO_DEST:=$(MISC)/$(EXTUPDATEINFO_NAME)
EXTUPDATEINFO_SOURCE*=description.xml
.ENDIF			# "$(EXTUPDATEINFO_NAME)"!=""

.IF "$(JAVACLASSFILES:s/DEFINED//)"!="" || "$(javauno)"!=""
.IF "$(L10N_framework)"==""
TARGETDPJ=$(MISC)/$(TARGET).dpj
.ENDIF			# "$(L10N_framework)"==""
.ENDIF

.IF "$(no_hids)$(NO_HIDS)"==""
BUILDHIDS:=TRUE
.IF "$(GEN_HID_OTHER)"!=""
PRJHIDOTHERTARGET=$(SRS)/hidother.hid
COMMONPRJHIDOTHERTARGET=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(MISC)/$(TARGET)_othr.hid)
.ENDIF
.IF "$(GEN_HID2)"!=""
PRJHID2TARGET=$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(BIN))/hid.lst
.ENDIF
.ENDIF			# "$(no_hids)$(NO_HIDS)"==""

.IF "$(make_srs_deps)"==""
.IF "$(SRCFILES)" != "" || "$(SRC1FILES)" != "" || "$(SRC2FILES)" != ""
DPRTARGET= $(MISC)/$(TARGET).dpr
.ENDIF
.ENDIF

.IF "$(make_zip_deps)"==""
.IF "$(ZIP1TARGET)" != "" || "$(ZIP2TARGET)" != "" || "$(ZIP3TARGET)" != ""
DPZTARGET= $(MISC)/$(TARGET).dpz
.ENDIF			# "$(ZIP1TARGET)" != "" || "$(ZIP2TARGET)" != "" || "$(ZIP3TARGET)" != ""
.ENDIF			# "$(make_zip_deps)"==""

.IF "$(SOLAR_JAVA)"!=""
ALL_JAVA_TARGETS= \
		$(GENJAVAFILES) \
		$(JAVACLASSFILES) $(JAVA1CLASSFILES)	\
		$(JAVA2CLASSFILES)	$(JAVA3CLASSFILES) $(JAVA4CLASSFILES)\
		$(JAVA5CLASSFILES)	$(JAVA6CLASSFILES) $(JAVA7CLASSFILES)\
		$(JAVA8CLASSFILES)	$(JAVA9CLASSFILES) $(JAVA10CLASSFILES)\
		$(JAVA11CLASSFILES)	\
		$(JAVATARGET)	\
		$(TARGETDPJ)
.ENDIF          # "$(SOLAR_JAVA)"!=""
# -------
# - DEF -
# -------

# bei MAKE...DIR die gleiche Reihenfolge wie in settings.mak einhalten!

.IF "$(lintit)"==""
.IF "$(L10N_framework)"!=""
ALLTAR:	\
		"$(SOLARVERSION)/$(INPATH)/inc$(UPDMINOREXT)/$(UPD)minor.mk" \
		$(SUBDIRS)		\
		$(DPRTARGET) \
		$(DPZTARGET) \
        $(ZIPALL) \
		$(HIDSID1PARTICLE)	$(HIDSID2PARTICLE)		\
		$(HIDSID3PARTICLE)	$(HIDSID4PARTICLE)	$(HIDSID5PARTICLE)		\
		$(SDITARGET)	$(SDI1TARGET)	$(SDI2TARGET)		\
		$(SDI3TARGET)	$(SDI4TARGET)	$(SDI5TARGET)		\
		$(XMLPROPERTIESN) \
		$(RCTARGET) \
		$(SCP_PRODUCT_TYPE) \
		$(ALLPARFILES) \
		$(SCP1TARGETN) \
		$(SCP2TARGETN) \
		$(SCP3TARGETN) \
		$(SCP4TARGETN) \
		$(SCP5TARGETN) \
		$(SCP6TARGETN) \
		$(SCP7TARGETN) \
		$(SCP8TARGETN) \
		$(SCP9TARGETN) \
		$(SRC1TARGET)  \
		$(SRC2TARGET)  \
		$(SRC3TARGET)  \
		$(SRC4TARGET)	$(SRC5TARGET)	$(SRC6TARGET)		\
		$(SRC7TARGET)	$(SRC8TARGET)	$(SRC9TARGET)		\
		$(SRC10TARGET)	$(SRC11TARGET)	$(SRC12TARGET)		\
		$(SRC13TARGET)	$(SRC14TARGET)	$(SRC15TARGET)		\
		$(SRC16TARGET) \
        $(RSC_MULTI1) \
        $(RSC_MULTI2) \
        $(RSC_MULTI3) \
        $(RSC_MULTI4) \
        $(RSC_MULTI5) \
        $(RSC_MULTI6) \
        $(RSC_MULTI7) \
        $(RSC_MULTI8) \
        $(RSC_MULTI9) \
		$(INDPRESLIB1TARGETN) \
		$(RESLIB1TARGETN) $(RESLIB2TARGETN) \
		$(RESLIB3TARGETN) $(RESLIB4TARGETN) \
		$(RESLIB5TARGETN) $(RESLIB6TARGETN) \
		$(RESLIB7TARGETN) $(RESLIB8TARGETN) \
        $(COMMONPRJHIDOTHERTARGET) \
        $(PRJHID2TARGET) \
        $(LOCALIZE_ME_DEST)\
		last_target

.ELSE			# "$(L10N_framework)"!=""

ALLTAR: \
		"$(SOLARVERSION)/$(INPATH)/inc$(UPDMINOREXT)/$(UPD)minor.mk" \
		$(MAKEDEMODIR)	$(MAKECOMPDIR) $(MAKEXLDIR)	\
		$(COMPVERMK) \
		$(JAVAVERMK) \
		$(target_empty) \
		$(SUBDIRS)		\
		$(ALLMOZ) \
		$(DELDEFS)		\
		$(YACCTARGET)	\
		$(UNOUCRTARGET)	\
		$(UNOIDLDEPTARGETS) \
		$(DEPFILES) \
		$(DPRTARGET) \
		$(DPZTARGET) \
        $(ZIPALL) \
		$(SDITARGET)	\
		$(LOCALDBTARGET)	\
		$(LOCALDOCDBTARGET)	\
		$(UNOIDLDBTARGET)	\
		$(UNOIDLDBDOCTARGET)	\
		$(COMP1RDBTARGETN) \
		$(COMP2RDBTARGETN) \
		$(COMP3RDBTARGETN) \
		$(COMP4RDBTARGETN) \
		$(COMP5RDBTARGETN) \
		$(COMP6RDBTARGETN) \
		$(COMP7RDBTARGETN) \
		$(COMP8RDBTARGETN) \
		$(COMP9RDBTARGETN) \
		$(IDL1TARGET)	$(IDL2TARGET)	$(IDL3TARGET)		\
		$(IDL4TARGET)	$(IDL5TARGET)		\
		$(HIDSID1PARTICLE)	$(HIDSID2PARTICLE)		\
		$(HIDSID3PARTICLE)	$(HIDSID4PARTICLE)	$(HIDSID5PARTICLE)		\
		$(SDI1TARGET)	$(SDI2TARGET)	$(SDI3TARGET)		\
		$(SDI4TARGET)	$(SDI5TARGET)		\
		$(HXXCOPYTARGET) \
		$(NOLIBOBJTARGET) \
		$(NOLIBSLOTARGET) \
		$(OTHERTARRGET) \
		$(XMLPROPERTIESN) \
        $(ALL_JAVA_TARGETS) \
		$(OBJTARGET)	$(SLOTARGET)	$(SMRSLOTARGET)		\
		$($(SECOND_BUILD)SLOTARGET) \
		$($(SECOND_BUILD)OBJTARGET) \
		$(LIB1TARGET)	$(LIB2TARGET)	$(LIB3TARGET)		\
		$(LIB4TARGET)	$(LIB5TARGET)	$(LIB6TARGET)		\
		$(LIB7TARGET)	$(LIB8TARGET)	$(LIB9TARGET)		\
		$(LIB1ARCHIV)	$(LIB2ARCHIV)	$(LIB3ARCHIV)		\
		$(LIB4ARCHIV)	$(LIB5ARCHIV)	$(LIB6ARCHIV)		\
		$(LIB7ARCHIV)	$(LIB8ARCHIV)	$(LIB9ARCHIV)		\
		$(DEF1TARGETN)	$(DEF2TARGETN)	$(DEF3TARGETN)		\
		$(DEF4TARGETN)	$(DEF5TARGETN)	$(DEF6TARGETN)		\
		$(RCTARGET) \
		$(SHL1TARGETN) \
		$(SHL2TARGETN) \
		$(SHL3TARGETN) \
		$(SHL4TARGETN) \
		$(SHL5TARGETN) \
		$(SHL6TARGETN) \
		$(SHL7TARGETN) \
		$(SHL8TARGETN) \
		$(SHL9TARGETN) \
		$(SCP_PRODUCT_TYPE) \
		$(ALLPARFILES) \
		$(SCP1TARGETN) \
		$(SCP2TARGETN) \
		$(SCP3TARGETN) \
		$(SCP4TARGETN) \
		$(SCP5TARGETN) \
		$(SCP6TARGETN) \
		$(SCP7TARGETN) \
		$(SCP8TARGETN) \
		$(SCP9TARGETN) \
		$(APP1TARGETN)	$(APP2TARGETN)	$(APP3TARGETN)		\
		$(APP4TARGETN)	$(APP5TARGETN)	$(APP6TARGETN)		\
		$(APP7TARGETN)	$(APP8TARGETN)	$(APP9TARGETN)		\
		$(JARTARGETN)	\
		$(JARTARGETDEPN)	\
		$(SRC1TARGET)	\
		$(SRC2TARGET)	\
		$(SRC3TARGET)	\
		$(SRC4TARGET)	$(SRC5TARGET)	$(SRC6TARGET)		\
		$(SRC7TARGET)	$(SRC8TARGET)	$(SRC9TARGET)		\
		$(SRC10TARGET)	$(SRC11TARGET)	$(SRC12TARGET)		\
		$(SRC13TARGET)	$(SRC14TARGET)	$(SRC15TARGET)		\
		$(SRC16TARGET) \
        $(RSC_MULTI1) \
        $(RSC_MULTI2) \
        $(RSC_MULTI3) \
        $(RSC_MULTI4) \
        $(RSC_MULTI5) \
        $(RSC_MULTI6) \
        $(RSC_MULTI7) \
        $(RSC_MULTI8) \
        $(RSC_MULTI9) \
		$(INDPRESLIB1TARGETN) \
		$(RESLIB1TARGETN) $(RESLIB2TARGETN) \
		$(RESLIB3TARGETN) $(RESLIB4TARGETN) \
		$(RESLIB5TARGETN) $(RESLIB6TARGETN) \
		$(RESLIB7TARGETN) $(RESLIB8TARGETN) \
		$(RESLIB9TARGETN) \
        $(COMMONPRJHIDOTHERTARGET) \
        $(PRJHID2TARGET) \
                $(SIGNFORNETSCAPE) \
                $(SIGNFOREXPLORER) \
                $(SIGNFORJARSIGNER) \
		$(CONVERTUNIXTEXT) \
        $(LOCALIZE_ME_DEST)\
		$(EXTUPDATEINFO_DEST) \
		last_target

.IF "$(BUILD_X64)"!=""
ALLTAR : \
		$(NOLIBOBJTARGET_X64) \
		$(NOLIBSLOTARGET_X64) \
		$(OBJTARGET_X64)	$(SLOTARGET_X64) \
		$(LIB1TARGET_X64)	$(LIB2TARGET_X64)	\
		$(DEF1TARGETN_X64)	$(DEF2TARGETN_X64)	\
		$(SHL1TARGETN_X64) 	$(SHL2TARGETN_X64)
.ENDIF # "$(BUILD_X64)"!=""

ALLTAR : "$(SOLARINCDIR)/$(UPD)minor.mk"

.IF "$(EXCEPTIONSNOOPT_FLAG)"==""
TARGETDEPS+=$(EXCEPTIONSNOOPTTARGET)
.ENDIF

.IF "$(NOOPT_FLAG)"==""
TARGETDEPS+=$(NOOPTTARGET)
.ENDIF

#don't override .TARGETS when called with targets
.IF "$(MAKETARGETS)$(TNR)$(EXCEPTIONSNOOPT_FLAG)$(EXCEPTIONS_FLAG)$(NOOPT_FLAG)"==""
.IF "$(TARGETDEPS)"!=""
#.TARGETS .SEQUENTIAL :- $(TARGETDEPS) ALLTAR
.INIT .SEQUENTIAL : $(TARGETDEPS) $(NULLPRQ)
.ENDIF
.ENDIF

# -Gc breaks the dependency chain and causes indefinite nummbers of $(CPPUMAKER)
.IF "$(BOOTSTRAP_SERVICE)"!="TRUE"
CPPUMAKERFLAGS*=-L
.ENDIF			# "$(BOOTSTRAP_SERVICE)"!="TRUE"

.IF "$(UNOTYPES)" != ""
# makeing all in one
.DIRCACHE=no
.IF "$(ENVINCPRE)"!=""
MKDEPFLAGS+=-I:$(ENVINCPRE)
.ENDIF			# "$(ENVINCPRE))"!=""
.IF "$(OBJFILES)"!=""
$(OBJFILES) : $(UNOUCRTARGET)
.ENDIF			# "$(OBJFILES)"!=""
.IF "$(SLOFILES)"!=""
$(SLOFILES) : $(UNOUCRTARGET)
.ENDIF			# "$(SLOFILES)"!=""
.IF "$(DEPOBJFILES)"!=""
$(DEPOBJFILES) : $(UNOUCRTARGET)
.ENDIF			# "$(SLOFILES)"!=""
.IF "$(NOOPTTARGET)"!=""
$(NOOPTTARGET) : $(UNOUCRTARGET)
.ENDIF			# "$(SLOFILES)"!=""
.IF "$(NOOPTFILES)"!=""
$(NOOPTFILES) : $(UNOUCRTARGET)
.ENDIF			# "$(SLOFILES)"!=""
.IF "$(EXCEPTIONSFILES)"!=""
$(EXCEPTIONSFILES) : $(UNOUCRTARGET)
.ENDIF			# "$(SLOFILES)"!=""
.IF "$(EXCEPTIONSNOOPTTARGET)"!=""
$(EXCEPTIONSNOOPTTARGET) : $(UNOUCRTARGET)
.ENDIF			# "$(SLOFILES)"!=""
.IF "$(EXCEPTIONSNOOPTFILES)"!=""
$(EXCEPTIONSNOOPTFILES) : $(UNOUCRTARGET)
.ENDIF			# "$(SLOFILES)"!=""

$(UNOUCRTARGET) : $(UNOUCRHEADER)

# keep that one to rebuild single misses
$(UNOUCRHEADER):
	@noop
	
$(UNOUCRTARGET) : $(UNOUCRDEP)
.IF "$(XML2MK_FILES)"!=""
	@@-$(RM) $(foreach,i,$(XML2MK_FILES) $(MISC)/$(i).mk)
.ENDIF			# "$(XML2MK_FILES)"!=""
	@@-$(MKDIRHIER) $(UNOUCROUT)
	$(CPPUMAKER) @$(mktmp $(CPPUMAKERFLAGS) -B$(UNOUCRBASE) -O$(UNOUCROUT) $(UNOTYPES:^"-T")  $(UNOUCRRDB)) && $(TOUCH) $@
.ENDIF			# "$(UNOTYPES)" != ""

.IF "$(COMP1RDBTARGETN)"!=""
$(COMP1RDBTARGETN) : $(COMPRDB)
.ENDIF			# "$(COMP1RDBTARGETN)"!=""

.IF "$(COMP2RDBTARGETN)"!=""
$(COMP2RDBTARGETN) : $(COMPRDB)
.ENDIF			# "$(COMP2RDBTARGETN)"!=""

.IF "$(COMP3RDBTARGETN)"!=""
$(COMP3RDBTARGETN) : $(COMPRDB)
.ENDIF			# "$(COMP3RDBTARGETN)"!=""

.IF "$(COMP4RDBTARGETN)"!=""
$(COMP4RDBTARGETN) : $(COMPRDB)
.ENDIF			# "$(COMP4RDBTARGETN)"!=""

.IF "$(COMP5RDBTARGETN)"!=""
$(COMP5RDBTARGETN) : $(COMPRDB)
.ENDIF			# "$(COMP5RDBTARGETN)"!=""

.IF "$(COMP6RDBTARGETN)"!=""
$(COMP6RDBTARGETN) : $(COMPRDB)
.ENDIF			# "$(COMP6RDBTARGETN)"!=""

.IF "$(COMP7RDBTARGETN)"!=""
$(COMP7RDBTARGETN) : $(COMPRDB)
.ENDIF			# "$(COMP7RDBTARGETN)"!=""

.IF "$(COMP8RDBTARGETN)"!=""
$(COMP8RDBTARGETN) : $(COMPRDB)
.ENDIF			# "$(COMP8RDBTARGETN)"!=""

.IF "$(COMP9RDBTARGETN)"!=""
$(COMP9RDBTARGETN) : $(COMPRDB)
.ENDIF			# "$(COMP9RDBTARGETN)"!=""

.ENDIF			# "$(L10N_framework)"!=""
.ELSE			# "$(lintit)"==""

ALLTAR: $(OBJFILES) $(SLOFILES)

.ENDIF			# "$(lintit)"==""

.IF "$(SDINAME)"!=""
$(OBJ)/$(CINTERNAME).obj : $(SDITARGET)
.ENDIF

.IF "$(SDI1NAME)"!=""
$(OBJ)/$(CINTER1NAME).obj : $(SDI1TARGET)
.ENDIF

.IF "$(SDI2NAME)"!=""
$(OBJ)/$(CINTER2NAME).obj : $(SDI2TARGET)
.ENDIF

.IF "$(SDI3NAME)"!=""
$(OBJ)/$(CINTER3NAME).obj : $(SDI3TARGET)
.ENDIF

.IF "$(SDI4NAME)"!=""
$(OBJ)/$(CINTER4NAME).obj : $(SDI4TARGET)
.ENDIF

.IF "$(SDI5NAME)"!=""
$(OBJ)/$(CINTER5NAME).obj : $(SDI5TARGET)
.ENDIF

.IF "$(SOLAR_JAVA)"!=""
.IF "$(GENJAVAFILES)"!=""
$(GENJAVAFILES) : $(RDB)
$(JAVATARGET) : $(GENJAVAFILES)
.ENDIF			# "$(GENJAVAFILES)"!=""
.ENDIF          # "$(SOLAR_JAVA)"!=""

.IF "$(HXXCOPYFILES)" != ""
$(HXXCOPYTARGET):	$(HXXCOPYFILES)
	$(COPY) $(COPYUPDATE) $(HXXCOPYFILES) $(INCCOM) $(CHECKCOPYURESULT)
.ENDIF

.IF "$(UNIXTEXT)"!=""
$(UNIXTEXT) : $(UNIXTEXT:f)
	@echo Making $@
	@@-$(RM) -f $@
	@tr -d "\015" < $(@:f) > $@

.ENDIF			# "$(UNIXTEXT)"!=""

.IF "$(WITH_LANG)"!=""
.IF "$(LOCALIZESDF)"!=""

# dummy target to keep the build happy if not even the .zip exists. localization tools deal with not existing
# localize.sdf themself
"$(LOCALIZESDF)%":
	@echo $(LOCALIZESDF)
	@@-$(MKDIRHIER) $(@:d)
	@touch $@

.IF "$(LOCALIZATION_FOUND)"==""
.IF "$(LOCALSDFFILE)"!=""
$(LOCALSDFFILE) : $(SOLARCOMMONSDFDIR)$/$(PRJNAME).zip
	@@-$(MKDIRHIER) $(@:d)
    @@-$(MKDIRHIER) $(COMMONMISC)$/$(PRJNAME)_$(TARGET)
	-unzip -o -d $(COMMONMISC)$/$(PRJNAME) $(SOLARCOMMONSDFDIR)$/$(PRJNAME).zip $(subst,$(COMMONMISC)$/$(PRJNAME)$/, $@)
	$(TOUCH) $@

.ENDIF			# "$(LOCALSDFFILE)"!=""
.ENDIF			# "$(LOCALIZATION_FOUND)"==""
.ENDIF			# "$(LOCALIZESDF)"!=""
.ENDIF			# "$(WITH_LANG)"!=""

.IF "$(EXTUPDATEINFO_NAME)"!=""
$(EXTUPDATEINFO_DEST) : $(EXTUPDATEINFO_SOURCE)
	$(PERL) $(SOLARENV)/bin/make_ext_update_info.pl --out $(EXTUPDATEINFO_DEST) $(foreach,i,$(EXTUPDATEINFO_URLS) --update-url "$i") $(EXTUPDATEINFO_SOURCE)
.ENDIF			# "$(EXTUPDATEINFO_NAME)"!=""

makedoc:
		@@-mkdir $(OUT)/ucrdoc
		$(IDLC) @$(mktmp $(IDLCFLAGS) $(UNOIDLDEFS) $(UNOIDLINCEXTRA) $(UNOIDLINC) -C -O$(OUT)/ucrdoc/$(IDLPACKAGE) $(DEPIDLFILES:+"\n"))		
#		-$(UNOIDL) $(UNOIDLDEFS) $(UNOIDLINCEXTRA) $(UNOIDLINC) -Bdoc -P../$(PRJNAME)/$(IDLPACKAGE) -OH$(PRJ)/../unodoc $(DOCIDLFILES) $(IDLFILES)

.IF "$(LOCALDBTARGET)"!=""
$(LOCALDBTARGET) : $(URDFILES) $(DEPIDLFILES)
	$(IDLC) @$(mktmp $(IDLCFLAGS) $(UNOIDLDEFS) $(UNOIDLINCEXTRA) $(UNOIDLINC) -O$(OUT)/ucr/$(IDLPACKAGE) $(all_outdated_idl))
	-$(RM) $@
	$(REGMERGE) $@ UCR @$(mktmp $(URDFILES))
.ENDIF

.IF "$(LOCALDOCDBTARGET)"!=""
$(LOCALDOCDBTARGET) : $(URDDOCFILES) $(DEPIDLFILES)
	$(IDLC) @$(mktmp $(IDLCFLAGS) $(UNOIDLDEFS) $(UNOIDLINCEXTRA) $(UNOIDLINC) -C -O$(OUT)/ucrdoc/$(IDLPACKAGE) $(all_outdated_idl))
	-$(RM) $@
	$(REGMERGE) $@ UCR @$(mktmp $(URDDOCFILES))
.ENDIF

.IF "$(UNOIDLDBTARGET)"!=""
$(UNOIDLDBTARGET) : $(UNOIDLDBFILES) $(UNOIDLDBREGS)
	-$(RM) $@
	$(REGMERGE) $@ / @$(mktmp $(UNOIDLDBFILES) $(UNOIDLDBREGS))
.IF "$(LOCALREGDB)"!=""
	$(REGMERGE) $(LOCALREGDB) / $@
.ENDIF
.ENDIF			# "$(UNOIDLDBTARGET)"!=""

.IF "$(UNOIDLDBDOCTARGET)"!=""
$(UNOIDLDBDOCTARGET) : $(UNOIDLDBDOCFILES) $(UNOIDLDBDOCREGS)
	-$(RM) $@
	$(REGMERGE) $@ / @$(mktmp $(UNOIDLDBDOCFILES) $(UNOIDLDBDOCREGS))
.IF "$(LOCALREGDB)"!=""
	$(REGMERGE) $(LOCALREGDB) / $@
.ENDIF
.ENDIF			# "$(UNOIDLDBDOCTARGET)"!=""

.IF "$(SCP_PRODUCT_TYPE)"!=""
$(SCP_PRODUCT_TYPE):
	@@-$(MKDIRHIER) $(PAR)/$@
	@@-$(MKDIRHIER) $(BIN)/$@

.ENDIF			# "$(PARFILES)"!=""

"$(SOLARVERSION)/$(INPATH)/inc$(UPDMINOREXT)/minormkchanged.flg" :
	$(TOUCH) $@

.IF "$(COMPVERMK)"!=""
.IF "$(UPDATER)"!="" || "$(CWS_WORK_STAMP)"!=""
.IF "$(COMPATH:s!\!/!)"!="$(COMPATH_STORED)"
COMPVERMK_PHONY:=.PHONY
.ENDIF			# "$(COMPATH:s!\!/!)"!="$(COMPATH_STORED)"
COMPVTMP:=$(mktmp iii)
"$(COMPVERMK)" $(COMPVERMK_PHONY): $(SOLARVERSION)/$(INPATH)/inc$(UPDMINOREXT)/minormkchanged.flg
.IF "$(CCNUMVER)"!=""
	@echo COMNAME:=$(COMNAME) > $(COMPVTMP)
	@echo COMID:=$(COMID) >> $(COMPVTMP)
.IF "$(COM)"=="GCC"
    @echo SHORTSTDCPP3:=$(SHORTSTDCPP3) >> $(COMPVTMP)
.ENDIF
	@echo CCNUMVER:=$(CCNUMVER) >> $(COMPVTMP)
	@echo CCVER:=$(CCVER:s/-/ /:1) >> $(COMPVTMP)
	@echo CDEFS+=-DCPPU_ENV=$(COMNAME) >> $(COMPVTMP)
	@echo COMPATH_STORED:=$(COMPATH:s!\!/!) >> $(COMPVTMP)
	@@-$(RM) $(@)_$(COMPVTMP:b)
	@$(TYPE) $(COMPVTMP) | tr -d "\015" > $(@)_$(COMPVTMP:b)
	@$(IFEXIST) $@ $(THEN) $(RM:s/+//) $@ >& $(NULLDEV) $(FI)
	@-$(RENAME) $(@)_$(COMPVTMP:b) $@
	@@-$(RM) $(@)_$(COMPVTMP:b)
.ELSE           # "$(CCNUMVER)"!=""
	@@-$(RM) $@
.ENDIF          # "$(CCNUMVER)"!=""

.ENDIF			# "$(COMPVERMK)"!=""
.ENDIF			# "$(UPDATER)"!="" || "$(CWS_WORK_STAMP)"!=""

.IF "$(JAVAVERMK)"!=""
.IF "$(JAVALOCATION)"!="$(JAVA_HOME)"
"$(JAVAVERMK)" .PHONY :
.ELSE          # "$(JAVALOCATION)"!="$(JAVA_HOME)"
"$(JAVAVERMK)" : $(SOLARVERSION)/$(INPATH)/inc$(UPDMINOREXT)/minormkchanged.flg
.ENDIF          # "$(JAVALOCATION)"!="$(JAVA_HOME)"
    @-$(RM) $@
	@echo JAVAVER:=$(JAVAVER) > $@
	@echo JAVANUMVER:=$(JAVANUMVER) >> $@
	@echo JAVALOCATION:=$(JAVA_HOME) >> $@

.ENDIF			# "$(JAVAVERMK)"!=""

# on recursive call there seems to be one blank in TARGETDEP
# which makes it not empty :-(
.IF "$(TARGETDEPS:s/ //)"!=""
$(TARGETDEPS) : $(LOCALIZE_ME_DEST)
.ENDIF          # "$(TARGETDEPS)"!=""

.IF "$(LOCALIZE_ME_DEST)"!=""

.IF "$(WITH_LANG)"==""
$(LOCALIZE_ME_DEST) : $(LOCALIZE_ME)
	-$(RM) $(INCCOM)/$(TARGET)_lastrun.mk
    -$(MKDIR) $(@:d)
    -$(RM) $@
	$(COPY) $(@:b:+"_tmpl")$(@:e) $@

.ELSE			# "$(WITH_LANG)"==""
#  LASTRUN_MERGED
.INCLUDE .IGNORE : $(INCCOM)/$(TARGET)_lastrun.mk
.IF "$(LASTRUN_MERGED)"=="TRUE"
$(LOCALIZE_ME_DEST) : $(LOCALIZE_ME) $(LOCALIZESDF) 
.ELSE			# "$(LASTRUN_MERGED)"=="TRUE"
$(LOCALIZE_ME_DEST) .PHONY : $(LOCALIZE_ME) $(LOCALIZESDF) 
	echo LASTRUN_MERGED:=TRUE > $(INCCOM)/$(TARGET)_lastrun.mk
.ENDIF			# "$(LASTRUN_MERGED)"=="TRUE"
    -$(MKDIR) $(@:d)
    -$(RM) $@
	$(TRANSEX) -p $(PRJNAME) -i $(@:b:+"_tmpl")$(@:e) -o $(@:d)/$(@:b:+"_tmpl")$(@:e).$(INPATH) -m $(LOCALIZESDF) -l all
    $(RENAME) $(@:d)$(@:b:+"_tmpl")$(@:e).$(INPATH) $@

.ENDIF			# "$(WITH_LANG)"==""
.ENDIF          # "$(LOCALIZE_ME_DEST)"!=""

.IF "$(XMLPROPERTIES)"!=""
.IF "$(L10N_framework)"!=""
XML_ISO_CODE*=-ISO99 $(L10N_framework)
.ENDIF
.IF "$(WITH_LANG)"!=""
$(MISC)/$(TARGET)_%.done : $(COMMONMISC)/$(TARGET)/%.xrb
.ELSE			# "$(WITH_LANG)"!=""
$(MISC)/$(TARGET)_%.done : %.xrb
.ENDIF			# "$(WITH_LANG)"!=""
	@@-$(RM) $(MISC)/$(<:b).interm$(TARGET)
	native2ascii -encoding UTF8 $< $(MISC)/$(<:b).interm$(TARGET) && $(XMLEX) -i $(MISC)/$(<:b).interm$(TARGET) -o $(CLASSDIR) $(XML_ISO_CODE) -g -d $@
	@@$(RM)  $(MISC)/$(<:b).interm$(TARGET)
.ENDIF			# "$(XMLPROPERTIES)"!=""

.IF "$(HIDSID1PARTICLE)$(SDI1TARGET)$(HIDSID2PARTICLE)$(SDI2TARGET)$(HIDSID3PARTICLE)$(SDI3TARGET)$(HIDSID4PARTICLE)$(SDI4TARGET)$(HIDSID5PARTICLE)$(SDI5TARGET)$(HIDSID6PARTICLE)$(SDI6TARGET)$(HIDSID7PARTICLE)$(SDI7TARGET)$(HIDSID8PARTICLE)$(SDI8TARGET)$(HIDSID9PARTICLE)$(SDI9TARGET)"!=""
.INCLUDE : _tg_sdi.mk
.ENDIF			# "$(HIDSID1PARTICLE)$(SDI1TARGET)$(HIDSID2PARTICLE)$(SDI2TARGET)$(HIDSID3PARTICLE)$(SDI3TARGET)$(HIDSID4PARTICLE)$(SDI4TARGET)$(HIDSID5PARTICLE)$(SDI5TARGET)$(HIDSID6PARTICLE)$(SDI6TARGET)$(HIDSID7PARTICLE)$(SDI7TARGET)$(HIDSID8PARTICLE)$(SDI8TARGET)$(HIDSID9PARTICLE)$(SDI9TARGET)"!=""

.IF "$(DEF1NAME)$(DEF2NAME)$(DEF3NAME)$(DEF4NAME)$(DEF5NAME)$(DEF6NAME)$(DEF7NAME)$(DEF8NAME)$(DEF9NAME)"!=""
.INCLUDE : _tg_def.mk
.ENDIF

.IF "$(COMMONPRJHIDOTHERTARGET)"!=""
$(COMMONPRJHIDOTHERTARGET) : $(PRJHIDOTHERTARGET)
        @echo ------------------------------
        @echo Making: $@
        @$(IFEXIST) $@ $(THEN) $(RM:s/+//) $@ $(FI)
        $(TYPE) $(PRJHIDOTHERTARGET) > $@.$(ROUT).tmp 
	    @$(RENAME) $@.$(ROUT).tmp $@
.ENDIF	    

# -------
# - LIB -
# -------

.IF "$(OBJTARGET)$($(SECOND_BUILD)OBJTARGET)"!=""
.INCLUDE : tg_obj.mk
.ENDIF			# "$(OBJTARGET)$($(SECOND_BUILD)OBJTARGET)"!=""

# -------
# - SLB -
# -------

.IF "$(SLOTARGET)$($(SECOND_BUILD)SLOTARGET)"!=""
.INCLUDE : tg_slo.mk
.ENDIF			# "$(SLOTARGET)$($(SECOND_BUILD)SLOTARGET)"!=""

# --------
# - LIBS -
# --------

.IF "$(LIB1TARGET)$(LIB2TARGET)$(LIB3TARGET)$(LIB4TARGET)$(LIB5TARGET)$(LIB6TARGET)$(LIB7TARGET)$(LIB8TARGET)$(LIB9TARGET)" != ""
.INCLUDE : _tg_lib.mk
.ENDIF			# "$(LIB1TARGET)$(LIB2TARGET)$(LIB3TARGET)$(LIB4TARGET)$(LIB5TARGET)$(LIB6TARGET)$(LIB7TARGET)$(LIB8TARGET)$(LIB9TARGET)" != ""

# -------
# - SRS -
# -------

.IF "$(SRS1NAME)$(SRS2NAME)$(SRS3NAME)$(SRS4NAME)$(SRS5NAME)$(SRS6NAME)$(SRS7NAME)$(SRS8NAME)$(SRS9NAME)"!=""
.INCLUDE : _tg_srs.mk
.ENDIF          # "$(SRS1NAME)$(SRS2NAME)$(SRS3NAME)$(SRS4NAME)$(SRS5NAME)$(SRS6NAME)$(SRS7NAME)$(SRS8NAME)$(SRS9NAME)"!=""

# -------
# - RES -
# -------

.IF "$(RCTARGET)"!=""
.INCLUDE : tg_res.mk
.ENDIF			# "$(RCTARGET)"!=""

# -------
# - SHL -
# -------

.IF "$(SHL1TARGETN)$(SHL2TARGETN)$(SHL3TARGETN)$(SHL4TARGETN)$(SHL5TARGETN)$(SHL6TARGETN)$(SHL7TARGETN)$(SHL8TARGETN)$(SHL9TARGETN)"!=""
.INCLUDE : _tg_shl.mk
.ENDIF			# "$(SHL1TARGETN)$(SHL2TARGETN)$(SHL3TARGETN)$(SHL4TARGETN)$(SHL5TARGETN)$(SHL6TARGETN)$(SHL7TARGETN)$(SHL8TARGETN)$(SHL9TARGETN)"!=""

.IF "$(USE_VERSIONH)"!=""
.INIT .SEQUENTIAL : $(USE_VERSIONH) $(NULLPRQ)
.ENDIF          # "$(USE_VERSIONH)"!=""

# -------
# - APP -
# -------

.IF "$(APP1TARGETN)$(APP2TARGETN)$(APP3TARGETN)$(APP4TARGETN)$(APP5TARGETN)$(APP6TARGETN)$(APP7TARGETN)$(APP8TARGETN)$(APP9TARGETN)"!=""
.INCLUDE : _tg_app.mk
.ENDIF

# -------
# - SCP -
# -------

.IF "$(SCP1TARGETN)$(SCP2TARGETN)$(SCP3TARGETN)$(SCP4TARGETN)$(SCP5TARGETN)$(SCP6TARGETN)$(SCP7TARGETN)$(SCP8TARGETN)$(SCP9TARGETN)"!=""
.INCLUDE : _tg_scp.mk
.ENDIF

# -------
# - ZIP -
# -------

.IF "$(ZIP1TARGET)$(ZIP2TARGET)$(ZIP3TARGET)$(ZIP4TARGET)$(ZIP5TARGET)$(ZIP6TARGET)$(ZIP7TARGET)$(ZIP8TARGET)$(ZIP9TARGET)"!=""
.INCLUDE : _tg_zip.mk
.ENDIF

# -------
# - RESLIBTARGET -
# -------

.IF "$(RESLIB1TARGETN)$(RESLIB2TARGETN)$(RESLIB3TARGETN)$(RESLIB4TARGETN)$(RESLIB5TARGETN)$(RESLIB6TARGETN)$(RESLIB7TARGETN)$(RESLIB8TARGETN)$(RESLIB9TARGETN)"!=""
.INCLUDE : _tg_rslb.mk
.ENDIF

# -------
# - processing config -
# -------

.IF "$(XCSFILES)$(XCUFILES)"!=""
.INCLUDE : tg_config.mk
.ENDIF			# "$(XCSFILES)$(XCUFILES)"!=""


# ------------------
# - INCLUDE DEPEND -
# ------------------

# same block as in depend build
.IF "$(MAKEFILERC)"==""
.IF "$(RCFILES)$(SLOFILES)$(OBJFILES)$(DEPOBJFILES)$(PARFILES)" != ""
.IF "$(DEPFILES)" != ""
.INCLUDE : $(DEPFILES)
.ENDIF			# "$(DEPFILES)" != ""
.IF "$(nodep)"==""
.IF "$(DEPCOLLECT_SLO)" != ""
.PHONY : $(DEPCOLLECT_SLO)
.INCLUDE .IGNORE : $(DEPCOLLECT_SLO)
.INCLUDE : $(DEPFILE_SLO)
.ENDIF			# "$(DEPCOLLECT_SLO)" != ""
.IF "$(DEPCOLLECT_OBJ)" != ""
.PHONY : $(DEPCOLLECT_OBJ)
.INCLUDE .IGNORE : $(DEPCOLLECT_OBJ)
.INCLUDE : $(DEPFILE_OBJ)
.ENDIF			# "$(DEPCOLLECT_OBJ)" != ""
.ENDIF			# "$(nodep)"==""
.ENDIF			# "$(RCFILES)$(SLOFILES)$(OBJFILES)$(DEPOBJFILES)$(PARFILES)" != ""
.ELSE		# MAKEFILERC
.ENDIF		# MAKEFILERC

.IF "$(make_srs_deps)"==""
.IF "$(SRCFILES)" != "" || "$(SRC1FILES)" != "" || "$(SRC2FILES)" != ""
.IF "$(nodep)"==""
.INCLUDE : $(MISC)/$(TARGET).dpr
.ENDIF			# "$(nodep)"==""
.ENDIF
.ENDIF

.IF "$(make_zip_deps)"==""
.IF "$(ZIP1TARGET)" != "" || "$(ZIP2TARGET)" != "" || "$(ZIP3TARGET)" != ""
.IF "$(nodep)"==""
.INCLUDE : $(MISC)/$(TARGET).dpz
# introduce separation char
missing_zipdep_langs=$(alllangiso:^"+":+"+")
some_dummy_var:=$(foreach,i,$(zipdep_langs) $(assign missing_zipdep_langs:=$(strip $(subst,+$(i)+, $(missing_zipdep_langs)))))
.IF "$(missing_zipdep_langs)"!=""
ZIPDEPPHONY=.PHONY
.ENDIF			# "$(missing_zipdep_langs)"!=""
.ENDIF			# "$(nodep)"==""
.ENDIF
.ENDIF

last_target:
	@echo -------------

$(MISC)/$(TARGET)genjava.mk: 	$(IDLFILES)

.IF "$(JAVACLASSFILES:s/DEFINED//)"!=""
.IF "$(L10N_framework)"==""
.INCLUDE .IGNORE : $(MISC)/$(TARGET).dpj
$(TARGETDPJ) : $(JAVAFILES) $(JAVATARGET)
.ENDIF			# "$(L10N_framework)"==""
.ENDIF

.IF "$(JARTARGETN)"!=""
.INCLUDE : tg_jar.mk
.ENDIF			# "$(JARTARGETN)"!=""

# ----------------------------------
# - NOOPT - files ohne optimierung -
# ----------------------------------

.IF "$(NOOPTTARGET)" != ""
.IF "$(NOOPT_FLAG)" == ""

$(NOOPTTARGET):
	@echo --- NOOPTFILES ---
	@dmake $(MFLAGS) $(MAKEFILE) nopt=true $(NOOPTFILES) NOOPT_FLAG=TRUE $(CALLMACROS)
	@echo --- NOOPTFILES OVER ---

$(NOOPTFILES):
	@echo --- NOOPT ---
	@dmake $(MFLAGS) $(MAKEFILE) nopt=true NOOPT_FLAG=TRUE $(CALLMACROS) $@
	@echo --- NOOPT OVER ---
.ENDIF
.ENDIF


# ----------------------------------
# - EXCEPTIONSNOOPT - files with exceptions, without optimization -
# ----------------------------------

.IF "$(EXCEPTIONSNOOPTTARGET)" != ""
.IF "$(EXCEPTIONSNOOPT_FLAG)" == ""

$(EXCEPTIONSNOOPTTARGET):
	@echo --- EXCEPTIONSNOOPTFILES ---
	@dmake $(MFLAGS) $(MAKEFILE) ENABLE_EXCEPTIONS=true $(EXCEPTIONSNOOPTFILES) EXCEPTIONSNOOPT_FLAG=TRUE nopt=true $(CALLMACROS)
	@echo --- EXCEPTIONSNOOPTFILES OVER ---

$(EXCEPTIONSNOOPTFILES):
	@echo --- EXCEPTIONSNOOPT ---
	@dmake $(MFLAGS) $(MAKEFILE) ENABLE_EXCEPTIONS=true EXCEPTIONSNOOPT_FLAG=TRUE nopt=true $(CALLMACROS) $@
	@echo --- EXCEPTIONSNOOPT OVER ---


.ENDIF
.ENDIF

.IF "$(nodep)"==""
# recreate dependency files that were removed manually or vanished otherwise...
forcedeps: $(DEPFILE_SLO) $(DEPFILE_OBJ)
	@$(null,$(DEPS_MISSING) noop $(eq,$(sort $(DEPS_MISSING)),$(sort $(DEPS_MADE)) noop dmake depend=t $(MFLAGS) $(MAKEMACROS) ALLDEP))
	@noop $(foreach,i,$($(TARGET)_known_dpcc) $(assign DEPS_MADE:=$(subst,$i, $(DEPS_MADE))))
	@$(null,$(DEPS_MADE) noop $(null,$(DEPFILE_SLO) noop $(RM) $(DEPFILE_SLO)))
	@$(null,$(DEPS_MADE) noop $(null,$(DEPFILE_OBJ) noop $(RM) $(DEPFILE_OBJ)))

ALLTAR : forcedeps

.ENDIF			# "$(nodep)"==""

# -------------------------
# - several kill targets -
# -------------------------

"$(TMP)/makedt.don":
	@$(TOUCH) $(TMP)/makedt.don

killbin:
.IF "$(GUI)"=="WNT" || "$(GUI)"=="OS2"
	@$(IFEXIST) $(BIN)/$(SHL1TARGET).dll $(THEN) $(RM:s/+//) $(BIN)/$(SHL1TARGET).dll $(FI)
	@$(IFEXIST) $(BIN)/$(SHL2TARGET).dll $(THEN) $(RM:s/+//) $(BIN)/$(SHL2TARGET).dll $(FI)
	@$(IFEXIST) $(BIN)/$(SHL3TARGET).dll $(THEN) $(RM:s/+//) $(BIN)/$(SHL3TARGET).dll $(FI)
	@$(IFEXIST) $(BIN)/$(SHL4TARGET).dll $(THEN) $(RM:s/+//) $(BIN)/$(SHL4TARGET).dll $(FI)
	@$(IFEXIST) $(BIN)/$(SHL5TARGET).dll $(THEN) $(RM:s/+//) $(BIN)/$(SHL5TARGET).dll $(FI)
	@$(IFEXIST) $(BIN)/$(SHL6TARGET).dll $(THEN) $(RM:s/+//) $(BIN)/$(SHL6TARGET).dll $(FI)
	@$(IFEXIST) $(BIN)/$(SHL7TARGET).dll $(THEN) $(RM:s/+//) $(BIN)/$(SHL7TARGET).dll $(FI)
	@$(IFEXIST) $(BIN)/$(SHL8TARGET).dll $(THEN) $(RM:s/+//) $(BIN)/$(SHL8TARGET).dll $(FI)
	@$(IFEXIST) $(BIN)/$(SHL9TARGET).dll $(THEN) $(RM:s/+//) $(BIN)/$(SHL9TARGET).dll $(FI)
	@$(IFEXIST) $(BIN)/$(APP1TARGET)$(EXECPOST) $(THEN) $(RM:s/+//) $(BIN)/$(APP1TARGET)$(EXECPOST) $(FI)
	@$(IFEXIST) $(BIN)/$(APP2TARGET)$(EXECPOST) $(THEN) $(RM:s/+//) $(BIN)/$(APP2TARGET)$(EXECPOST) $(FI)
	@$(IFEXIST) $(BIN)/$(APP3TARGET)$(EXECPOST) $(THEN) $(RM:s/+//) $(BIN)/$(APP3TARGET)$(EXECPOST) $(FI)
	@$(IFEXIST) $(BIN)/$(APP4TARGET)$(EXECPOST) $(THEN) $(RM:s/+//) $(BIN)/$(APP4TARGET)$(EXECPOST) $(FI)
	@$(IFEXIST) $(BIN)/$(APP5TARGET)$(EXECPOST) $(THEN) $(RM:s/+//) $(BIN)/$(APP5TARGET)$(EXECPOST) $(FI)
	@$(IFEXIST) $(BIN)/$(APP6TARGET)$(EXECPOST) $(THEN) $(RM:s/+//) $(BIN)/$(APP6TARGET)$(EXECPOST) $(FI)
	@$(IFEXIST) $(BIN)/$(APP7TARGET)$(EXECPOST) $(THEN) $(RM:s/+//) $(BIN)/$(APP7TARGET)$(EXECPOST) $(FI)
	@$(IFEXIST) $(BIN)/$(APP8TARGET)$(EXECPOST) $(THEN) $(RM:s/+//) $(BIN)/$(APP8TARGET)$(EXECPOST) $(FI)
	@$(IFEXIST) $(BIN)/$(APP9TARGET)$(EXECPOST) $(THEN) $(RM:s/+//) $(BIN)/$(APP9TARGET)$(EXECPOST) $(FI)

.ELSE			# "$(GUI)"=="WNT"
.IF "$(SHL1TARGET)"!=""
	@-$(RM) $(LB)/$(SHL1DLLPRE)$(SHL1TARGET)$(DLLPOST)
.ENDIF
.IF "$(SHL2TARGET)"!=""
	@-$(RM) $(LB)/$(SHL2DLLPRE)$(SHL2TARGET)$(DLLPOST)
.ENDIF
.IF "$(SHL3TARGET)"!=""
	@-$(RM) $(LB)/$(SHL3DLLPRE)$(SHL3TARGET)$(DLLPOST)
.ENDIF
.IF "$(SHL4TARGET)"!=""
	@-$(RM) $(LB)/$(SHL4DLLPRE)$(SHL4TARGET)$(DLLPOST)
.ENDIF
.IF "$(SHL5TARGET)"!=""
	@-$(RM) $(LB)/$(SHL5DLLPRE)$(SHL5TARGET)$(DLLPOST)
.ENDIF
.IF "$(SHL6TARGET)"!=""
	@-$(RM) $(LB)/$(SHL6DLLPRE)$(SHL6TARGET)$(DLLPOST)
.ENDIF
.IF "$(SHL7TARGET)"!=""
	@-$(RM) $(LB)/$(SHL7DLLPRE)$(SHL7TARGET)$(DLLPOST)
.ENDIF
.IF "$(SHL8TARGET)"!=""
	@-$(RM) $(LB)/$(SHL8DLLPRE)$(SHL8TARGET)$(DLLPOST)
.ENDIF
.IF "$(SHL9TARGET)"!=""
	@-$(RM) $(LB)/$(SHL9DLLPRE)$(SHL9TARGET)$(DLLPOST)
.ENDIF
.IF "$(APP1TARGET)"!=""
	@-$(RM) $(BIN)/$(APP1TARGET)$(EXECPOST)
.ENDIF
.IF "$(APP2TARGET)"!=""
	@-$(RM) $(BIN)/$(APP2TARGET)$(EXECPOST)
.ENDIF
.IF "$(APP3TARGET)"!=""
	@-$(RM) $(BIN)/$(APP3TARGET)$(EXECPOST)
.ENDIF
.IF "$(APP4TARGET)"!=""
	@-$(RM) $(BIN)/$(APP4TARGET)$(EXECPOST)
.ENDIF
.IF "$(APP5TARGET)"!=""
	@-$(RM) $(BIN)/$(APP5TARGET)$(EXECPOST)
.ENDIF
.IF "$(APP6TARGET)"!=""
	@-$(RM) $(BIN)/$(APP6TARGET)$(EXECPOST)
.ENDIF
.IF "$(APP7TARGET)"!=""
	@-$(RM) $(BIN)/$(APP7TARGET)$(EXECPOST)
.ENDIF
.IF "$(APP8TARGET)"!=""
	@-$(RM) $(BIN)/$(APP8TARGET)$(EXECPOST)
.ENDIF
.IF "$(APP9TARGET)"!=""
	@-$(RM) $(BIN)/$(APP9TARGET)$(EXECPOST)
.ENDIF
.ENDIF			# "$(GUI)"=="WNT"

killobj:
.IF "$(SLOFILES)" != ""
	-cd $(SLO) && $(TYPE:s/+//) $(mktmp  $(SLOFILES:f)) | xargs -n 20 rm 
	-cd $(SLO) && $(TYPE:s/+//) $(mktmp  $(SLOFILES:s/.obj/.o/:f)) | xargs -n 20 rm
.ENDIF
.IF "$(OBJFILES)" != ""
	-cd $(OBJ) && $(TYPE:s/+//) $(mktmp  $(OBJFILES:f)) | xargs -n 20 rm 
	-cd $(OBJ) && $(TYPE:s/+//) $(mktmp  $(OBJFILES:s/.obj/.o/:f)) | xargs -n 20 rm
.ENDIF

.IF "$(REAL_$(SECOND_BUILD)_SLOFILES)" != ""
	-cd $(REAL_$(SECOND_BUILD)_SLO) && $(TYPE:s/+//) $(mktmp  $(REAL_$(SECOND_BUILD)_SLOFILES:f)) | xargs -n 20 rm
	-cd $(REAL_$(SECOND_BUILD)_SLO) && $(TYPE:s/+//) $(mktmp  $(REAL_$(SECOND_BUILD)_SLOFILES:s/.obj/.o/:f)) | xargs -n 20 rm
.ENDIF
.IF "$(REAL_$(SECOND_BUILD)_OBJFILES)" != ""
	-cd $(REAL_$(SECOND_BUILD)_OBJ) && $(TYPE:s/+//) $(mktmp  $(REAL_$(SECOND_BUILD)_OBJFILES:f)) | xargs -n 20 rm 
	-cd $(REAL_$(SECOND_BUILD)_OBJ) && $(TYPE:s/+//) $(mktmp  $(REAL_$(SECOND_BUILD)_OBJFILES:s/.obj/.o/:f)) | xargs -n 20 rm
.ENDIF
.IF "$(DEPOBJFILES)" != ""
	-cd $(SLO) && $(TYPE:s/+//) $(mktmp  $(DEPOBJFILES:f)) | xargs -n 20 rm
	-cd $(SLO) && $(TYPE:s/+//) $(mktmp  $(DEPOBJFILES:s/.obj/.o/:f)) | xargs -n 20 rm
	-cd $(OBJ) && $(TYPE:s/+//) $(mktmp  $(DEPOBJFILES:f)) | xargs -n 20 rm
	-cd $(OBJ) && $(TYPE:s/+//) $(mktmp  $(DEPOBJFILES:s/.obj/.o/:f)) | xargs -n 20 rm
.ENDIF
	@echo objects weg!

killsrs:
# doesn't work - fix me!
.IF "$(SRSFILES)" != ""
	$(RM) $(SRSFILES)
.ENDIF
	@echo srsfiles weg!

killres:
.IF "$(RESLIB1TARGETN)$(RESLIB2TARGETN)$(RESLIB3TARGETN)$(RESLIB4TARGETN)$(RESLIB5TARGETN)$(RESLIB6TARGETN)$(RESLIB7TARGETN)$(RESLIB8TARGETN)$(RESLIB9TARGETN)"!=""
	$(RM) $(RESLIB1TARGETN) $(RESLIB2TARGETN) $(RESLIB3TARGETN) $(RESLIB4TARGETN) $(RESLIB5TARGETN) $(RESLIB6TARGETN) $(RESLIB7TARGETN) $(RESLIB8TARGETN) $(RESLIB9TARGETN)
	@echo resource files removed!
.ELSE			# "$(RESLIB1TARGETN)$(RESLIB2TARGETN)$(RESLIB3TARGETN)$(RESLIB4TARGETN)$(RESLIB5TARGETN)$(RESLIB6TARGETN)$(RESLIB7TARGETN)$(RESLIB8TARGETN)$(RESLIB9TARGETN)"!=""
	@echo no resource files defined!
.ENDIF			# "$(RESLIB1TARGETN)$(RESLIB2TARGETN)$(RESLIB3TARGETN)$(RESLIB4TARGETN)$(RESLIB5TARGETN)$(RESLIB6TARGETN)$(RESLIB7TARGETN)$(RESLIB8TARGETN)$(RESLIB9TARGETN)"!=""

killdef:
.IF "$(DEFTARGETN)" != ""
	$(RM) $(DEFTARGETN)
.ENDIF
	@echo deffiles weg!

killlib:
.IF "$(LIB1TARGETN)$(LIB2TARGETN)$(LIB3TARGETN)$(LIB4TARGETN)$(LIB5TARGETN)$(LIB6TARGETN)$(LIB7TARGETN)$(LIB8TARGETN)$(LIB9TARGETN)"!=""
	$(RM) $(LIB1TARGETN) $(LIB2TARGETN) $(LIB3TARGETN) $(LIB4TARGETN) $(LIB5TARGETN) $(LIB6TARGETN) $(LIB7TARGETN) $(LIB8TARGETN) $(LIB9TARGETN)
.IF "$(LIB1ARCHIV)$(LIB2ARCHIV)$(LIB3ARCHIV)$(LIB4ARCHIV)$(LIB5ARCHIV)$(LIB6ARCHIV)$(LIB7ARCHIV)$(LIB8ARCHIV)$(LIB9ARCHIV)"!=""
	$(RM) $(LIB1ARCHIV) $(LIB2ARCHIV) $(LIB3ARCHIV) $(LIB4ARCHIV) $(LIB5ARCHIV) $(LIB6ARCHIV) $(LIB7ARCHIV) $(LIB8ARCHIV) $(LIB9ARCHIV)
.ENDIF			# "$(LIB1ARCHIV)$(LIB2ARCHIV)$(LIB3ARCHIV)$(LIB4ARCHIV)$(LIB5ARCHIV)$(LIB6ARCHIV)$(LIB7ARCHIV)$(LIB8ARCHIV)$(LIB9ARCHIV)"!=""
	@echo lib/archive files removed!
.ENDIF			# "$(LIB1TARGETN)$(LIB2TARGETN)$(LIB3TARGETN)$(LIB4TARGETN)$(LIB5TARGETN)$(LIB6TARGETN)$(LIB7TARGETN)$(LIB8TARGETN)$(LIB9TARGETN)"!=""
.IF "$(SLOTARGET)$(OBJTARGET)"!=""
	$(RM) $(SLOTARGET) $(OBJTARGET)
	@echo default lib files removed!
.ENDIF			# "$(SLOTARGET)$(OBJTARGET)"!=""
	@echo done!

clean_misc :
.IF "$(MISC)"!=""
	rm -rf $(MISC)/*
	@echo misc is gone!
.ELSE			# "$(MISC)"!=""
	@echo can\'t be done! $$(MISC) not defined.
.ENDIF			# "$(MISC)"!=""

clean_all :
.IF "$(OUT)"!=""
	test -f $(PRJ)/prj/build.lst && rm -rf $(OUT)
	@echo local output tree is gone!
.ELSE			# "$(OUT)"!=""
	@echo can\'t be done! $$(OUT) not defined.
.ENDIF			# "$(OUT)"!=""


SRCALLTARGET:	\
		$(SDITARGET)	$(SDI1TARGET)	$(SDI2TARGET)		\
		$(SDI3TARGET)	$(SDI4TARGET)	$(SDI5TARGET)		\
		$(SRC1TARGET)	\
		$(SRC2TARGET)	\
		$(SRC3TARGET)	$(RCTARGET)		  \
		$(SRC4TARGET)	$(SRC5TARGET)	$(SRC6TARGET)		\
		$(SRC7TARGET)	$(SRC8TARGET)	$(SRC9TARGET)		\
		$(SRC10TARGET)	$(SRC11TARGET)	$(SRC12TARGET)		\
		$(SRC13TARGET)	$(SRC14TARGET)	$(SRC15TARGET)		\
		$(SRC16TARGET)

.IF "$(ZIP1TARGETN)$(ZIP2TARGETN)$(ZIP3TARGETN)$(ZIP4TARGETN)$(ZIP5TARGETN)$(ZIP6TARGETN)$(ZIP7TARGETN)$(ZIP8TARGETN)$(ZIP9TARGETN)"!=""
ZIPALLTARGET: \
		$(ZIP1TARGETN) \
		$(ZIP2TARGETN) \
		$(ZIP3TARGETN) \
		$(ZIP4TARGETN) \
		$(ZIP5TARGETN) \
		$(ZIP6TARGETN) \
		$(ZIP7TARGETN) \
		$(ZIP8TARGETN) \
		$(ZIP9TARGETN)
.ELSE
ZIPALLTARGET:
	@echo ---
	@echo nothing to zip for activated languages!
	@echo ---
.ENDIF


#temporary workaround for non-existing delzip in extras
delzip:
	@echo
	@echo ERROR: ZIPnTARGETS need a file named "delzip" to exist beside their makefile.mk
	@echo ERROR: Create an empty file named delzip and commit it
	@echo ERROR: for details see #i78434#
	force_dmake_to_error

.IF "$(make_srs_deps)"==""
$(MISC)/$(TARGET).dpr : $(SRCFILES) $(SRC1FILES) $(SRC2FILES) $(SRC3FILES)
.ENDIF

.IF "$(make_zip_deps)"==""
$(MISC)/$(TARGET).dpz $(ZIPDEPPHONY) : $(ZIP1TARGETN) $(ZIP2TARGETN) $(ZIP3TARGETN) $(ZIP4TARGETN) $(ZIP5TARGETN) $(ZIP6TARGETN) $(ZIP7TARGETN) $(ZIP8TARGETN) $(ZIP9TARGETN)
.ENDIF

VERSIONTMP:=$(mktmp iii)
$(INCCOM)/%_version.h : $(SOLARVERSION)/$(INPATH)/inc$(UPDMINOREXT)/minormkchanged.flg
	@echo $(EMQ)#define _BUILD $(EMQ)"$(BUILD)$(EMQ)" > $(VERSIONTMP)
	@echo $(EMQ)#define _UPD $(EMQ)"$(UPD)$(EMQ)"                 >> $(VERSIONTMP)
	@echo $(EMQ)#define _LAST_MINOR $(EMQ)"$(LAST_MINOR)$(EMQ)"   >> $(VERSIONTMP)
	@echo $(EMQ)#define _RSCREVISION $(EMQ)"$(USQ)$(RSCREVISION)$(USQ)$(EMQ)" >> $(VERSIONTMP)
	@echo $(EMQ)#define _INPATH $(EMQ)"$(INPATH)$(EMQ)"           >> $(VERSIONTMP)
	@@-$(RM) $(@)_$(VERSIONTMP:b)
	@$(TYPE) $(VERSIONTMP) > $(@)_$(VERSIONTMP:b)
	@@-$(RM) $@
	@-$(RENAME) $(@)_$(VERSIONTMP:b) $@

.IF "$(MAKEFILERC)"==""
warn_target_empty:
	@echo '*'
	@echo '* error $$(TARGET) is empty - this will cause problems'
	@echo '*'
	force_dmake_to_error
.ELSE
warn_target_empty:
	@echo generated makefile.rc detected
.ENDIF

.IF "$(UNOTYPES)" != ""
UNOUCRDEPxxx : $(UNOUCRDEP);
.ENDIF			# "$(UNOTYPES)" != ""


#new hid.lst trigger with GEN_HID2=TRUE
$(subst,$(OUTPATH),$(COMMON_OUTDIR) $(BIN))/hid.lst .PHONY :
	@echo Making $@ :
	@echo ---------------
	@echo $(WORK_STAMP).$(LAST_MINOR) 010101010101010 > $@.$(ROUT).tmp
	$(TYPE) $(SOLARCOMMONBINDIR)/hid/*.hid | tr -d "\015" | $(SORT) -u >> $@.$(ROUT).tmp 
	@$(IFEXIST) $@ $(THEN) $(RM:s/+//) $@ $(FI)
	@-$(RENAME) $@.$(ROUT).tmp $@
	@-mkdir $(@:d)hid
	$(PERL) $(SOLARENV)/bin/gen_userfeedback_VCL_names.pl $@ $(SOLARCOMMONBINDIR)/win $(subst,$(OUTPATH),$(COMMON_OUTDIR) $(BIN))/hid/userfeedback_VCL_names.csv.$(ROUT).tmp
	@$(IFEXIST) $@ $(THEN) $(RM:s/+//) $(subst,$(OUTPATH),$(COMMON_OUTDIR) $(BIN))/hid/userfeedback_VCL_names.csv $(FI)
	@-$(RENAME) $(subst,$(OUTPATH),$(COMMON_OUTDIR) $(BIN))/hid/userfeedback_VCL_names.csv.$(ROUT).tmp $(subst,$(OUTPATH),$(COMMON_OUTDIR) $(BIN))/hid/userfeedback_VCL_names.csv


.IF "$(SOLAR_JAVA)"!=""
.IF "$(JAVACLASSFILES:s/DEFINED//)$(javauno)"!=""
.INCLUDE : tg_java.mk
.ENDIF			# "$(JAVACLASSFILES:s/DEFINED//)$(javauno)"!=""
.ENDIF          # "$(SOLAR_JAVA)"!=""

.INCLUDE : tg_merge.mk

wordcount:
	wc *.* >> $(TMP)/wc.lst

testt:
	@echo test

.ELSE			# "$(depend)" == ""

# ----------
# - DEPEND -
# ----------

ALLTAR : ALLDEP \
		$(SUBDIRS)

# same block as in regular build
.IF "$(MAKEFILERC)"==""
.IF "$(RCFILES)$(SLOFILES)$(OBJFILES)$(DEPOBJFILES)$(PARFILES)" != ""
.IF "$(DEPFILES)" != ""
.INCLUDE : $(DEPFILES)
.ENDIF			# "$(DEPFILES)" != ""
.IF "$(nodep)"==""
.IF "$(DEPCOLLECT_SLO)" != ""
.PHONY : $(DEPCOLLECT_SLO)
.INCLUDE .IGNORE : $(DEPCOLLECT_SLO)
.INCLUDE : $(DEPFILE_SLO)
.ENDIF			# "$(DEPCOLLECT_SLO)" != ""
.IF "$(DEPCOLLECT_OBJ)" != ""
.PHONY : $(DEPCOLLECT_OBJ)
.INCLUDE .IGNORE : $(DEPCOLLECT_OBJ)
.INCLUDE : $(DEPFILE_OBJ)
.ENDIF			# "$(DEPCOLLECT_OBJ)" != ""
.ENDIF			# "$(nodep)"==""
.ENDIF			# "$(RCFILES)$(SLOFILES)$(OBJFILES)$(DEPOBJFILES)$(PARFILES)" != ""
.ELSE		# MAKEFILERC
.ENDIF		# MAKEFILERC

.INCLUDE : tg_dep.mk

.ENDIF			# "$(depend)" == ""

.IF "$(SUBDIRS)"!=""

$(SUBDIRS) : $(SUBDIRSDEPS)

.IF "$(mk_tmp)$(BSCLIENT)"!=""
$(SUBDIRS)  .PHONY :
	@echo ignoring SUBDIRS

.ELSE			# "$(mk_tmp)$(BSCLIENT)"!=""
#.IF "$(PRJNAME)"!="sw"
.IF "$(GUI)"!="UNX"
$(SUBDIRS) .PHONY :
	@[
		cd $@
		cd
		@$(MAKECMD) subdmake=true $(MFLAGS) $(CALLMACROS)
	]
.ELSE			# "$(GUI)"!="UNX"
$(SUBDIRS) .PHONY :
	cd $@; $(MAKECMD) subdmake=true $(MFLAGS) $(CALLMACROS)
.ENDIF			# "$(GUI)"!="UNX"
#.ENDIF
.ENDIF			# "$(mk_tmp)$(BSCLIENT)"!=""
.ENDIF			# "$(SUBDIRS)"!=""

# workaround for strange dmake bug:
# if the previous block was a rule or a target, "\#" isn't recognized
# as an escaped "#". if it was an assignment, escaping works...
some_unique_variable_name:=1
