/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: functiondescription.hxx,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef INCLUDED_stoc_source_registry_tdprovider_functiondescription_hxx
#define INCLUDED_stoc_source_registry_tdprovider_functiondescription_hxx

#include "com/sun/star/uno/Reference.hxx"
#include "com/sun/star/uno/Sequence.hxx"
#include "osl/mutex.hxx"
#include "sal/types.h"

namespace com { namespace sun { namespace star {
    namespace container {
        class XHierarchicalNameAccess;
    }
    namespace reflection {
        class XCompoundTypeDescription;
    }
} } }
namespace typereg { class Reader; }

namespace stoc { namespace registry_tdprovider {

class FunctionDescription {
public:
    FunctionDescription(
        com::sun::star::uno::Reference<
            com::sun::star::container::XHierarchicalNameAccess > const &
            manager,
        com::sun::star::uno::Sequence< sal_Int8 > const & bytes,
        sal_uInt16 index);

    ~FunctionDescription();

    com::sun::star::uno::Sequence<
        com::sun::star::uno::Reference<
            com::sun::star::reflection::XCompoundTypeDescription > >
    getExceptions() const;

protected:
    typereg::Reader getReader() const;

    com::sun::star::uno::Reference<
        com::sun::star::container::XHierarchicalNameAccess > m_manager;
    com::sun::star::uno::Sequence< sal_Int8 > m_bytes;
    sal_uInt16 m_index;

    mutable osl::Mutex m_mutex;
    mutable com::sun::star::uno::Sequence<
        com::sun::star::uno::Reference<
            com::sun::star::reflection::XCompoundTypeDescription > >
                m_exceptions;
    mutable bool m_exceptionsInit;

private:
    FunctionDescription(FunctionDescription &); // not implemented
    void operator =(FunctionDescription); // not implemented
};

} }

#endif
