/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: goodies_b3dentty.cxx,v $
 * $Revision: 1.5 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _B3D_B3DENTITY_HXX
#include "b3dentty.hxx"
#endif

//#ifndef _B3D_B3DCOMMN_HXX
//#include "b3dcommn.hxx"
//#endif

#ifndef _B3D_B3DTRANS_HXX
#include "b3dtrans.hxx"
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

namespace binfilter {
/*************************************************************************
|*
|* Flags auf Ausgangsposition
|*
\************************************************************************/

void B3dEntity::Reset()
{
	bValid = bNormalUsed = bTexCoorUsed = bDeviceCoor = FALSE;
	bEdgeFlag = TRUE;
}

/*************************************************************************
|*
|* Neuen Punkt an der stelle t des parametrisierten Vektors rOld1, rOld2
|* berechnen und fuellen
|*
\************************************************************************/

void B3dEntity::CalcInBetween(B3dEntity& rOld1, B3dEntity& rOld2, double t)
{
	// DeviceCoor der ersten Quelle benutzen, die Basis sollte
	// vorher abgeglichen sein
	SetDeviceCoor(rOld1.IsDeviceCoor());

	// Punktkoordinaten berechnen
	aPoint.CalcInBetween(rOld1.Point(), rOld2.Point(), t);
	SetValid();

	// PlaneNormal Koordinaten berechnen
	rOld1.PlaneNormal().Normalize();
	rOld2.PlaneNormal().Normalize();
	aPlaneNormal.CalcInBetween(rOld1.PlaneNormal(), rOld2.PlaneNormal(), t);
	aPlaneNormal.Normalize();

	// Vektor berechnen
	if(rOld1.IsNormalUsed() && rOld2.IsNormalUsed())
	{
		rOld1.Normal().Normalize();
		rOld2.Normal().Normalize();
		aNormal.CalcInBetween(rOld1.Normal(), rOld2.Normal(), t);
		aNormal.Normalize();
		SetNormalUsed();
	}

	// Texturkoordinaten berechnen
	if(rOld1.IsTexCoorUsed() && rOld2.IsTexCoorUsed())
	{
		aTexCoor.CalcInBetween(rOld1.TexCoor(), rOld2.TexCoor(), t);
		SetTexCoorUsed();
	}

	// EdgeVisible berechnen
	SetEdgeVisible(rOld1.IsEdgeVisible());

	// Farbe berechnen
	aColor.CalcInBetween(rOld1.Color(), rOld2.Color(), t);
}

/*************************************************************************
|*
|* Neuen Punkt in der Mitte des parametrisierten Vektors rOld1, rOld2
|* berechnen und fuellen
|*
\************************************************************************/

void B3dEntity::CalcMiddle(B3dEntity& rOld1, B3dEntity& rOld2)
{
	// DeviceCoor der ersten Quelle benutzen, die Basis sollte
	// vorher abgeglichen sein
	SetDeviceCoor(rOld1.IsDeviceCoor());

	// Punktkoordinaten berechnen
	aPoint.CalcMiddle(rOld1.Point(), rOld2.Point());
	SetValid();

	// PlaneNormal Koordinaten berechnen
	rOld1.PlaneNormal().Normalize();
	rOld2.PlaneNormal().Normalize();
	aPlaneNormal.CalcMiddle(rOld1.PlaneNormal(), rOld2.PlaneNormal());
	aPlaneNormal.Normalize();

	// Vektor berechnen
	if(rOld1.IsNormalUsed() && rOld2.IsNormalUsed())
	{
		rOld1.Normal().Normalize();
		rOld2.Normal().Normalize();
		aNormal.CalcMiddle(rOld1.Normal(), rOld2.Normal());
		aNormal.Normalize();
		SetNormalUsed();
	}

	// Texturkoordinaten berechnen
	if(rOld1.IsTexCoorUsed() && rOld2.IsTexCoorUsed())
	{
		aTexCoor.CalcMiddle(rOld1.TexCoor(), rOld2.TexCoor());
		SetTexCoorUsed();
	}

	// EdgeVisible berechnen
	SetEdgeVisible(rOld1.IsEdgeVisible());

	// Farbe berechnen
	aColor.CalcMiddle(rOld1.Color(), rOld2.Color());
}

/*************************************************************************
|*
|* Bucket fuer geometrische Daten
|*
\************************************************************************/

BASE3D_IMPL_BUCKET(B3dEntity, Bucket)

}//end of namespace binfilter

// eof
