/* @(#)niread.c	1.12 04/08/08 Copyright 1986, 1996-2003 J. Schilling */
/*
 *	Non interruptable read
 *
 *	Copyright (c) 1986, 1996-2003 J. Schilling
 */
/*
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * See the file CDDL.Schily.txt in this distribution for details.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file CDDL.Schily.txt from this distribution.
 */

#include "schilyio.h"
#include <errno.h>

EXPORT int
_niread(f, buf, count)
	int	f;
	void	*buf;
	int	count;
{
	int	ret;
	int	oerrno = geterrno();

	while ((ret = read(f, buf, count)) < 0 && geterrno() == EINTR) {
		/*
		 * Set back old 'errno' so we don't change the errno visible
		 * to the outside if we did not fail.
		 */
		seterrno(oerrno);
	}
	return (ret);
}
