
/**************************************************************************
 *                                                                        *
 *  BTools - Miscellaneous Java utility classes                           *
 *                                                                        *
 *  Copyright (c) 1998-2001, Ben Burton                                   *
 *  For further details contact Ben Burton (benb@acm.org).                *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

package org.gjt.btools.ext;

import java.awt.*;
import javax.swing.text.*;

/**
 * A document class used to enter a non-negative integer into a text
 * component.
 * This class ensures that the input contains only digits.
 */
public class NonNegativeIntegerDocument extends PlainDocument {
    /**
     * Attempts to insert a string into the document.
     */
    public void insertString(int offs, String str, AttributeSet a)
            throws BadLocationException {
        boolean error = false;
        for (int i=0; i < str.length(); i++)
            if (! Character.isDigit(str.charAt(i))) {
                error = true;
                break;
            }

        if (error)
            Toolkit.getDefaultToolkit().beep();
        else
            super.insertString(offs, str, a);
    }

    /**
     * Returns the integer value stored in the document as an <tt>int</tt>.
     *
     * @return the non-negative integer stored, or -1 if the document is
     * empty.
     */
    public int getIntValue() {
        try {
            return Integer.parseInt(getText(0, getLength()));
        } catch (Exception e) {
            return -1;
        }
    }

    /**
     * Returns the integer value stored in the document as a <tt>long</tt>.
     *
     * @return the non-negative integer stored, or -1 if the document is
     * empty.
     */
    public long getLongValue() {
        try {
            return Long.parseLong(getText(0, getLength()));
        } catch (Exception e) {
            return -1;
        }
    }
}
