/**
 * ========================================
 * JFreeReport : a free Java report library
 * ========================================
 *
 * Project Info:  http://www.object-refinery.com/jfreereport/index.html
 * Project Lead:  Thomas Morgner (taquera@sherito.org);
 *
 * (C) Copyright 2000-2002, by Simba Management Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * -----------------------
 * DataRowConnectable.java
 * -----------------------
 * (C)opyright 2002, by Thomas Morgner and Contributors.
 *
 * Original Author:  Thomas Morgner;
 * Contributor(s):   David Gilbert (for Simba Management Limited);
 *
 * $Id: DataRowConnectable.java,v 1.3 2002/12/06 17:21:42 mungady Exp $
 *
 * Changes
 * -------
 * 27-Jul-2002 : Initial version
 * 06-Dec-2002 : Updated Javadocs (DG);
 *
 */

package com.jrefinery.report.filter;

import com.jrefinery.report.DataRow;

/**
 * Marks data sources that can be connected to the data row (for example, the DataRowDataSource).
 *
 * @see DataRowDataSource
 *
 * @author Thomas Morgner
 */
public interface DataRowConnectable
{
  /**
   * Connects the DataRow to the data source.
   *
   * @param row  the data row.
   *
   * @throws IllegalStateException if there is already a data row connected.
   */
  public void connectDataRow (DataRow row) throws IllegalStateException;

  /**
   * Releases the connection to the data row. 
   * <p>
   * If no data row is connected, an <code>IllegalStateException</code> is thrown to indicate the 
   * programming error.
   *
   * @param row  the data row.
   *
   * @throws IllegalStateException if there is already a data row connected.
   */
  public void disconnectDataRow (DataRow row) throws IllegalStateException;

}
