/*
 * snes9express
 * netplay.cc
 * Copyright  1998  David Nordlund
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * For further details, please read the included COPYING file,
 * or go to http://www.gnu.org/copyleft/gpl.html
 */

#include <stdlib.h>
#include "netplay.h"

s9x_NetPlay::s9x_NetPlay(fr_Notebook*parent):
s9x_Notepage(parent, "NetPlay"),
UseNetPlay(this, "Use NetPlay", false),
s9xServer(this, "Server:", "", false),
s9xPort(this, "Port:", S9X_NETPLAY_PORT, 1024, 65536, 0)
{
   SetGridSize(2, 2, false);

   UseNetPlay.Args << fr_CaseInsensitive << "-net";
   UseNetPlay.SetTooltip("Play a multiplayer game on the network");
   UseNetPlay.AddListener(this);
   Pack(UseNetPlay, 2, 1);
   addOption(UseNetPlay);
         
   s9xServer.Args << fr_CaseInsensitive << "-server" << "-srv";
   s9xServer.SetTooltip("The name of the host running the s9xserver");
   Pack(s9xServer);
   addOption(s9xServer);

   s9xPort.Args << fr_CaseInsensitive << "-port" << "-po";
   s9xPort.SetTooltip("The port of the host to connect to in a NetPlay game.");
   Pack(s9xPort);
   addOption(s9xPort);
}

void s9x_NetPlay::SetToDefaults()
{
   int SetPort = 0;
   char *EnvServer, *EnvPort;

   UseNetPlay.SetToDefault();

   EnvServer = getenv("S9XSERVER");
   if(!EnvServer)
     EnvServer = "";
   s9xServer.SetText(EnvServer);

   EnvPort = getenv("S9XPORT");
   if(EnvPort)
     SetPort = atoi(EnvPort);
   if(!SetPort)
     SetPort = S9X_NETPLAY_PORT;
   s9xPort.SetValue(SetPort);
	
   if((!s9xServer.IsDefault()) || (!s9xPort.IsDefault()))
     UseNetPlay.SetState(true);
   fr_Event(&UseNetPlay, fr_Click);
}

void s9x_NetPlay::Set9xVersion(float version)
{
   UseNetPlay.EnableIf(version >= 1.10);
   s9xServer.EnableIf(version >= 1.10);
   s9xPort.EnableIf(version >= 1.10);
   fr_Event(&UseNetPlay, fr_Click);
}

void s9x_NetPlay::SiftArgs(fr_ArgList& L)
{
  s9x_Notepage::SiftArgs(L);
  if((!s9xServer.IsDefault()) || (!s9xPort.IsDefault()))
    UseNetPlay.SetState(true);
  fr_Event(&UseNetPlay, fr_Click);
}

void s9x_NetPlay::CompileArgs(fr_ArgList& L)
{
  if(!UseNetPlay.GetState())
    return;
  s9xServer.CompileArgs(L);
  s9xPort.CompileArgs(L);
}

void s9x_NetPlay::EventOccurred(fr_Event*e)
{
   bool s;
   if(e->Is(UseNetPlay))
   {
      s = UseNetPlay.GetState();
      s9xServer.SetEditable(s);
      s9xPort.SetEditable(s);
   }
}
