#ifndef S9X_ROM_H
#define S9X_ROM_H

#include "defines.h"
#include "frend.h"
#include "misc.h"
#include "skins.h"
#include <ctime>
#include <string>
#include <map>

class s9x_ROMdata
{
 private:
  std::string	fileid;
  strmap        data;
 public:
  s9x_ROMdata(const std::string& file_ID);
  ~s9x_ROMdata();
  bool	        extractROMdata(const std::string& dir, const std::string& file);
  std::string   getID() const { return fileid; }
  void          setID(const std::string& i) { fileid = i; }
  void          setData(const std::string& key, const std::string& val) { data[key] = val; }
  void          setData(const std::string& key, time_t val);
  std::string   getData(const std::string& key, const std::string& fallback="");
  time_t        getData(const std::string& key, time_t fallback);
  void          setROMtitle(const std::string& t) { setData("title", t); }
  std::string	getROMtitle() { return getData("title"); }
  std::string   getEncoded() { return "-"; }
  friend std::istream& operator>>(std::istream& i, s9x_ROMdata& r);
  friend std::ostream& operator<<(std::ostream& o, const s9x_ROMdata& r);
};

class s9x_ROMselector: public fr_Window, private fr_Listener
{
  typedef std::map<std::string,s9x_ROMdata*> ROMDataMap;
 private:
  int			CountFiles;
  fr_Label		RomIcon;
  ROMDataMap            romdatamap;
  fr_DataTable		ROMlist;
  fr_TextArea           ROMdetails;
  fr_Button		BtnOK, BtnCancel;
  fr_ButtonBox		BtnBox;
  s9x_File              romdatafile;
  std::string		romdir, nowplaying;
  time_t                playtime;
  void                  loadROMdata();
  void                  saveROMdata();
  void			loadDirectory(const std::string& directory);
  int			addROM(const std::string& dir, const std::string& file, bool extractdata);
  s9x_ROMdata*          getROMdata(const std::string& fileid);
  s9x_ROMdata*          getROMdata(int row);
  void                  showROMdetails(int row);
  std::string           timestr(time_t t);
  void			EventOccurred(fr_Event*e);
  bool			RefreshContent();
  void			DeleteContent();
 public:
  s9x_ROMselector(fr_Element*parent);
  virtual ~s9x_ROMselector();
  std::string		getSelectedFilename();
  std::string		getSelectedFilepath();
  void			RowSelected(int row);
  void			SetVisibility(bool v);
  void                  setROMdir(const std::string& d);
  bool                  hasROMdata(const std::string& fileid);
  void                  doPrePlay(const std::string& f);
  void                  doPostPlay();
  static std::string    getFileID(const std::string& filename);
  static std::string    getTitleFromFilename(const std::string& filename);
};

class s9x_ROM: public s9x_Notepage
{
 private:
  std::string           romdir;
  fr_Button		RomBtn;
  fr_File		File;
  fr_PulldownMenu	MemoryMap, Format;
  fr_Element*		Bnr;
  s9x_ROMselector	Selector;
  void			EventOccurred(fr_Event*e);
 public:
  s9x_ROM(fr_Notebook*parent);
  void			Set9xVersion(float version);
  void			SiftArgs(fr_ArgList& L);
  void			SetFileName(const std::string& file);
  std::string		GetFileName();
  void                  setROMdir(const std::string& d) { romdir=d; Selector.setROMdir(d); }
  std::string           getROMdir() { return romdir; }
  void			FilePopup();
  void			ApplySkin(s9x_Skin*S);
  void                  doPrePlay() { Selector.doPrePlay(GetFileName()); }
  void                  doPostPlay() { Selector.doPostPlay(); }
};

#endif
