// -*- C++ -*-
//
// LB_LeastLoaded.inl,v 1.2 2002/07/17 05:24:27 ossama Exp


ACE_INLINE CORBA::Float
TAO_LB_LeastLoaded::effective_load (CORBA::Float previous_load,
                                    CORBA::Float new_load)
{
  // Apply per-balance load.  (Recompute raw load)
  previous_load += this->per_balance_load_;

  // Apply dampening.  (Recompute new raw load)
  CORBA::Float result =
    this->dampening_ * previous_load + (1 - this->dampening_) * new_load;

  ACE_ASSERT (this->tolerance_ != 0);

  // Compute the effective load.
  result /= this->tolerance_;

  return result;
}
