;;;***************************************************************
;;;An ACL2 Library of Floating Point Arithmetic

;;;David M. Russinoff
;;;Advanced Micro Devices, Inc.
;;;June, 2001
;;;***************************************************************

(in-package "ACL2")

;should this include arithmetic/top ?
;the comments represent Eric's best guess as to how to summarize each book

(include-book "util") ;includes the local-defthm macro, etc.
(include-book "ground-zero") ;disables a bunch of functions, includes util
(include-book "rewrite-theory") ; a little utility, which we don't use much...

(include-book "rtl") ;definitions of the RTL primitives
(include-book "rtlarr") ;RTL arrays
(include-book "bvecp-lemmas") ;bvecp lemmas for all(?) of the RTL primitives  (what's the point of this book,
  ;given that we have lib/bvecp-raw-helpers?)

(include-book "bits")
(include-book "bitn")

(include-book "ocat")    ;soon to be removed, since I don't think we use ocat
(include-book "cat-def") ;the definition of cat (since it's a bit complicated).
(include-book "cat")
(include-book "bvecp")
(include-book "ash")
(include-book "decode")
(include-book "encode")
(include-book "mulcat")
(include-book "shft")
(include-book "all-ones")
(include-book "merge2")  ;includes merge
                         ;a mix of lemmas.  eric is sorting these out into appropriate books
                         ;but some lemmas really do mix several functions
(include-book "logior1")
(include-book "setbits")
(include-book "setbitn")

(include-book "float") ;theorems about floating point numbers (factorization into sgn, sig, and expo;
;exactness)
;Eric might want to sort these out into books call sig.lisp, exactp,list, etc.

;floating-point representations:
(include-book "bias") ;Exponent bias for floating point representations.
(include-book "ereps") ;Floating point representations with explicit leading 1 in the mantissa.
(include-book "ireps") ;Floating point representations with implicit leading 1 in the mantissa.

;built-in logical operators:
(include-book "logeqv")
(include-book "logorc1")
(include-book "lognot")
(include-book "logand")
(include-book "logior")
(include-book "logxor")

(include-book "log") ;theorems mixing logical operators with bits and bitn, etc.  some junk in here to sort
  ;out?
  ;figure out the difference between this and merge?

;new logical operators:
(include-book "lnot")
(include-book "land")
(include-book "lior")
(include-book "lxor")
(include-book "lextra")

(include-book "logs") ;other "logical" operators, especially type (bvecp/natp) lemmas

;floating-point rounding:
(include-book "trunc") ;the trunc rounding-mode
(include-book "away") ;the away rounding-mode
(include-book "near") ;the near rounding-mode
(include-book "near+") ;the near+ rounding-mode
(include-book "oddr") ;the odd rounding-mode
(include-book "sticky") ;sticky rounding
(include-book "rnd") ;rnd (our top level rounding function), and the inf and minf rounding modes
(include-book "drnd") ;rounding of denormal numbers

(include-book "bits-trunc") ;theorems about how we implement trunc rounding...

;theorems about circuits for addition
(include-book "add3") ;theorems about how we implement addition of (2 or) 3 bit vectors using land, lior, and lxor
(include-book "lop1") ;leading-one prediction
(include-book "lop2") ;leading-one prediction
(include-book "lop3") ;leading-one prediction
(include-book "stick") ;Some special-purpose lemmas by Russinoff, probably about sticky bit computation

;helpers
(include-book "bvecp-helpers")
(include-book "model-helpers") ; do we use this?
(include-book "rom-helpers")
(include-book "simple-loop-helpers")
;BOZO consider moving lib/simplify-model-helpers to support/ of (better yet), move all the helpers books to lib/
