// ---------------------------------------------------------------------------
// - cclk.cxx                                                                -
// - standard system library - c time function implementation                -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cclk.hpp"
#include "cclk.hxx"

namespace aleph {

  // pause for a certain time

  void c_sleep (const long time) {
    struct timespec tval;
    if (time <= 0) return;
    long sval = time / 1000;
    long nval = (time % 1000) * 1000000;
    tval.tv_sec  = sval;
    tval.tv_nsec = nval;
    nanosleep (&tval, NULL);
  }

  // return the machine time stamp

  t_octa c_stamp (void) {
    struct timeval tval;
    if (gettimeofday (&tval, NULL) == -1) return 0;
    t_octa result = (((t_octa) tval.tv_sec) << 32) | (t_octa) tval.tv_usec;
    return result;
  }

  // return the utc time in seconds since the epoch

  long c_time (void) {
    struct timeval tval;
    if (gettimeofday (&tval, NULL) == -1) return 0;
    return tval.tv_sec;
  }

  // return the local time info

  s_tinfo* c_getlocal (const long tclk) {
    // extract time info
    struct tm* tval;
    if ((tval = localtime (&tclk)) == NULL) return 0;
    // fill in the data structure
    s_tinfo* tinfo = new s_tinfo;
    tinfo->d_secs = tval->tm_sec;
    tinfo->d_mins = tval->tm_min;
    tinfo->d_hour = tval->tm_hour;
    tinfo->d_mday = tval->tm_mday;
    tinfo->d_ymon = tval->tm_mon  + 1;
    tinfo->d_year = tval->tm_year + 1900;
    tinfo->d_wday = tval->tm_wday;
    tinfo->d_yday = tval->tm_yday;
    return tinfo;
  }

  // return the utc time info

  s_tinfo* c_getutc (const long tclk) {
    // extract time info
    struct tm* tval;
    if ((tval = gmtime (&tclk)) == NULL) return 0;
    // fill in the data structure
    s_tinfo* tinfo = new s_tinfo;
    tinfo->d_secs = tval->tm_sec;
    tinfo->d_mins = tval->tm_min;
    tinfo->d_hour = tval->tm_hour;
    tinfo->d_mday = tval->tm_mday;
    tinfo->d_ymon = tval->tm_mon  + 1;
    tinfo->d_year = tval->tm_year + 1900;
    tinfo->d_wday = tval->tm_wday;
    tinfo->d_yday = tval->tm_yday;
    return tinfo;
  }

  // make time from a time info structure

  long c_mktime (s_tinfo* tinfo) {
    if (tinfo == nilp) return 0;
    struct tm tval;
    tval.tm_sec   = tinfo->d_secs;
    tval.tm_min   = tinfo->d_mins;
    tval.tm_hour  = tinfo->d_hour;
    tval.tm_mday  = tinfo->d_mday;
    tval.tm_mon   = tinfo->d_ymon - 1;
    tval.tm_year  = tinfo->d_year - 1900;
    tval.tm_wday  = 0;
    tval.tm_yday  = 0;
    tval.tm_isdst = 0;
    long result = mktime (&tval);
    if ((time_t) result == -1) return 0;
    return result;
  }
}
