
'\"
'\" The contents of this file are subject to the AOLserver Public License
'\" Version 1.1 (the "License"); you may not use this file except in
'\" compliance with the License. You may obtain a copy of the License at
'\" http://aolserver.com/.
'\"
'\" Software distributed under the License is distributed on an "AS IS"
'\" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
'\" the License for the specific language governing rights and limitations
'\" under the License.
'\"
'\" The Original Code is AOLserver Code and related documentation
'\" distributed by AOL.
'\" 
'\" The Initial Developer of the Original Code is America Online,
'\" Inc. Portions created by AOL are Copyright (C) 1999 America Online,
'\" Inc. All Rights Reserved.
'\"
'\" Alternatively, the contents of this file may be used under the terms
'\" of the GNU General Public License (the "GPL"), in which case the
'\" provisions of GPL are applicable instead of those above.  If you wish
'\" to allow use of your version of this file only under the terms of the
'\" GPL and not to allow others to use your version of this file under the
'\" License, indicate your decision by deleting the provisions above and
'\" replace them with the notice and other provisions required by the GPL.
'\" If you do not delete the provisions above, a recipient may use your
'\" version of this file under either the License or the GPL.
'\" 
'\"
'\" $Header: /cvsroot/aolserver/aolserver/doc/ns_tmp.n,v 1.1.2.2 2002/11/12 23:35:11 scottg Exp $
'\"
'\" 
.so man.macros

.TH ns_tmp n 3.5 AOLserver "AOLserver Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ns_mktemp, ns_tmpnam \- commands
.SH SYNOPSIS
\fBns_mktemp \fItemplate\fR
.sp
\fBns_tmpnam 
.BE

.SH DESCRIPTION
.PP

\fBns_mktemp\fR returns a unique filename based on the \fItemplate\fR you
specify.  \fBns_tmpnam\fR returns a filename that can safely be used 
for a temporary file.

.PP
The \fItemplate\fR for \fBns_mktemp\fR should contain a string with six
trailing Xs, which will be replaced with an alpha-numeric
string of six characters chosen to make the filename unique.  If
\fItemplate\fR does not end with six trailing Xs the empty string
will be returned.

.PP
\fBns_tmpnam\fR calls the tmpnam() C library function, and the results will
depend on your operating system.  On Irix, for example, tmpnam() always
generate a file name using the path-prefix defined as P_tmpdir in the
header file which is "/var/tmp/".

.SH EXAMPLES
.PP

 nscp> ns_tmpnam ;# On Linux
 /tmp/filevuLwaE

 nscp> ns_mktemp /tmp/foobar.XXXXXX
 /tmp/foobar.p6SlaC

.SH "SEE ALSO"
nsd(1), mktemp(3), tmpnam(3)

.SH KEYWORDS

