/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __PROGRAMPAGE_H__
#define __PROGRAMPAGE_H__

#include <qwidget.h>
#include <qstringlist.h>
#include <qvaluelist.h>

#include "configdlg.h"
#include "konfig.h"

/*========================================================*/

class QVBoxLayout;

class ArsonProgramPage : public QWidget, public ArsonConfigPage
{
	Q_OBJECT
	
public:
	ArsonProgramPage (ArsonConfig &cfg, ArsonConfigDlg *pdlg, QWidget *parent);

private:
	QComboBox *addSelectionRow (const QString &label,
		const char *choices, const char *init);

	QVBoxLayout *m_pVB;
	QComboBox *m_cbs[_PROGGRP_MAX];
	
private slots:
	void on_accept (void);
};

/*========================================================*/
#endif	/*	__PROGRAMPAGE_H__	*/
