/*
 * Copyright (c) 2002 Markus Triska  triska@gmx.at
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __TEMPFILE_H__
#define __TEMPFILE_H__

#include <qstringlist.h>
#include <qmap.h>

#include <ktempfile.h>

/*==================================*/
/*	DEFINES
 *==================================*/

#define ARSON_DEFAULT_FIFO_MODE		(0660)

/*========================================================*/

class ArsonTempFile : public KTempFile
{
	typedef QMap<QString,QString> TEMPMAP;
	
public:
	ArsonTempFile (const QString &pref = QString::null,
		const QString &ext = QString::null,
		int mode = 0600);

	static QString tempFileName(
		const char *prefix, const char *ext);

	static QString temporaryFor (const QString &name, const QString &suffix = "wav");
	static void deleteTemporaryFor (const QString &name);
	static void deleteTempFiles (void);

private:
	static TEMPMAP m_temporaryFiles;
};

/*========================================================*/

class ArsonFileCleanup
{
public:
	ArsonFileCleanup &operator<< (const QStringList &sl);
	ArsonFileCleanup &operator<< (const QString &fn);
	~ArsonFileCleanup (void);
	void reset (void);

private:
	QStringList m_files;
};

/*========================================================*/

class ArsonFifo
{
public:
	ArsonFifo (const QString &fn, int mode = ARSON_DEFAULT_FIFO_MODE);
	ArsonFifo (const QString &prefix, const QString &ext, int mode = ARSON_DEFAULT_FIFO_MODE);
	~ArsonFifo (void);

	const QString &filename (void) const { return m_filename; }
	bool valid (void) const { return (m_filename != QString::null); }
	void setAutoDelete (bool del) { m_bAutoDel = del; }
	bool autoDelete (void) const { return m_bAutoDel; }
	void release (void) { m_filename = QString::null; }

	void unlink (void);
	
private:
	bool create (int mode);
	
	QString m_filename;
	bool m_bAutoDel;
};

/*========================================================*/
#endif	/*	__TEMPFILE_H__	*/
