/*
	arch.inc

	AVA Micro-controller (MCU) Declarations

	This file is automatically included to every assembler source
        immediately after architecture definition line: 
	
	  #arch MCU_NAME

	Uros Platise (c) 1998-1999
	Last update: Sat Jun 12 03:34:55 CEST 1999

  AVR FAMILY MICRO-CONTROLLERS
  Supported models:
    - ATtiny10
    - ATtiny11
    - ATtiny12      
    - ATtiny22
    - AT90S1200
    - AT90S2313
    - AT90S2323
    - AT90S2333
    - AT90S2343
    - AT90S4414
    - AT90S4433
    - AT90S4434
    - AT90S8515
    - AT90C8534    
    - AT90S8535
    - ATmega603
    - ATmega103

    
  The following macros are set for the AVR family:
  
    * __AVR 1|2|3	; instruction power
    
    * __ERAM_SIZE	; size of the internal SRAM data memory
    			; The __ERAM_SIZE should be daclared before
			; calling the #arch <model> if system provides more
			; memory
			
    * __ERAM_END	; address of the last byte in the data memory
    
    * __AVR_IOMAP    	; if AVR features standard I/O mapped registers
    * __AVR_WRAP_AROUND	; special feature of the 8 kb flash device

*/

/*
  Current Version
  Produce error if arch versions do not match between object files.
*/
#define public __AVA_ARCH_VER	5

#if ATtiny10 | ATtiny11
device AVR 1
#define __AVR 1
#define __ERAM_SIZE 0			/* no memory no option */
seg abstract abs=0 size=__ERAM_SIZE eram
seg abs=0 size=1024 align=2 flash
#endif

#if AT90S1200 | ATtiny12
device AVR 1
#define __AVR 1
#define __ERAM_SIZE 0			/* no memory no option */
seg abstract abs=0 size=__ERAM_SIZE eram
seg abs=0 size=64 eeprom
seg abs=0 size=1024 align=2 flash	/* the default segment! */
#endif

#if AT90S2313 | AT90S2323 | AT90S2333 | AT90S2343 | ATtiny22
device AVR 2
#define __AVR 2
#ifndef __ERAM_SIZE
#define __ERAM_SIZE 224		/* 128 of sram + 96 of i/o mapped */
#endif
#define __AVR_IOMAP
seg abstract abs=0 size=__ERAM_SIZE eram
seg abs=0 size=128 eeprom
seg abs=0 size=2048 align=2 flash
#endif

#if AT90S4414 | AT90S4434
device AVR 2
#define __AVR 2
#ifndef __ERAM_SIZE
# define __ERAM_SIZE 0x160	/* defaults to internal memory size */
#endif
#define __AVR_IOMAP
seg abstract abs=0  size=__ERAM_SIZE eram
seg abs=0 size=256 eeprom
seg abs=0 size=4096 align=2 flash
#endif

#if AT90S4433
device AVR 2
#define __AVR 2
#ifndef __ERAM_SIZE
# define __ERAM_SIZE 224
#endif
#define __AVR_IOMAP
seg abstract abs=0  size=__ERAM_SIZE eram
seg abs=0 size=256 eeprom
seg abs=0 size=4096 align=2 flash
#endif

#if AT90C8534
device AVR 2
#define __AVR 2
#define public  __AVR_WRAP_AROUND
#ifndef __ERAM_SIZE
# define __ERAM_SIZE 0x160
#endif
#define __AVR_IOMAP
seg abstract abs=0 size=__ERAM_SIZE eram
seg abs=0 size=512 eeprom
seg abs=0 size=8192 align=2 flash
#endif

#if AT90S8515 | AT90S8535
device AVR 2
#define __AVR 2
#define public  __AVR_WRAP_AROUND
#ifndef __ERAM_SIZE
# define __ERAM_SIZE 0x260
#endif
#define __AVR_IOMAP
seg abstract abs=0 size=__ERAM_SIZE eram
seg abs=0 size=512 eeprom
seg abs=0 size=8192 align=2 flash
#endif

/* AVR MEGA FAMILY 64kb and 128kb FLASH */

#if ATmega603
device AVR 3
#define __AVR 3
#ifndef __ERAM_SIZE
# define __ERAM_SIZE 0x1000
#endif
#define __AVR_IOMAP
seg abstract abs=0  size=__ERAM_SIZE eram
seg abs=0 size=2048 eeprom
seg abs=0 size=0x10000 align=2 flash
#endif

#if ATmega103
device AVR 3
#define __AVR 3
#ifndef __ERAM_SIZE
# define __ERAM_SIZE 0x1000
#endif
#define __AVR_IOMAP
seg abstract abs=0 size=__ERAM_SIZE eram
seg abs=0 size=4096 eeprom
seg abs=0 size=0x20000 align=2 flash
#endif

/* 
	AVR Standard Memory Mapped Registers
*/
#ifdef __AVR_IOMAP
seg abs=0  size=32 eram.registers
seg abs=32 size=64 eram.io_space
seg flash		/* set default segment */
#endif

#ifdef __ERAM_SIZE
# ifndef __ERAM_END	/* if end of ram is not explicitly defined */
#  define __ERAM_END	(__ERAM_SIZE - 1)
# endif
#endif

/*
	AVR - AVA Default Settings
*/
#ifdef __AVR

#ifndef __avr_noendianbug
# define public __avr_noendianbug 0	/* 0 = With Endian Bug */
#endif					/* 1 = No Endian Bug */

#endif	

/*
	Update Default Settings
*/
#configure

/* end of arch.inc */
