# Copyright 2003 Jay Beale
# This file contains all of the Mac OS X-specific subroutines

####################################################################
#
#  This module makes up the MAC OS X-specific API routines.
#  
####################################################################
#
#  Subroutine Listing:
#     &OSX_ConfigureForDistro: 	adds all used file names to global
#                             	hashes 
#

sub OSX_ConfigureForDistro {

    # We don't assume that you're editting the config file on the same platform as the
    # target system.  Using the --os flag, you might run the front-end on Linux to modify 
    # an OS X system.  We set the Bastille-internal files to whichever system you're 
    # actually on, while we set the target O/S files to the target's O/S.

    if (&getActualDistro =~ /^OSX/) {
	
	$GLOBAL_BDIR{"home"}= "/var/root/Bastille";
	
	$GLOBAL_BDIR{"log"} = "/var/log/Bastille";
	$GLOBAL_BFILE{"action-log"} = &getGlobal('BDIR', "log") . "/action-log";
        # This one is referenced explicitly in ErrorLog to avoid infinite
        # recursion (out of memory error), but also defined here so the
        # file location can be referenced
	$GLOBAL_BFILE{"error-log"} = &getGlobal('BDIR', "log") . "/error-log";
	$GLOBAL_BFILE{"debug-log"} = &getGlobal('BDIR', "log") . "/debug-log";

	$GLOBAL_BDIR{"share"}= "/usr/share/Bastille";
	$GLOBAL_BDIR{"revert"}= &getGlobal('BDIR', "log") . "revert";
	$GLOBAL_BFILE{"TOREVERT"}= $GLOBAL_BDIR{"revert"} . "/TOREVERT.txt";
	$GLOBAL_BDIR{"oldconfig"}= &getGlobal('BDIR', "log") . "oldconfig";
	$GLOBAL_BFILE{"created-files"}= &getGlobal('BDIR', "revert") . "/revert-created-files";
	$GLOBAL_BFILE{"created-dirs"}= &getGlobal('BDIR', "revert") . "/revert-created-dirs";
	$GLOBAL_BFILE{"created-symlinks"} = &getGlobal('BDIR', "revert") . "/revert-created-symlinks";
	$GLOBAL_BFILE{"removed-symlinks"} = &getGlobal('BDIR', "revert") . "/revert-removed-symlinks";
	$GLOBAL_BFILE{"executed-commands"}= &getGlobal('BDIR', "revert") . "/revert-executed-commands";
	$GLOBAL_BFILE{"sum.csv"}= &getGlobal('BDIR', "revert") . "/sum.csv";
	# Required files for new revert process...
	$GLOBAL_BFILE{"revert-actions"}= &getGlobal('BDIR', "revert") . "/revert-actions";
        $GLOBAL_BFILE{"revert-directory-perms.sh"}=&getGlobal('BDIR', "revert") . "/revert-directory-perms.sh";
        $GLOBAL_BFILE{"BastilleBackEnd"} = "/var/root/Bastille/BastilleBackEnd";

	$GLOBAL_BFILE{"complete.xbm"}="/usr/share/Bastille/complete.xbm";
	$GLOBAL_BFILE{"incomplete.xbm"}="/usr/share/Bastille/incomplete.xbm";

	$GLOBAL_BFILE{"credits"}="/usr/share/Bastille/Credits";
	$GLOBAL_BDIR{"backup"}= &getGlobal('BDIR', "revert") . "/backup";
    
	$GLOBAL_BDIR{"config"} = "/etc/Bastille";
	$GLOBAL_BFILE{"config"} = &getGlobal('BDIR', "config") . "/config";

	$GLOBAL_BFILE{"TODO"}= $GLOBAL_BDIR{"log"} . "/TODO";
	$GLOBAL_BFILE{'lockfile'} = $GLOBAL_BDIR{"log"} . "/bastille-lock";

	$GLOBAL_BFILE{'last.config'} = "/var/log/Bastille/last.config";
	$GLOBAL_BFILE{"nodisclaimer"}= &getGlobal('BDIR', "share") . "/.nodisclaimer";

	$GLOBAL_FILE{"Questions"} = &getGlobal('BDIR', "share") . "/Questions.txt";

    }

    if (&GetDistro =~ /^OSX/) {
	
        #
	# Set necessary config/misc files and directories
	#

	$GLOBAL_DIR{"home"}="/Users";
        $GLOBAL_DIR{"log"}="/var/log";
        $GLOBAL_DIR{"pamd"}="/etc/pam.d";

	$GLOBAL_FILE{"Questions"} = &getGlobal('BDIR', "share") . "/Questions.txt";
	$GLOBAL_FILE{"cron.allow"} = "/var/cron/allow";
	$GLOBAL_FILE{"profile"}="/etc/profile";
	$GLOBAL_FILE{"csh.login"}="/etc/csh.login";
	$GLOBAL_FILE{"inetd.conf"}="/etc/inetd.conf";
	$GLOBAL_FILE{"xinetd.conf"}="/etc/xinetd.conf";
	$GLOBAL_DIR{"xinetd.d"}="/etc/xinetd.d";
	$GLOBAL_FILE{"ttys"}='/etc/ttys';
	$GLOBAL_FILE{'motd'}='/etc/motd';
	$GLOBAL_FILE{'hostconfig'}='/etc/hostconfig';
	$GLOBAL_FILE{"hosts.allow"}="/etc/hosts.allow";
	$GLOBAL_FILE{"named"}="/usr/sbin/named";
	$GLOBAL_FILE{"httpd"}="/usr/sbin/httpd";
	$GLOBAL_FILE{"lpr"}="/usr/bin/lpr";
	$GLOBAL_FILE{"httpd.conf"}="/etc/httpd/httpd.conf";
	$GLOBAL_FILE{"tcpd"}="/usr/libexec/tcpd";
	$GLOBAL_FILE{"gcc"}="/usr/bin/gcc";
        $GLOBAL_FILE{"group"}="/etc/group";

	# Root doesn't get a profile by default -- maybe we should be creating one?
#	$GLOBAL_FILE{"rootprofile"}="/root/.bash_profile";

	# zsh uses /etc/profile -- I changed AccountSecurity::SetUmask to not modify 
	# this file, instead of defining this variable and leaving it to modify the
	# /etc/profile file twice.
#	$GLOBAL_FILE{"zprofile"}="/etc/profile";

	$GLOBAL_FILE{'NFS'}='/System/Library/StartupItems/NFS/NFS';
	$GLOBAL_FILE{'chkconfig_nfs_server'}='/System/Library/StartupItems/NFS/NFS';
	$GLOBAL_FILE{'chkconfig_nfs_client'}='/System/Library/StartupItems/NFS/NFS';

	#
	# Set necessary binaries
	#
	$GLOBAL_BIN{"echo"}="/bin/echo";
	$GLOBAL_BIN{"more"}="/usr/bin/more";
        $GLOBAL_BIN{"touch"}="/usr/bin/touch";
	$GLOBAL_BIN{"ping"}="/sbin/ping";
	$GLOBAL_BIN{"ping6"}="/sbin/ping6";
	$GLOBAL_BIN{"traceroute"}="/usr/sbin/traceroute";
	$GLOBAL_BIN{"traceroute6"}="/usr/sbin/traceroute6";
	$GLOBAL_BIN{"dump"}="/sbin/dump";
	$GLOBAL_BIN{"restore"}="/sbin/restore";
	$GLOBAL_BIN{"rdump"}="/sbin/rdump";
	$GLOBAL_BIN{"rrestore"}="/sbin/rrestore";
	$GLOBAL_BIN{"at"}="/usr/bin/at";
	$GLOBAL_BIN{"atq"}="/usr/bin/atq";
	$GLOBAL_BIN{"atrm"}="/usr/bin/atrm";
	$GLOBAL_BIN{"rcp"}="/bin/rcp";
	$GLOBAL_BIN{"rlogin"}="/usr/bin/rlogin";
	$GLOBAL_BIN{"rlogind"}="/usr/libexec/rlogind";
	$GLOBAL_BIN{"rshd"}="/usr/libexec/rshd";
	$GLOBAL_BIN{"rexecd"}="/usr/libexec/rexecd";
        $GLOBAL_BIN{"cp"}="/bin/cp";
        $GLOBAL_BIN{"mv"}="/bin/mv";
	$GLOBAL_BIN{"umount"}="/sbin/umount";
        $GLOBAL_BIN{"mount"}="/sbin/mount";
        $GLOBAL_BIN{"lpq"}="/usr/bin/lpq";
        $GLOBAL_BIN{"lprm"}="/usr/bin/lprm";
        $GLOBAL_BIN{"lpr"}="/usr/bin/lpr";
        $GLOBAL_BIN{"killall"}="/usr/bin/killall";
	$GLOBAL_BIN{"rm"}="/bin/rm";
        $GLOBAL_BIN{"cksum"}="/usr/bin/cksum";
	$GLOBAL_BIN{"chgrp"}="/usr/bin/chgrp";
	$GLOBAL_BIN{"chmod"}="/bin/chmod";
        $GLOBAL_BIN{"chown"}="/usr/bin/chown";
	$GLOBAL_BIN{"rmdir"}="/bin/rmdir";
	$GLOBAL_BIN{"ln"}="/bin/ln";
	$GLOBAL_BIN{"dpkg"}="/sw/bin/dpkg";
	$GLOBAL_BIN{"apt-get"}="/sw/sbin/apt-get";
        $GLOBAL_BIN{"mknod"}="/sbin/mknod";
	$GLOBAL_BIN{"accton"} = "/usr/sbin/accton";
	$GLOBAL_FILE{"accton"} = "/usr/sbin/accton";
	$GLOBAL_BIN{"bash"} = "/bin/bash";
	$GLOBAL_BIN{"crontab"}="/usr/bin/crontab";
        $GLOBAL_BIN{"diff"}="/usr/bin/diff";
	# BUG: Is this a bug?
	$GLOBAL_BIN{"rsh"}="/usr/bin/rsh";
	$GLOBAL_BIN{"rdist"}="";
	$GLOBAL_BIN{"rexec"}="";
	$GLOBAL_FILE{"rsh"}="/usr/bin/rsh";

        #####################################################################
        # SERVICES
        #####################################################################

        #$GLOBAL_SERVICE{'apache'}=['APACHE2_START'];          # Default: 1
        #$GLOBAL_SERVTYPE{'apache'}="rc";
        #$GLOBAL_PROCESS{'apache'}=['/opt/hpapache2/bin/httpd'];
	
        #$GLOBAL_SERVICE{'hpws_apache'}=['HPWS_APACHE_START'];  # Default: 0
        #$GLOBAL_SERVTYPE{'hpws_apache'}="rc";
        #$GLOBAL_PROCESS{'hpws_apache'}=['/opt/hpws/apache/bin/httpd'];
	
	

	return;

 
	$GLOBAL_BIN{"md5sum"}="/usr/bin/md5sum";

	$GLOBAL_FILE{"sendmail.cf"}="/etc/sendmail.cf"; 
	$GLOBAL_FILE{"banners_makefile"}="/usr/share/doc/tcp_wrappers-7.6/Banners.Makefile";
	

	}
}	

1;
