/***************************************************************************
                          dlgmain.h  -  description
                             -------------------
    begin                : Sat Dec 28 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kenschenke at yahoo dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, as a special exception, Ken Schenke gives permission to  *
 *   link the code of this program with the Qt non-commercial edition (or  *
 *   with modified versions of the Qt non-commercial edition that use the  *
 *   same license as the Qt non-commercial edition, and distribute linked  *
 *   combinations including the two.  You must obey the GNU General Public *
 *   License in all respects for all of the code used other than the Qt    *
 *   Non-Commercial edition.  If you modify this file, you may extend this *
 *   exception to your version of the file, but you are not obligated to   *
 *   do so.  If you do not wish to do so, delete this exception statement  *
 *   from your version.                                                    *
 *                                                                         *
 ***************************************************************************/

#ifndef DLGMAIN_H
#define DLGMAIN_H

#include "dlgmainbase.h"
#include "bridgecfg.h"

/***************************************************************************
 *                                                                         *
 *   Forward declarations.                                                 *
 *                                                                         *
 ***************************************************************************/

class DlgHelp;

/***************************************************************************
 *                                                                         *
 *   The DlgMain class represents the main dialog box that serves as       *
 *   BookmarkBridge's primary interface.                                   *
 *                                                                         *
 ***************************************************************************/

class DlgMain : public DlgMainBase
{
	Q_OBJECT
public:
	DlgMain( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags f = 0 );
	virtual ~DlgMain();

	virtual void buttonAboutClicked(void);
	virtual void buttonAddDestinationClicked(void);
	virtual void buttonAddSourceClicked(void);
	virtual void buttonDeleteDestinationClicked(void);
	virtual void buttonDeleteSourceClicked(void);
	virtual void buttonHelpClicked(void);
	virtual void buttonMergeClicked(void);
	virtual void buttonSettingsClicked(void);
	virtual void buttonViewBookmarksClicked(void);
	virtual void listDestinationsSelectionChanged(void);
	virtual void listSourcesSelectionChanged(void);
	
private:
	BridgeCfg	m_cfg;
	DlgHelp *	m_dlgHelp;

	void		refreshButtons(void);
	void		refreshLists(void);
};

#endif	// end of DLGMAIN_H
