
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "brightonX11internals.h"

int
BFreeColor(brightonDisplay *display, brightonPalette *color)
{
	bdisplay *bd = (bdisplay *) display->display;

	XFreeColors(bd->display, bd->cm, &(color->pixel), 1, 0);
	XFreeGC(bd->display, color->gc);

	color->flags &= ~B_ALLOCATED;

	if (color->color) {
		brightonX11free(color->color);
		color->color = 0;
	}

	color->color = 0;
	color->gc = 0;

	return(0);
}


int
BAllocColorByName(brightonDisplay *display, brightonPalette *color, char *name)
{
	bdisplay *bd = (bdisplay *) display->display;
	unsigned long valuemask = GCForeground;
	XGCValues values;
	XColor *screen, exact;
	GC gc;

	screen = (XColor *) brightonX11malloc(sizeof(XColor));

	XAllocNamedColor(bd->display, bd->cm, name, screen, &exact);

	color->red = exact.red;
	color->green = exact.green;
	color->blue = exact.blue;

	color->color = screen;
	color->pixel = screen->pixel;

	color->flags |= B_ALLOCATED;

	return(0);
}

int
BAllocColor(brightonDisplay *display, brightonPalette *color,
unsigned short r, unsigned short g, unsigned short b)
{
	bdisplay *bd = (bdisplay *) display->display;
	unsigned long valuemask = GCForeground;
	XGCValues values;
	XColor *screen;
	GC gc;

//printf("alloc %i %i %i\n", r, g, b);
	if (color->color == 0)
	{
		screen = (XColor *) brightonX11malloc(sizeof(XColor));
		screen->red = r;
		screen->green = g;
		screen->blue = b;
		screen->flags = DoRed|DoGreen|DoBlue;

		XAllocColor(bd->display, bd->cm, screen);

		color->color = screen;
		color->pixel = screen->pixel;
	} else
		screen = color->color;

	values.foreground = screen->pixel;

	color->gc = XCreateGC(bd->display,
		(Window) ((brightonWindow *) display->bwin)->win, valuemask, &values);
//printf("%x %x %x, %x\n", display->bwin, ((brightonWindow *) display->bwin)->win, bd, color->gc);
//printf("color %i %i %i: #%02x%02x%02x\n",
//screen->red, screen->green, screen->blue,
//screen->red >> 8, screen->green >> 8, screen->blue >> 8);

	color->flags |= B_ALLOCATED;

	return(0);
}

brightonPalette *
BInitColorMap(brightonDisplay *display)
{
	bdisplay *bd = (bdisplay *) display->display;

	if (display->depth == 1)
	{
		printf("cannot support monochrome monitors....\n");
		return(0);
	}

	bd->cm = DefaultColormap(bd->display, bd->screen_num);

	if (!XMatchVisualInfo(bd->display, bd->screen_num, bd->depth,
		PseudoColor, &bd->dvi))
	{
		if (!XMatchVisualInfo(bd->display, bd->screen_num,
			bd->depth, DirectColor, &bd->dvi))
		{
			if (!XMatchVisualInfo(bd->display, bd->screen_num,
				bd->depth, TrueColor, &bd->dvi))
			{
				if (!XMatchVisualInfo(bd->display, bd->screen_num,
					bd->depth, DirectColor, &bd->dvi))
				{
					/*
					 * No Psuedos or Directs. We could consider greyscale....
					 * This is probably superfluous these days.
					 */
					printf("Prefer not to have greyscale graphics.\n");
					bd->flags |= BRIGHTON_GREYSCALE;
					return(display->palette);
				}
			} else {
				printf("Using TrueColor display\n");
			}
		} else {
			printf("Using DirectColor display\n");
		}
	} else {
		printf("Using PseudoColor display\n");
	}

	printf("masks are %x %x %x\n",
		bd->dvi.red_mask, bd->dvi.red_mask, bd->dvi.red_mask);

	return(display->palette);
}

