#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

// ============================================================================
//  SEARCHMAIL screen container handler
// ============================================================================
string screen(mapping args, string contents, object id)
{
  string out = "";
  CSESSION->screen = "searchmail";	// Admin screen name

  contents = CAMAS.Parse.parse_html(contents,
                        ([
                         "camas_previoussearchstring" : tag_camas_searchmail,
                         "camas_nosearchremember"     : tag_camas_searchmail,
                         "camas_searchtext"           : tag_camas_searchmail,
                         "camas_searchallmbox"        : tag_camas_searchmail,
                         "camas_actionsearch"         : tag_camas_searchmail,
			 "camas_stickyfilter"	      : tag_camas_searchmail,
			 "camas_cancelsearch"	      : tag_camas_searchmail,
                         ]),
                        ([
			  "camas_searchmboxes"         : container_camas_searchmboxes,
			  "camas_searchfield"          : container_camas_searchfield,
                         ]),
                        id);
  if(!id->misc->_xml_parser && QUERY(ent_parse))
    contents = parse_scopes(contents,cb_scopes,id);
  
  args->method = "post";
  args->name = "camassearchmailform";

  args = CAMAS.Tools.set_target(id, args);
  
  out += CAMAS.Tools.make_container("form", args, contents);

  return out;
}

string tag_camas_searchmail(string tag_name, mapping args, object id)
{
  string out="";

  switch(tag_name)
  {
  case "camas_previoussearchstring":
    //! tag: camas_previoussearchstring
    //!  Displays the searchstring of the previous search
    //! note: screen: searchmail
    if(CSESSION->searchstring && sizeof(CSESSION->searchstring) > 0)
    {
      out += CSESSION->searchstring;
    }
    break;

  case "camas_nosearchremember":
    //! tag: camas_nosearchremember
    //!  Displays a checkbox for not using history search
    //! note: screen: searchmail
    if(CSESSION->searchstring && sizeof(CSESSION->searchstring) > 0)
    {
      args -> name = "nohistsearch";
      args -> type = "checkbox";
      args -> value= "1";
      out += CAMAS.Tools.make_tag("input", args)+ "\n";
    }
    break;

  case "camas_searchtext":
    //! tag: camas_searchtext
    //!  input for typing the string to search
    //! note: screen: searchmail
    args -> name = "text1";
    args -> size = "20";
    out += CAMAS.Tools.make_tag("input", args);
    break;

  case "camas_searchallmbox":
    //! tag: camas_searchallmbox
    //!  Checkbox for checking all the mailboxes in one step
    //! note: screen: searchmail
    if(id->supports->javascript && CSESSION->cachefeeded)
    {
      args -> onClick = "for(var i=0;i<this.form.elements.length;i++)"
       + " {var inpt=this.form.elements[i];if(inpt.name.substr(0,3)=='msg')"
       + " inpt.checked=this.form.all.checked}";
      args -> type = "checkbox";
      args -> name = "all";
      out += CAMAS.Tools.make_tag("input", args);
    }
    break;

  case "camas_stickyfilter":
    //! tag: camas_stickytfilter
    //!  Checkbox for applying search criteria to all mailbox when switching to them
    //! note: screen: searchmail
    args -> name = "stickyfilter";
    args -> type = "checkbox";
    args -> value = "1";
    out += CAMAS.Tools.make_tag("input", args);
    break;

  case "camas_actionsearch":
    //! tag: camas_actionsearch
    //!  Button for doing the search
    //! note: screen: searchmail
    out += CAMAS.Tools.formdrawbutton(id,"m_searchmail", "actionsearchmail", MSG(M_SEARCHMAIL)+"...", args);
    break;

  case "camas_cancelsearch":
    //! tag: camas_cancelsearch
    //!  Button for canceling search, user goes back to mailindex
    //!  note: uses the same message and button as camas_cancelsend
    //! note: screen: search 
    out = CAMAS.Tools.formdrawbutton(id,"m_cancelsend", "actionindex",MSG(M_CANCELSEND), args);
    break;

  default:
    CDEBUG("tag_camas_searchmail: "+tag_name+" is not supported yet");
    out = "<!-- "+tag_name+" is not supported yet -->";
  }

  return out;
}

//! container: camas_searchfield
//!  Display a select list of the place where to search for the pattern
//!  in each mail
//! attribute: selected
//!  Contains the field to select by default. See variable of this container
//!  for valid fields
//! variable: text
//!  Search everywhere
//! variable: to
//!  Search in the to header
//! variable: from
//!  Search in the from header
//! variable: subject
//!  Search in the header subject
//! variable: header message-id
//!  Search in the message-id header
//! variable: body
//!  Search in the body
string container_camas_searchfield(string tag_name, mapping args, string contents, object id)
{
  string out;
  array outlet = ({
                   ([
                   ])
                 });
  mapping(string:string) fieldname2message = 
      ([ 
        "text": MSG(M_SEARCHANYWHERE),
      	"to": MSG(M_SEARCHTOFIELD),
      	"from": MSG(M_SEARCHFROMFIELD),
      	"subject": MSG(M_SEARCHSUBJECT),
      	"body": MSG(M_SEARCHBODY),
      	"header message-id": "Message-ID",
      ]);
  array(string) fields = ({ "text", "to", "from", "subject", 
        "body", "header message-id" });
  // searching in all headers is only available if searching in memory
  if(CSESSION->cachefeeded)
  {
    fieldname2message += ([ "all headers": MSG(M_SEARCHHEADERS) ]);
    fields += ({ "all headers" });
  }
  foreach(fields, string field)
  {
    mapping largs = ([ "value": field ]);
    if(args->selected == field)
      largs -> selected = "true";
    outlet[0] +=  ([ field: CAMAS.Tools.make_container("option", largs, fieldname2message[field]) ]);
  }
  m_delete(args, "selected");
  out = do_output_tag(args, outlet, contents, id);
  args->name = "searchfield1";
  out = CAMAS.Tools.make_container("select", args, out);
  return out;
}

//! container: camas_searchmbox
//!  Displays checkboxes for choosing which mailbox to search
//! attribute: nochoice
//!  If nochoice is set, no popup menu is displayed.
//!  The display name of the current mailbox is displayed and search is done in it.
//! attribute: restrictmailboxes
//!  Restricts search to current mailbox
//! attribute: showspecialfolders
//!  Shows special folders (sent-mails, Trash, Drafts...) in the list
//! attribute: showsent
//!  Shows sent-mail folder in the list
//! attribute: onlymailboxes
//!  Restricts search only to mailboxes, not folders in it
//!  List of mailbox to search for
//! note: screen: search
string container_camas_searchmboxes(string tag_name, mapping args, string contents, object id)
{
  string out = "";
  if(args->nochoice)
  {
    out += CAMAS.Parse.parse_html(contents,
                     ([ ]),
		     ([ "camas_searchmbox": container_camas_searchmbox ]), 
		     id, CSESSION->mailbox[MB_DISPLAYNAME_IDX]);
  }
  else
  {
    array folders  = CAMASFOLDERTOOLS.list_folders(id,!args->restrictmailboxes,
      args->showspecialfolders,args->onlymailboxes,args->showsent);
    string message = "";
    mapping optionargs = ([ ]);
    foreach(folders, string folder)
    {
      out += CAMAS.Parse.parse_html(contents, 
       		([ ]),
		([ "camas_searchmbox": container_camas_searchmbox ]), id, folder);
    }
  }
  return out;
}

//! container: camas_searchmbox
//!  One of the mailbox to search into
//! note: screen: searchmail
string container_camas_searchmbox(string tag_name, mapping args, string contents, object id, string folder)
{
  string out="";
  string message = "";
  mapping optionargs = ([ ]);

  if(!CSESSION->cachefeeded)
  {
    optionargs->name = "mbox";
    optionargs->type = "radio";
    optionargs->value = HTML_ENCODE_STRING(CSESSION->mailboxes[folder][MB_FOLDERNAME_IDX]);
  }
  else
  {
    optionargs->name = "msg" + HTML_ENCODE_STRING(CSESSION->mailboxes[folder][MB_FOLDERNAME_IDX]);
    optionargs->type = "checkbox";
    optionargs->value = "1";
  }
  if(CSESSION->mailboxes[folder][MB_FOLDERNAME_IDX]==CSESSION->mailbox[MB_FOLDERNAME_IDX])
    optionargs->checked = "1";
  out += CAMAS.Tools.make_tag("input", optionargs);
  array outlet = ({
                      ([
                       "name"    : HTML_ENCODE_STRING(CSESSION->mailboxes[folder][MB_DISPLAYNAME_IDX]),
                       ])
                    });

  out += do_output_tag(args, outlet, contents, id);
  return out;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
