(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

let _ = GMain.Main.init ()


class c = 
  object (self)
    inherit [string] Gpattern.plist `SINGLE ["" ; "title"] true

    method content s = 
      [ Gpattern.Pixmap
	  (GDraw.pixmap_from_xpm ~file: s
	     ~colormap: (Gdk.Color.get_system_colormap ())
	     () 
	  ) ;
	Gpattern.String s
      ], None

    method compare s1 s2 =
      match current_sort with
	2 -> Pervasives.compare s1 s2
      |	-2 -> - (Pervasives.compare s1 s2)
      |	_ -> 0

    method on_select s =
      prerr_endline ("select "^s)

    method on_deselect s =
      prerr_endline ("deselect "^s)

    method on_double_click s =
      prerr_endline ("double click on "^s)

    method menu =
      [ 
	`I ("hello", fun () -> prerr_endline "hello") ;
	`I ("selection", 
	    (fun () -> 
	      prerr_endline "selection is ";
	      List.iter prerr_endline self#selection
	    )
	   ) ;
      ]	
  end

let window = GWindow.window ~width: 400 ()
let c = new c
let _ = window#add c#box
let _ = c#set_titles ["icon" ; "file"]
let _ = c#update_data (List.tl (Array.to_list Sys.argv))
let _ = window#show ()
let _ = GMain.Main.main ()
