#ifndef WEBCAMVIEWER_HPP
#define WEBCAMVIEWER_HPP

#ifdef HAVE_CONFIG_H
#incude <config.h>
#endif

#include <qpixmap.h>
#include <qbutton.h>
#include <qdatetime.h>
#include <qtimer.h>
#include <qurloperator.h>
#include <qvaluelist.h>

#include "lib/FTPClient.h"
#include "VideoDevice.h"

#include "gui/SnapshotSettingsDlg.h"
#include "gui/TimeSnapshot.h"
#include "gui/VideoSettingsDlg.h"

#include "CamWindow.h"
#include "BasicPanel.h"
#include "ImagePanelRGB.h"
#include "ImagePanelYUV.h"

class CWebCamViewer: public CCamWindow
{
   Q_OBJECT
private:
   enum {
     pbt_controls,
     pbt_config,
     pbt_showsnap,
     pbt_snapshot,
     pbt_timesnap,
     pbt_sound,
     pbt_MAX,
   } PushButtons;
   QPixmap ButtonPix[pbt_MAX];
   QToolButton *pButton[pbt_MAX];

   CVideoDevice *pVideo;	///< The video device
   CCamPanel *pViewer;		///< The main image viewer
   CBasicPanel *pLastSnapshot;	///< Extra panel that shows the last snapshot
   QTimer *SizeTimer;		///< Helper timer for adjustSize()

   SVideoOptions *pVOptions;	///< Our options
   CSnapshotSettingsDlg *pConfiguration;	///< Configuration dialog
   CVideoSettingsDlg *pSettings;	///< Settings dialog

   CTimeSnapDlg *pTimeSnapDlg;
   int SnapInterval, SnapCounter;
   QTimer *pSnapTimer;
   QLabel *pSnapLabel;

   /// Upload data
   struct FTPCommandStruct
   {
      int Command;
      QString Param[4];
   };

   struct {
     CFTPClient *pClient;
     QList<FTPCommandStruct> Commands;
     
     QString LocalFile, RemoteFile;
     
     QTime StartTime;
     bool ErrorCondition, DelAfter;
   } Upload;

   void StartFTPUpload(const QString &, bool);
   void StopFTP();
   void TriggerNextFTPCommand();

private slots:
   void ClickedConfigurationDlg();
   void ConfigurationDlgClosed();
   
   // Settings dialog
   void ClickedSettingsDlg();
   void SettingsDlgClosed();

   void ClickedShowLastSnapshot();

   void ClickedTimeSnapDlg();
   void TimeSnapDlgClosed();
   
   void ClickedSoundOnOff();

   void FTPChangeState(int command, int new_state, int result, const QString &server_msg);
   void NextFTPCommand();

   void StartTimeSnap();
   void StopTimeSnap();
   void TimeSnapTick();
   void TakeSnapshot();

protected:
   void RecalcTotalViewSize();

protected slots:
   void DeviceChangedSize(const QSize &size);
   void DeviceError(int err_no);

   void CallAdjustSize();

public:
   CWebCamViewer(CVideoDevice *video, const QSize &hint_size, QWidget *parent = 0, const char *name = 0);
   virtual ~CWebCamViewer();   

virtual void showMaximized();
};

#endif
