#include "main.h"

typedef struct {
    char x,y;
} SmallCoord;

#define MAX_REDRAWS 1000
#define NEXT_BLOCK_TIME 500

Uint32 EndOfPhase;
int ShownTime;
char text[200],TimeText[200];

BuildPlayer BPlayer[PLAYERNUM+1];

char WallCheck(int x, int y) {
    if ((x<0)||(y<0)
	||(x>Width-1)||(y>Height-1))
	return 0;
    else return Wall[x][y];
}

char WallCheckConquer(int x, int y, int WhichPlayer) {
    if ((x<0)||(y<0)
	||(x>Width-1)||(y>Height-1))
	return 0;
    else return Wall[x][y] == WhichPlayer+1;
}

void Redraw(int x, int y, int WhichPlayer)
{
    int i,DoNotBlit;
    SDL_Surface *Pic;
    
    // Cannons
    for (i=0; i<BaPlayer[WhichPlayer].CannonNum; i++) {
	if (  (BaPlayer[WhichPlayer].Cannon[i].x==x)
	    &&(BaPlayer[WhichPlayer].Cannon[i].y==y)) {
	    DoNotBlit=0;
	    if (BaPlayer[WhichPlayer].Cannon[i].Type==0) {
		if (BaPlayer[WhichPlayer].Cannon[i].Destroyed) {
		    Pic=CannonDestroyedPic[BaPlayer[WhichPlayer].Cannon[i].Destroyed-1];
		} else {
		    if ( Phase == BATTLE_PHASE) {
			DoNotBlit=1;
		    }
		    Pic=CannonPic[0];
		}
	    } else {
		if (BaPlayer[WhichPlayer].Cannon[i].Destroyed) {
		    Pic=BigCannonDestroyedPic[BaPlayer[WhichPlayer].Cannon[i].Destroyed-1];
		} else {
		    if ( Phase == BATTLE_PHASE) {
			DoNotBlit=1;
		    }
		    Pic=BigCannonPic[0];
		}
	    }
	    if (!DoNotBlit) {
		Blit(x*BSIZE, y*BSIZE, Pic);
		BlitToBB(x*BSIZE, y*BSIZE, Pic);
	    }
	}
    }
    // Castles
    for (i=0;i<CastleNum;i++) {
	if (  (Castle[i].x==x)
	    &&(Castle[i].y==y)) {
	    if (Castle[i].Type==1)
		Pic = CastlePic;
	    else
		Pic = BigCastlePic;
	    Blit(x*BSIZE, y*BSIZE, Pic);
	    BlitToBB(x*BSIZE, y*BSIZE, Pic);
	}
    }
    // Garbage
    if (Garbage[x][y]) {
	SDL_SetAlpha(GarbagePic, SDL_SRCALPHA, 255-(3-Garbage[x][y])*255/3);
	Blit(x*BSIZE, y*BSIZE, GarbagePic);
	BlitToBB(x*BSIZE, y*BSIZE, GarbagePic);
	SDL_SetAlpha(GarbagePic, 0, 0);
    }
}

void RedrawEverything()
{
    int i, x, y, WhichPlayer;
    SDL_Surface *Pic;

    SDL_BlitSurface(BackPic, NULL, Screen, NULL);
    
    // Houses, Garbage and Walls
    for (x=0; x<Width; x++) {
	for (y=0; y<Height; y++) {

	    for (WhichPlayer=0; WhichPlayer<PlayerNum; WhichPlayer++)
		if (BPlayer[WhichPlayer].Secured[x][y])
		    Blit(x*BSIZE, y*BSIZE, BPlayer[Landscape[x][y]].Ground);
	    
	    if (House[x][y])
		Blit(x*BSIZE, y*BSIZE, HousePic);
	    
	    if (Garbage[x][y]) {
		SDL_SetAlpha(GarbagePic, SDL_SRCALPHA, 255-(3-Garbage[x][y])*255/3);
		Blit(x*BSIZE, y*BSIZE, GarbagePic);
		SDL_SetAlpha(GarbagePic, 0, 0);
	    }
	    
	    if (Wall[x][y]) {
		BlitTo( Screen, x*BSIZE, y*BSIZE, BPlayer[Landscape[x][y]].Wall );
	    }
	}	
    }

    // Castles
    for (i=0;i<CastleNum;i++) {
        if (Castle[i].Type == 1)
	    Blit(Castle[i].x*BSIZE, Castle[i].y*BSIZE, CastlePic);
	else
	    Blit(Castle[i].x*BSIZE, Castle[i].y*BSIZE, BigCastlePic);
    }

    // Cannons
    for (WhichPlayer=0; WhichPlayer<PlayerNum; WhichPlayer++) {
	for (i=0; i<BaPlayer[WhichPlayer].CannonNum ;i++) {
    	    if (BaPlayer[WhichPlayer].Cannon[i].Type == 0) {
		if (BaPlayer[WhichPlayer].Cannon[i].Destroyed)
		    Pic = CannonDestroyedPic[BaPlayer[WhichPlayer].Cannon[i].Destroyed-1];
		else
		    Pic = CannonPic[0];
	    } else {
		if (BaPlayer[WhichPlayer].Cannon[i].Destroyed)
		    Pic = BigCannonDestroyedPic[BaPlayer[WhichPlayer].Cannon[i].Destroyed-1];
		else
		    Pic = BigCannonPic[0];
	    }
    	    Blit(BaPlayer[WhichPlayer].Cannon[i].x*BSIZE, BaPlayer[WhichPlayer].Cannon[i].y*BSIZE, Pic);
	}
    }
    
    // Tanks
    for (i=0; i<TankNum; i++) {
	DrawTank(i);
    }
    SDL_BlitSurface(Screen, NULL, BackBuffer, NULL);
}

void ConquerCannon(int x, int y)
{
    int WhichPlayer,can;
    CannonType *ThisCan;
    
    for (WhichPlayer=0; WhichPlayer<PlayerNum; WhichPlayer++) {
	if (WhichPlayer != Landscape[x][y]) {
	    for (can=0;can<BaPlayer[WhichPlayer].CannonNum;can++) {
		ThisCan = &BaPlayer[WhichPlayer].Cannon[can];
		if ((ThisCan->x == x)&&(ThisCan->y == y)) {
		    BaPlayer[Landscape[x][y]].Cannon[BaPlayer[Landscape[x][y]].CannonNum++] = *ThisCan;
		    *ThisCan = BaPlayer[WhichPlayer].Cannon[BaPlayer[WhichPlayer].CannonNum--];
		}
	    }
	}
    }
}

void LookForSecuredAreas( int WhichPlayer )
{
    int x,y,current=0,dir,ydir=0,xdir=0,RedrawNum=0,i;
    SmallCoord way[(WIDTH+2)*(HEIGHT+2)],Redraws[MAX_REDRAWS];    
    char Visited[WIDTH+2][HEIGHT+2];
    SDL_Rect Rect;
    

    // no fields visited, yet
    for (x=0;x<Width+2;x++)
	for (y=0;y<Height+2;y++)
	    Visited[x][y]=0;
	
    x=-1;y=-1;
    way[0].x=x;
    way[0].y=y;
    Visited[0][0]=1;
    dir=0;
    
    // go!
    while (dir!=8) {
	//printf("x:%d  y:%d  dir:%d\n",x,y,dir);
	switch (dir) {
	    case 0:
    		xdir=0;
		ydir=-1;
	    break;
	    case 1:
    		xdir=1;
		ydir=-1;
	    break;
	    case 2:
    		xdir=1;
		ydir=0;
	    break;
	    case 3:
    		xdir=1;
		ydir=1;
	    break;
	    case 4:
    		xdir=0;
		ydir=1;
	    break;
	    case 5:
    		xdir=-1;
		ydir=1;
	    break;
	    case 6:
    		xdir=-1;
		ydir=0;
	    break;
	    case 7:
    		xdir=-1;
		ydir=-1;
	    break;
	}
	x+=xdir;
	y+=ydir;
	if (
	    (x<-1)||(y<-1)
	    ||(x>Width)||(y>Height)
	    ||(WallCheckConquer(x,y,WhichPlayer))
	    ||(Visited[x+1][y+1])
	) {
	    x-=xdir;
	    y-=ydir;
	    dir++;
	} else {
	    Visited[x+1][y+1]=1;
	    current++;
	    way[current].x=x;
	    way[current].y=y;
	    dir=0;
/*	    if ((x>=0)&&(y>=0)&&(x<80)&&(y<60)) {
			Rect.x=x*BSIZE;
    			Rect.y=y*BSIZE;
			Rect.w=BSIZE;
			Rect.h=BSIZE;
			SDL_FillRect(Screen, &Rect, SDL_MapRGB(Screen->format,200,200,0));
			AddThisRect(Rect);
			//Rect.x=way[current-1].x*BSIZE;
    			//Rect.y=way[current-1].y*BSIZE;
		        //SDL_BlitSurface(BackBuffer, &Rect, Screen, &Rect);
    			//AddThisRect(Rect);
			Update();
	    }*/
	}
	if ((dir>7)&&(current>0)) {
	    dir=0;
	    current--;
	    x=way[current].x;
	    y=way[current].y;
	}	    
    }

    for (x=0;x<Width;x++)
	for (y=0;y<Height;y++) 
//	    if (Landscape[x][y] == WhichPlayer+1)
	    {
	    // add new fields
	    if ((!Visited[x+1][y+1])
		&&( Wall[x][y] != WhichPlayer+1)
		&&(!BPlayer[WhichPlayer].Secured[x][y])
		) {
		    Wall[x][y]=0;
		    House[x][y] = 0;
		    Landscape[x][y] = WhichPlayer;
		    BPlayer[WhichPlayer].Secured[x][y] = 1;
		    Rect.x=x*BSIZE;
		    Rect.y=y*BSIZE;
		    Rect.w=BSIZE;
		    Rect.h=BSIZE;
		    SDL_BlitSurface(BackPic, &Rect, Screen, &Rect);
		    Blit(x*BSIZE, y*BSIZE, BPlayer[WhichPlayer].Ground);
		    SDL_BlitSurface(Screen, &Rect, BackBuffer, &Rect);
		    Redraws[RedrawNum].x=x;
		    Redraws[RedrawNum++].y=y;
		    if (Conquer) {
			ConquerCannon(x,y);
		    }
		}
	    // erase old fields
	    if (
		(Visited[x+1][y+1])
		&&(BPlayer[WhichPlayer].Secured[x][y])
		) {
		    int undraw=1;    
		
		    BPlayer[WhichPlayer].Secured[x][y]=0;
		    for (i=0; i<PlayerNum; i++) {
			if ( (BPlayer[i].Secured[x][y]) && (i != WhichPlayer) )
			    undraw = 0;
		    }
		    if (undraw) {
			Rect.x = x*BSIZE;
			Rect.y = y*BSIZE;
			Rect.w = BSIZE;
			Rect.h = BSIZE;
			SDL_BlitSurface(BackPic, &Rect, Screen, &Rect);
			SDL_BlitSurface(Screen, &Rect, BackBuffer, &Rect);
			AddThisRect(Rect);
			Redraws[RedrawNum].x = x;
			Redraws[RedrawNum++].y = y;
		    }
		}
	    }

    for (i=0;i<TankNum;i++)
	if (BPlayer[WhichPlayer].Secured[Tank[i].x][Tank[i].y]) {
	    Tank[i]=Tank[TankNum-1];
	    TankNum--;
	}
    
    for (i=0;i<RedrawNum;i++) {
	Redraw(Redraws[i].x,Redraws[i].y,WhichPlayer);
    }
}

void Turn( int WhichPlayer )
{
    int x,y;

    BPlayer[PLAYERNUM].Block[0][0]=BPlayer[WhichPlayer].Block[0][2];
    BPlayer[PLAYERNUM].Block[1][0]=BPlayer[WhichPlayer].Block[0][1];
    BPlayer[PLAYERNUM].Block[2][0]=BPlayer[WhichPlayer].Block[0][0];
    BPlayer[PLAYERNUM].Block[0][1]=BPlayer[WhichPlayer].Block[1][2];
    BPlayer[PLAYERNUM].Block[1][1]=BPlayer[WhichPlayer].Block[1][1];
    BPlayer[PLAYERNUM].Block[2][1]=BPlayer[WhichPlayer].Block[1][0];
    BPlayer[PLAYERNUM].Block[0][2]=BPlayer[WhichPlayer].Block[2][2];
    BPlayer[PLAYERNUM].Block[1][2]=BPlayer[WhichPlayer].Block[2][1];
    BPlayer[PLAYERNUM].Block[2][2]=BPlayer[WhichPlayer].Block[2][0];

    for (x=0;x<3;x++)
        for (y=0;y<3;y++) 
	    BPlayer[WhichPlayer].Block[x][y]=BPlayer[PLAYERNUM].Block[x][y];
}

void CalcBlock( int WhichPlayer, int Block, int turn)
{
    int i;

    switch( Block ) {
	case 0:
	case 1:
	    BPlayer[WhichPlayer].Block[0][0]=0;
	    BPlayer[WhichPlayer].Block[1][0]=1;
	    BPlayer[WhichPlayer].Block[2][0]=0;
	    BPlayer[WhichPlayer].Block[0][1]=0;
	    BPlayer[WhichPlayer].Block[1][1]=1;
	    BPlayer[WhichPlayer].Block[2][1]=0;
	    BPlayer[WhichPlayer].Block[0][2]=0;
	    BPlayer[WhichPlayer].Block[1][2]=1;
	    BPlayer[WhichPlayer].Block[2][2]=1;
	case 2:
	    BPlayer[WhichPlayer].Block[0][0]=0;
	    BPlayer[WhichPlayer].Block[1][0]=1;
	    BPlayer[WhichPlayer].Block[2][0]=0;
	    BPlayer[WhichPlayer].Block[0][1]=0;
	    BPlayer[WhichPlayer].Block[1][1]=1;
	    BPlayer[WhichPlayer].Block[2][1]=0;
	    BPlayer[WhichPlayer].Block[0][2]=1;
	    BPlayer[WhichPlayer].Block[1][2]=1;
	    BPlayer[WhichPlayer].Block[2][2]=0;
	break;
	case 3:
	case 4:
	case 5:
	    BPlayer[WhichPlayer].Block[0][0]=0;
	    BPlayer[WhichPlayer].Block[1][0]=1;
	    BPlayer[WhichPlayer].Block[2][0]=0;
	    BPlayer[WhichPlayer].Block[0][1]=1;
	    BPlayer[WhichPlayer].Block[1][1]=1;
	    BPlayer[WhichPlayer].Block[2][1]=0;
	    BPlayer[WhichPlayer].Block[0][2]=0;
	    BPlayer[WhichPlayer].Block[1][2]=0;
	    BPlayer[WhichPlayer].Block[2][2]=0;
	break;
	case 6:
	case 7:
	    BPlayer[WhichPlayer].Block[0][0]=0;
	    BPlayer[WhichPlayer].Block[1][0]=0;
	    BPlayer[WhichPlayer].Block[2][0]=0;
	    BPlayer[WhichPlayer].Block[0][1]=1;
	    BPlayer[WhichPlayer].Block[1][1]=1;
	    BPlayer[WhichPlayer].Block[2][1]=1;
	    BPlayer[WhichPlayer].Block[0][2]=0;
	    BPlayer[WhichPlayer].Block[1][2]=0;
	    BPlayer[WhichPlayer].Block[2][2]=0;
	break;
	case 8:
	case 9:
	    BPlayer[WhichPlayer].Block[0][0]=1;
	    BPlayer[WhichPlayer].Block[1][0]=0;
	    BPlayer[WhichPlayer].Block[2][0]=1;
	    BPlayer[WhichPlayer].Block[0][1]=1;
	    BPlayer[WhichPlayer].Block[1][1]=1;
    	    BPlayer[WhichPlayer].Block[2][1]=1;
	    BPlayer[WhichPlayer].Block[0][2]=0;
	    BPlayer[WhichPlayer].Block[1][2]=0;
	    BPlayer[WhichPlayer].Block[2][2]=0;
	break;
	case 10:
	    BPlayer[WhichPlayer].Block[0][0]=0;
	    BPlayer[WhichPlayer].Block[1][0]=0;
	    BPlayer[WhichPlayer].Block[2][0]=0;
	    BPlayer[WhichPlayer].Block[0][1]=0;
	    BPlayer[WhichPlayer].Block[1][1]=1;
	    BPlayer[WhichPlayer].Block[2][1]=0;
	    BPlayer[WhichPlayer].Block[0][2]=0;
	    BPlayer[WhichPlayer].Block[1][2]=0;
	    BPlayer[WhichPlayer].Block[2][2]=0;
	break;
    }
    for (i=0;i<turn;i++)
	Turn(WhichPlayer);
    if (SDL_GetTicks()>EndOfPhase)
	BPlayer[WhichPlayer].WaitForNextBlock=20000;
    else
	BPlayer[WhichPlayer].WaitForNextBlock=NEXT_BLOCK_TIME;
}

void GenerateBlock( int WhichPlayer )
{
    int Rand,Turn;
    char data[5];

    Rand=abrand(0,10);
    Turn=abrand(0,3);
    CalcBlock( WhichPlayer, Rand, Turn);
    
    data[0]=4;
    data[1]=NET_BLOCKGEN;
    data[2]=WhichPlayer;
    data[3]=Rand;
    data[4]=Turn;
    
    Net_Send( data );
}

void UndrawBlock()
{
    SDL_Rect Rect;
    int i;

    for (i=0;i<PlayerNum;i++) {
        Rect.x=BPlayer[i].x*BSIZE;
	Rect.y=BPlayer[i].y*BSIZE;
        Rect.w=3*BSIZE;
        Rect.h=3*BSIZE;
	if (Rect.h+Rect.y>Height*BSIZE)
	    Rect.h=Height*BSIZE-Rect.y;
	if (Rect.w+Rect.x>Width*BSIZE)
	    Rect.w=Width*BSIZE-Rect.x;
	    
    
        SDL_BlitSurface(BackBuffer, &Rect, Screen, &Rect);
//	printf( "Rect.x: %d, Rect.y %d, Rect.w %d, Rect.h %d\n", Rect.x, Rect.y, Rect.w, Rect.h);
//	printf( "BackBuffer->w: %d, BackBuffer->h %d, Screen->w %d, Screen->h %d\n", BackBuffer->w, BackBuffer->h, Screen->w, Screen->h);
        AddThisRect( Rect );
    }
}

void DrawSingleBlock( SDL_Surface *Dest, int x, int y, int WhichPlayer, int Style)
{
    if (Style)
	BlitTo( Dest ,x*BSIZE, y*BSIZE, BPlayer[WhichPlayer].CursorBlock );
    else
	BlitTo( Dest ,x*BSIZE, y*BSIZE, BPlayer[WhichPlayer].Wall );
}

void DrawBlock()
{
    int x,y,i;

    for (i=0;i<PlayerNum;i++)
	if ( !BPlayer[i].Lost ) {
	    if (BPlayer[i].WaitForNextBlock>0) {
		Blit( (BPlayer[i].x+1)*BSIZE, (BPlayer[i].y+1)*BSIZE, WaitBlockPic);
	    } else
	    
	    for (x=0;x<3;x++)
    		for (y=0;y<3;y++)
		    if ((BPlayer[i].x+x>=0)&&(BPlayer[i].y+y>=0)&&
			(BPlayer[i].x+x<Width)&&(BPlayer[i].y+y<Height))
    			    if (BPlayer[i].Block[x][y])
				DrawSingleBlock(Screen, BPlayer[i].x+x, BPlayer[i].y+y, i, 1);
	}
}

int CastlesSurrounded(int WhichPlayer)
{
    int cas;

    LookForSecuredAreas(WhichPlayer);
    
    PPlayer[WhichPlayer].SecuredCastles=0;
    for (cas=0;cas<CastleNum;cas++)
	if (BPlayer[WhichPlayer].Secured[Castle[cas].x][Castle[cas].y])
	    PPlayer[WhichPlayer].SecuredCastles += Castle[cas].Type;

    return PPlayer[WhichPlayer].SecuredCastles;
}

void ReallyPutBlock(int WhichPlayer)
{
    int x,y;

    for (x=0;x<3;x++)
        for (y=0;y<3;y++) 
	    if (BPlayer[WhichPlayer].Block[x][y]) {
		if (House[BPlayer[WhichPlayer].x+x][BPlayer[WhichPlayer].y+y])
		    House2Tank(BPlayer[WhichPlayer].x+x,BPlayer[WhichPlayer].y+y);
		else {
		    Wall[BPlayer[WhichPlayer].x+x][BPlayer[WhichPlayer].y+y] = WhichPlayer+1;
		    Landscape[BPlayer[WhichPlayer].x+x][BPlayer[WhichPlayer].y+y] = WhichPlayer;
		    DrawSingleBlock(BackBuffer, BPlayer[WhichPlayer].x+x, BPlayer[WhichPlayer].y+y, WhichPlayer, 0);
		}
	    }
}

int FarAway(int x, int y, int WhichPlayer)
{
    int tryX, tryY;
    
    for (tryX=-1; tryX<=3; tryX++) {
	for (tryY=-1; tryY<=3; tryY++) {
	    if ( 
		    (tryX+x>=0) && (tryY+y>=0)
		    &&(tryX+x<WIDTH*BSIZE) && (tryY+y<HEIGHT*BSIZE)
	    ) {
	        if ( Wall[x+tryX][y+tryY] == WhichPlayer+1 ) {
		    return 0;
		}
	    }
	}
    }

    return 1;
}

void PutBlock(int WhichPlayer)
{
    int x,y;
    char data[3];

    if (BPlayer[WhichPlayer].WaitForNextBlock > 0)
	return;

    for (x=0;x<3;x++)
        for (y=0;y<3;y++)
	    if (
		    (BPlayer[WhichPlayer].Block[x][y])
		    &&(
			(!FieldFree(BPlayer[WhichPlayer].x+x,BPlayer[WhichPlayer].y+y))
			||(
			      (!Conquer)
			      &&(Landscape[BPlayer[WhichPlayer].x+x][BPlayer[WhichPlayer].y+y]!=WhichPlayer)
			  )
		      )
		)
		return;

    if ( FarAway(BPlayer[WhichPlayer].x,BPlayer[WhichPlayer].y,WhichPlayer) && (Conquer) )
	return;

    data[0]=2;
    data[1]=NET_PUTBLOCK;
    data[2]=WhichPlayer;
    Net_Send(data);

    ReallyPutBlock( WhichPlayer );
    GenerateBlock( WhichPlayer );

}

void SendPos( int which, int sig)
{
    char data[5];

    data[0]=4;
    data[1]=sig;
    data[2]=which;
    data[3]=BPlayer[which].x;
    data[4]=BPlayer[which].y;
    Net_Send(data);
}

int BuildEvents(const SDL_Event *event)
{
    int i;

    switch (event->type) {
	case SDL_MOUSEBUTTONDOWN:
//	    SDL_GetMouseState(&MouseX, &MouseY);
	break;    
	case SDL_KEYDOWN:
	    UndrawBlock();
	    for (i=0;i<PlayerNum;i++) 
		if ( (!BPlayer[i].Lost) && (BPlayer[i].Local) ) {
		if ( event->key.keysym.sym == BPlayer[i].Up    ) BPlayer[i].y--;
		if ( event->key.keysym.sym == BPlayer[i].Down  ) BPlayer[i].y++;
		if ( event->key.keysym.sym == BPlayer[i].Left  ) BPlayer[i].x--;
		if ( event->key.keysym.sym == BPlayer[i].Right ) BPlayer[i].x++;
		if ( event->key.keysym.sym == BPlayer[i].Button2 ) {
		    char data[3];
		
		    Turn(i);
		    data[0]=2;
		    data[1]=NET_TURN;
		    data[2]=i;
		    Net_Send(data);
		}
		if ( event->key.keysym.sym == BPlayer[i].Button1 ) {
		    PutBlock(i);
		    LookForSecuredAreas(i);
		    UndrawBlock();
		}
		AdjustPosition(i);
		SendPos(i,NET_BPLAYER_MOVE);
	    }
	    DrawBlock();
	    Update();
	break;
    }
    
    return NormalEvents(event);
}


void InitBuild()
{
    int i;
    Coord coord;
    
    if (PlayerNum>2) {
        BPlayer[0].x=Width/4;
	BPlayer[0].y=Height/4;
        BPlayer[1].x=Width/4*3;
        BPlayer[1].y=Height/4;
	BPlayer[2].x=Width/4;
        BPlayer[2].y=Height/4*3;
	BPlayer[3].x=Width/4*3;
        BPlayer[3].y=Height/4*3;
    }
    for (i=0;i<PlayerNum;i++) {
	if (PlayerNum==2) {
	    BPlayer[i].x = Width/4+i*Width/2;
	    BPlayer[i].y = Height/2;
	}
	if (BPlayer[i].Local)
	    GenerateBlock(i);
        BPlayer[i].WaitForNextBlock = 0;
    }
    
    if (Conquer) {
	for (i=0;i<PlayerNum;i++) {
	    coord = Center(i);
	    BPlayer[i].x = coord.x;
	    BPlayer[i].y = coord.y;
	}
    }
    
    Blit(0, 0, BackBuffer);
}

void PrintTime()
{
    int Time;
    SDL_Rect Rect;
    
    Time=(int)((EndOfPhase-SDL_GetTicks())/1000);
    if (Time>1000) Time=0;

//    if (ShownTime!=Time) {
	sprintf(TimeText," %d ",Time);

	Rect.x = Width*BSIZE/2-TextWidth(TimeText)/2;
	Rect.y = 5;
	Rect.w = TextWidth(TimeText);
	Rect.h = Font->h;
	SDL_BlitSurface( BackBuffer, &Rect, Screen, &Rect);
	AddThisRect(Rect);
	
	Rect.x = Width*BSIZE/2-TextWidth(TimeText)/2;
	Rect.y = 5;
	Rect.w = TextWidth(TimeText);
	Rect.h = Font->h;
	XCenteredString(Screen, 5, TimeText);
	AddThisRect(Rect);
	ShownTime=Time;
//    }
}

void ReallyClean(int Cleaned)
{
    SDL_Rect Rect;
    int x,y,i,WallCount;

    // clean up walls
    for (x=0;x<Width;x++)
	for (y=0;y<Height;y++) 
	    if (Wall[x][y]) {
		WallCount=0;
		if ( Wall[x-1][y] ) WallCount++;
		if ( Wall[x+1][y] ) WallCount++;
		if ( Wall[x][y-1] ) WallCount++;
		if ( Wall[x][y+1] ) WallCount++;
		if ( WallCount==0 ) Wall[x][y]=0;
		if ( WallCount==1 ) {
		    Cleaned++;
		    if ( Cleaned==3 ) {
			Wall[x][y]=0;
			Cleaned=0;
		    }
		}
		if ( Wall[x][y]==0 ) {
		    BPlayer[Landscape[x][y]].Secured[x][y]=0;
		    Rect.x=x*BSIZE;
		    Rect.y=y*BSIZE;
		    Rect.w=BSIZE;
		    Rect.h=BSIZE;
		    SDL_BlitSurface(BackPic, &Rect, Screen, &Rect);
		    SDL_BlitSurface(BackPic, &Rect, BackBuffer, &Rect);
		    AddThisRect(Rect);
		}
	    }

    for (i=0;i<PlayerNum;i++) {
	LookForSecuredAreas(i);
    }
}

void Clean()
{
    int Cleaned;
    char data[3];
    int x,y;

    // clean garbage
    for (x=0;x<Width;x++)
	for (y=0;y<Height;y++) 
	    if (Garbage[x][y]) {
		Garbage[x][y]--;
		BPlayer[Landscape[x][y]].Secured[x][y]=1-BPlayer[Landscape[x][y]].Secured[x][y];
	    }

    if (Master) {
	Cleaned=abrand(0,3);
	data[0]=2;
	data[1]=NET_CLEAN;
	data[2]=Cleaned;
	Net_Send(data);
	printf("Cleanup info sent to slaves.\n");
	ReallyClean(Cleaned);
    }
}

void HandleWaitForBlock()
{
    int i;
    
    for (i=0;i<PlayerNum;i++)
	if ( BPlayer[i].WaitForNextBlock > 0 ) {
	    BPlayer[i].WaitForNextBlock-=Speed;
	    if ( BPlayer[i].WaitForNextBlock <= 0 ) {
		UndrawBlock(i);
		DrawBlock(i);
	    }
	}
}

Coord Center(int i)
{
    float xresult=0,yresult=0;
    int count=0,x,y;
    Coord coord;
    
    LookForSecuredAreas(i);
    for (x=0; x<Width; x++) {
	for (y=0; y<Width; y++) {
	    if (BPlayer[i].Secured[x][y]) {
		xresult += x;
		yresult += y;
		count++;
	    }
	}
    }
    
    coord.x = (char)(xresult / count);
    coord.y = (char)(yresult / count);
    
    if ( (coord.x == 0) && (coord.y == 0) ) {
	coord = BPlayer[i].OldCenter;
    } else {
	BPlayer[i].OldCenter = coord;
    }
    
    return(coord);
}

void Build()
{
    SDL_EventState(SDL_KEYDOWN, SDL_IGNORE);
    Phase=BUILD_PHASE;
    printf("-- Build Init begins\n");
    SDL_SetEventFilter(&BuildEvents);
    Net_WaitForStart();
    InitBuild();
    DrawBlock();
    ShowText("Build Castle Walls!");
    Net_WaitForStart();
    printf("-- Build phase begins\n");
    Now=SDL_GetTicks();
    EndOfPhase=Now + 18*1000 + Conquer*5*1000;
    SDL_EventState(SDL_KEYDOWN, SDL_ENABLE);
    while ( (!Quit)&&(SDL_GetTicks()<EndOfPhase+1500) ) {
	SDL_PollEvent(&event);
	PrintTime();
	GetSpeed();
	HandleWaitForBlock();
	PlaceMove( &UndrawBlock, &DrawBlock, NET_BPLAYER_MOVE);
	Network();
	Update();
	SDL_Delay(10);
    }
    printf("-- Build phase has finished\n");
    Net_WaitForStart();
    if (!Quit) Clean();
}