#ifndef GAME_H
#define GAME_H

struct castletype {
    int x, y, Type, Owner;
};

typedef struct castletype CastleType;

#include <SDL_types.h>

void StartGame();
void AddScore(int ScoreBonus);
void GetSpeed();
void MenuEvents();
void ShowText(char *text);

#define PLAYERNUM 8

#define WIDTH 80
#define HEIGHT 60
#define MAX_CASTLENUM 12

#define BUILD_PHASE  1
#define PLACE_PHASE  2
#define BATTLE_PHASE 3

double Speed;
int PlayerNum, LocalPlayerNum, CastleNum, EndGame, Width, Height, Phase, Conquer, RoundNum;
char SelectFinished[PLAYERNUM],Selected[PLAYERNUM];
Uint32 Now;
Sint8 Wall[WIDTH][HEIGHT];
Sint8 Landscape[WIDTH][HEIGHT];
Sint8 Garbage[WIDTH][HEIGHT];
Sint8 House[WIDTH][HEIGHT];
CastleType Castle[MAX_CASTLENUM];
void BuildWallAroundCastle( int i );
void UndrawSelect(int i);
void DrawSelect(int i);
void Message(char *text);
int NormalEvents(const SDL_Event *event);
void ChangeColorAlpha( SDL_Surface *surf, Uint32 Color);

#endif GAME_H
