# 
#
# 	PREFERENCES MANAGEMENT
# 	(c) 1997 Alexandre Burton & Jean Piche
# 	v1.80a (10/08/97)
#
#       EDITED BY: Hans-Christoph Steiner <hans@eds.org>
#       $Id $
#

proc initPrefs {} {
	global ceclib user homedir fffont manfont ffont pref_path _db
	global env color submodules  prefs modir module   tcl_platform
	
	switch --  $tcl_platform(platform) {
	    macintosh 	{ set pref_path [file join $env(PREF_FOLDER) "Cecilia Preferences"] }
	    windows 	{ set pref_path [file join $ceclib prefs] }
	    unix	{ set pref_path [file join $env(HOME) .ceciliarc] }
	}

    	if ![file exists $pref_path]  {
	    showfirst ; update
	    newprefs $pref_path
	} else {
	    set prefil [open  $pref_path r+]
	    array set prefs [read $prefil]
	    close $prefil

	    if ![info exists prefs(version)] {
		newprefs $pref_path
	    } elseif {$prefs(version) < $_db(cecilia,V)} {
		newprefs $pref_path
	    }
	}
   
    set color $prefs(color)
    
 #   foreach f [cd "[file join $ceclib BuiltIn]"; ls] {
#		lappend submodules [file join $ceclib BuiltIn $f]
#	}
  
#	set submodules [glob [file join $ceclib Builtin *]]
  
#	set modir $submodules
    setdict $prefs(lang)
}


proc newprefs {p} {

    bug creating new preference file in $p
    puts "note: creating new prefs"
    global prefs tcl_platform _db env
    array set prefs {
	graph 0 wind 0 time 0 globalMode 0 assist 1 intmem 1 relink 0
	heart 0 ascii 0	midi 0	sigin 0	type aiff mess 7
	diskb 8192	diskB 8192	realb 64	realB 2048	
	realText 50 diskText 50
	amp 1 range 1	warn 1	play 1 incr 1	gen 8192	
	ksm 10	chn stereo	envir 0	lang english	
	color snow tabs 1c	font \"courier\" style normal	
	size 12	edset 010101000 pkey Control-space skey Escape ikey Control-BackSpace
	tools 0	colorize 0	
	manstyle medium	 mansize 12 hlpsize -4
	midiport ttyd2 tempo off	sr 44100  kr 4410
	keep 0 MODIR {} geom,pre 800x600+100+100 geom,. +10+10
	override,looks 1
    }
    set prefs(version) $_db(cecilia,V)
    
    switch -- $tcl_platform(os) {
	MacOS   { 
	    set prefs(geom,pre) +40+40
	    set prefs(geom,.) +3+23
	    set prefs(font,path) [file join $env(PREF_FOLDER)  "Cecilia Font List"]
	    set tempSpot $env(DESK_FOLDER)
	    array set preflist {
		PLAY {SCPL {SoundApp Fat}}          EDIT {jBox {SoundEdit16}}
		TEXT {ALFA {Alpha}}                 HTML {MOSS {Netscape Communicator}}
		CSND {CSND {Perf}}                  CONV {SCPL {SoundApp Fat}}
		MIDI {MTRx {Cakewalk Metro 3.5}}                  
	    }    
	}
	Windows     { 
	    set prefs(geom,pre) +40+40
	    set prefs(geom,.) +3+23
	    set prefs(folder) $ceclib 
	    set prefs(font,path) [file join $prefs(folder) "fonts"]
	    set tempSpot [file join $env(WINDIR) Desktop]	
	    array set preflist {
		PLAY {SCPL {SoundApp Fat}}          EDIT {jBox {SoundEdit16}}
		TEXT {ALFA {Alpha}}                 HTML {MOSS {Netscape Communicator}}
		CSND {CSND {Perf}}                  CONV {SCPL {SoundApp Fat}}
		MIDI {MTRx {Cakewalk Metro 3.5}}                  
	    }
	}
	IRIX        { 
	    set prefs(geom,pre)  800x600+100+100
	    set prefs(geom,.) +10+10
	    set prefs(folder) $env(HOME) 
	    set prefs(font,path) [file join $prefs(folder) ".ceciliafonts"]
	    set tempSpot /tmp 
	    array set preflist {
		PLAY {/usr/sbin/soundplayer  soundplayer}  EDIT {/usr/sbin/soundeditor   soundeditor}
		TEXT {/usr/sbin/jot          jot}          HTML {/usr/local/bin/netscape netscape}
		CSND {/usr/local/bin/csound  csound}       CONV {/usr/sbin/soundfiler    soundfiler}
		MIDI {/usr/local/bin/rosegarden    rosegarden}                  
	    }
	    set t [locateCsound]
	    set preflist(CSND) [list $t [file tail $t]]
	}
	Linux       { 
	    set prefs(geom,pre) +100+100
	    set prefs(geom,.) +10+10
	    set prefs(folder) $env(HOME) 
	    set prefs(font,path) [file join $prefs(folder) ".ceciliafonts"]
	    set tempSpot /tmp 
	    array set preflist {
		PLAY {/usr/bin/play            play}          EDIT {/usr/X11R6/bin/audacity audacity}
		TEXT {/usr/bin/emacs           emacs}         HTML {/usr/bin/mozilla        mozilla}
		CSND {/usr/local/bin/csound    csound}        CONV {/usr/bin/xsox           xsox}
		MIDI {/usr/bin/rosegarden      rosegarden}                  
	    }
	    set t [locateCsound]
	    set preflist(CSND) [list $t [file tail $t]]
	}
	Darwin       { 
	    set prefs(geom,pre) +100+100
	    set prefs(geom,.) +10+10
	    set prefs(folder) $env(HOME) 
	    set prefs(font,path) [file join $prefs(folder) ".ceciliafonts"]
	    set tempSpot /private/tmp 
	    # assumes Fink (http://fink.sf.net) is installed into /sw
	    array set preflist {
		PLAY {/sw/bin/esdplay          esdplay}       EDIT {/usr/bin/open           open}
		TEXT {/usr/bin/open            open}          HTML {/usr/bin/open           open}
		CSND {/usr/local/bin/csound    csound}        CONV {/sw/bin/sox             sox}
		MIDI {/usr/bin/open            open}                  
	    }
	    set t [locateCsound]
	    set preflist(CSND) [list $t [file tail $t]]
	}
    }
    foreach t [array names preflist] {
	set prefs(help:$t) [lindex $preflist($t) 0]
	set prefs(helpname:$t) [lindex $preflist($t) 1]
    }	
    
    foreach var {SFDIR SSDIR SADIR TMPDIR} {set prefs($var) $tempSpot}
    
    set prefil  [open  $p w+]
    puts $prefil [array get prefs]
    close $prefil
}

proc localCsound {} {
    global ceclib tcl_platform
    puts "warning: no correct version of csound found on your system"

    switch -- $tcl_platform(os) {
	IRIX {
	    set x [exec uname -r]
	    if {$x < 6.0} {set r 5.x} {set r 6.x}
	    set defaultCsound $ceclib/csound_irix$r
	} 
	Linux { 
# this should be worked out better, package (deb, rpm, etc) dependencies would work best
	    set defaultCsound csound
	}
	Darwin {
# this should be worked out better, probably by including a binary with the distro
	    set defaultCsound csound
	}
    }
    puts "defaulting to supplied $defaultCsound"
    return $defaultCsound
}

proc locateCsound {} {
    global ceclib
    if [catch {set csound [exec which csound]}] {
	return [localCsound]
    } {
	puts "info: $csound found; verifying version"
	catch {exec $csound >& /tmp/csvers}
	set f [open /tmp/csvers r]
	while ![eof $f] {
	    set l [gets $f ]
	    if [regexp Version $l] { break }
	}	
	
	close $f
	if ![regexp 4 [lindex $l 2]] {
	    puts "info: $csound version incorrect (probably <3.47)"
	    return [localCsound]
	} {
	    puts "info: $csound version correct"
	    return $csound
	}
    }
    puts "error: something is wrong with the Csound executable; check your prefs"
    return {}
}

proc sethelper {app} {
    global prefs tcl_platform currentdir
    switch $tcl_platform(platform) {
	macintosh {
	    set f [tk_getOpenFile -filetypes {{Applications {} APPL}}]
	    if {$f != ""} {
		set prefs(help:$app) [file attributes $f -creator]
		set prefs(helpname:$app) [file tail $f]
		.preferences.utes.f$app config -fg blue
	    } else { bug "nothing selected" }
	}
	windows {
	    set f [tk_getOpenFile -filetypes {{Executables {.exe} {}} {All {*.*} {}} }]
	    if {$f != ""} {
		set prefs(help:$app)  [file attributes $f -shortname]
		set prefs(helpname:$app) [file root [file tail [file attributes $f -longname]]]
		.preferences.utes.f$app config -fg blue
	    } else { puts "nothing selected" }
	}
	unix {
	    set types {
		{{All Files} * }
	    }
	    set f [chooseOpen "Choose an application:" $currentdir $types]
	    if {$f != ""} {
		if [file executable $f] {
		    set prefs(help:$app) $f
		    set prefs(helpname:$app) [file tail $f]
		    .preferences.utes.f$app config -fg blue
		} { puts "$f is not executable!" }
	    } { puts "nothing selected" }
	}
    }
}

proc preferences { } {
    global color cfont lan tfq prefs coul CSversion tcl_platform path globalAssist
    
    if [winfo exists .preferences] {
		wm deiconify .preferences 
		raise .preferences
		grab set $tfq
    } else {
	
	toplevel $path(prefs)

	wm title .preferences "$CSversion Preferences"
   	grab set .preferences

	pack [frame .preferences.utes -relief groove -bd 2 ] \
		-expand 1 -fill x -side top  -padx 6 -pady 6	
	
	array set pname {
		PLAY   "Soundfile Player" EDIT   "Soundfile Editor"     TEXT   "Text Editor"
		SSDIR  "SoundIN f"        SFDIR  "SoundOUT f"           SADIR  "Analysis f" 
		TMPDIR "Temporary f"      HTML   "HTML Viewer"          CSND   "Csound Binary"
	        MODIR  "Module f"         CONV   "Soundfile Converter"  COL    "Color Scheme"
		MIDI   "MIDI Editor"
	}
	
	grid columnconfigure .preferences.utes 3 -weight 2
#	grid config .preferences.utes -ipady 5

	set a 0

	if {$tcl_platform(platform) == "macintosh"} {
	    set list {PLAY EDIT CONV TEXT HTML MIDI}
	} else { 
	    set list {CSND PLAY EDIT CONV TEXT HTML MIDI}
	}

	grid [frame $path(prefs).utes.topSpace] \
		-column 1 -row $a -sticky ew -columnspan 4 -pady 2
	incr a
	
	# helpers
	foreach app $list {
	    grid [label $path(prefs).utes.f$app  -text $pname($app):]\
		    -column 1 -row $a -columnspan 1  -sticky e
	    grid [label $path(prefs).utes.l$app -textvariable prefs(help:$app)]\
		    -column 2 -row $a -columnspan 1  -sticky e 
	    grid [label $path(prefs).utes.l2$app -font $cfont(big) -fg red\
		    -textvariable prefs(helpname:$app)]\
		    -column 3 -row $a -columnspan 1 -sticky w 
	    grid [button $path(prefs).utes.b$app  -text "set..." \
		    -command "sethelper $app" -pady 0 ] -column 4 -row $a -sticky ew -padx 4
	    bindHelp $path(prefs).utes.f$app LPref$app
	    bindHelp $path(prefs).utes.l$app LPrefPath
	    bindHelp $path(prefs).utes.b$app bPrefSet
	    incr a
	}

	
	# hack separateur???
	grid [frame $path(prefs).utes.upmid2] \
		-column 1 -row $a -sticky ew -columnspan 4 -pady 2
	incr a
	grid [frame $path(prefs).utes.bbb2 -bg gray50 -relief sunken] \
		-column 1 -row $a -sticky ews -columnspan 4
	incr a
	grid [frame $path(prefs).utes.ccc2 -bg white -relief sunken] \
		-column 1 -row $a -sticky new -columnspan 4
	incr a
	grid [frame $path(prefs).utes.lowmid2] \
		-column 1 -row $a -sticky ew -columnspan 4 -pady 2
	incr a

	# synchronisateur
	
	if {$tcl_platform(platform) != "macintosh"} {
		grid [button $path(prefs).utes.sync -text "sync\nto\nenv" -command syncToEnv] \
		  -column 4 -row $a -rowspan 5 -sticky news -padx 4
		bindHelp $path(prefs).utes.sync bPrefSync
	}
	
	# repertoires
	foreach app {SSDIR SFDIR SADIR MODIR TMPDIR} {
	    grid [label $path(prefs).utes.f$app  -text $pname($app):] \
		    -column 1 -row $a -sticky e
	    grid [entry $path(prefs).utes.l$app] \
		    -column 2 -row $a -sticky ew -columnspan 2
	    bind $path(prefs).utes.l$app <Any-Key> "$path(prefs).utes.f$app config -fg blue"
	    bindHelp $path(prefs).utes.f$app LPref$app
	    bindHelp $path(prefs).utes.l$app LPrefFolder
	    $path(prefs).utes.l$app insert 0 $prefs($app)
	    incr a
	}

	# hack separateur???
	grid [frame $path(prefs).utes.upmid] \
		-column 1 -row $a -sticky ew -columnspan 4 -pady 2
	incr a
	grid [frame $path(prefs).utes.bbb -bg gray50 -relief sunken] \
		-column 1 -row $a -sticky ews -columnspan 4
	incr a
	grid [frame $path(prefs).utes.ccc -bg white -relief sunken] \
		-column 1 -row $a -sticky new -columnspan 4
	incr a
	grid [frame $path(prefs).utes.lowmid] \
		-column 1 -row $a -sticky ew -columnspan 4 -pady 2
	incr a
	
	# couleur
	grid [label $path(prefs).utes.collabel -text "Color Scheme:"] -column 1 -row $a -sticky e
	grid [frame $path(prefs).utes.colorhold] -column 2 -row $a -sticky w -columnspan 2
	
	foreach col {1 2 3 4} {
		label $path(prefs).utes.colorhold.col$col  -bg $prefs(color)$col \
		  -highlightthickness 1 -width 1 -height 1		    
	    pack $path(prefs).utes.colorhold.col$col -side left -fill x
	}
	
	optMenu $path(prefs).utes.selectcol prefs(color) {foreach colo {1 2 3 4} \
	  {$path(prefs).utes.colorhold.col$colo config \
	  -bg $prefs(color)$colo }} $cfont(small) $color 14  1 \
		"antiquewhite" "azure" "bisque"  "cornsilk"  "darkslategray" \
		"honeydew"  "ivory" "khaki" "lavenderblush" \
		"lemonchiffon" "lightblue" "lightcyan" "lightgoldenrod" "lightpink" \
		"lightsalmon" "lightskyblue" "lightsteelblue" "lightyellow"  \
		"mistyrose" "navajowhite" "paleturquoise" "peachpuff" "rosybrown" \
		"seagreen" "seashell" "skyblue" "slategray" "snow" \
		"steelblue" "thistle" "wheat" "yellow"
	grid $path(prefs).utes.selectcol -row $a -column 3 -columnspan 2 -sticky e
	bindHelp $path(prefs).utes.selectcol bPrefCol

	incr a
	grid [frame $path(prefs).utes.upmid3] \
		-column 1 -row $a -sticky ew -columnspan 4 -pady 2

	
	# hotkeys
	if {$tcl_platform(platform) == "unix"} {
	
		pack [frame $path(prefs).sCut -relief groove -bd 2] -side top -fill x -expand 1 -padx 5 -pady 3
		grid [label $path(prefs).sCut.t -text "Shortcut Keys\nfor Play Controls" -justify center] \
			    -row 0 -column 0  -rowspan 3 -sticky e
		grid columnconfigure $path(prefs).sCut.t 0 -weight 2000
	
		grid [label $path(prefs).sCut.pm -text "Play Key:"] -column 1 -row 0 -padx 2 -pady 5 
		entry $path(prefs).sCut.penk -textvar prefs(pkey) -width 14
		grid $path(prefs).sCut.penk  -column 4 -row 0 -padx 2 -pady 2 
		bind $path(prefs).sCut.penk <KeyPress> {pook %K}
		bind  $path(prefs).sCut.penk  <KeyRelease> {givkey p}
	
		grid [label $path(prefs).sCut.sm -text "Stop Key:"] -column 1 -row 2 -padx 2 -pady 5  
		entry $path(prefs).sCut.senk  -textvar prefs(skey)  -bg ${color}1  -width 14
		grid $path(prefs).sCut.senk  -column 4 -row 2 -padx 2 -pady 2 
		bind $path(prefs).sCut.senk <KeyPress> {pook %K}
		bind  $path(prefs).sCut.senk  <KeyRelease> {givkey s}
	
		grid [label $path(prefs).sCut.im -text "Pause Key:"] -column 1 -row 3 -padx 2 -pady 5  
		entry $path(prefs).sCut.ienk  -textvar prefs(ikey)  -bg ${color}1  -width 14
		grid $path(prefs).sCut.ienk  -column 4 -row 3 -padx 2 -pady 2 
		bind $path(prefs).sCut.ienk <KeyPress> {pook %K}
		bind  $path(prefs).sCut.ienk  <KeyRelease> {givkey i}
		
		bindHelp $path(prefs).sCut bPrefKeys
	}


#################################################

#	grid [frame $path(prefs).utes.bottom] \
#		-column 1 -row $a -sticky ew -columnspan 4 -pady 2
#	incr a

####################################


	set bou	[frame $path(prefs).bout -relief groove -bd 2]
	button $bou.quit -text OK  -width 8 \
		-command "update;doPrefs;grab release $path(prefs);destroy $path(prefs)"

	if {$tcl_platform(platform) == "macintosh"} {$bou.quit config -default 1}

	pack $bou.quit -side right -expand 1 -anchor e  -padx 5
  
	button $bou.cancel -text $lan(nom70) \
		-highlightthickness 0  \
		-width 8 -command "grab release $path(prefs);destroy $path(prefs)"

	pack $bou.cancel -side right -expand 1 -anchor w  -pady 5 -padx 5
	pack $bou -side bottom -pady 5 -padx 6 -fill x -expand 1
   	bind $path(prefs) <Return> "$bou.quit invoke"
   	bind $path(prefs) <Escape> "$bou.cancel invoke"
	bindHelp $bou.cancel bPrefCancel
	bindHelp $bou.quit   bPrefOK

	frame $path(prefs).help -bd 2 -relief groove
	pack [label $path(prefHelp) -textvariable globalAssist -justify left -anchor w] \
		-fill x -padx 1 -anchor w
	bindHelp $path(prefHelp) LWinHelp
	if $prefs(assist) { pack $path(prefs).help -side bottom -fill x -after $bou -anchor s -padx 6 }

	# limitation verticale du resize
	update idletask
	wm resizable $path(prefs) 1 0
    }
}

proc syncToEnv {} {
    global env path
    foreach e {SFDIR SADIR SSDIR TMPDIR MODIR} {
	if [info exists env($e)] {
	    $path(prefs).utes.l$e delete 0 e
	    $path(prefs).utes.l$e insert 0 $env($e)
	    $path(prefs).utes.f$e config -fg blue
	} { puts "no env variable set for $e!" }
    }
}

proc doPrefs {} {
	global pref_path prefs path
	if [winfo exists $path(prefs)] {
	    foreach app {SSDIR SFDIR SADIR TMPDIR MODIR} {
			set prefs($app) [$path(prefs).utes.l$app get]
		}
	}
	modKeys
	set prefil  [open $pref_path w+]
	set ff [wm geometry .]
	set prefs(geom,.) [string range $ff [string first "+" $ff] end]
	puts $prefil [array get prefs]
	close $prefil
}

proc modKeys {} {
	global path
    bindgraph
    bindedit
    bindsoundwin $path(win)
    if [winfo exists .win] bindtoo
    if [winfo exists .vslide] bindvslide
}


proc pook {x} {
global kbuf
    append kbuf $x-
}

proc givkey {w} {
global kbuf path prefs
    if {$kbuf != ""} {
	set kbuf [string trim $kbuf -]
	regsub -all  _R $kbuf "" kbuf
	regsub -all  _L $kbuf "" kbuf
	regsub -all  Shift $kbuf "" kbuf
	$path(prefs).sCut.${w}enk delete 0 end
	$path(prefs).sCut.${w}enk insert 0 $kbuf
	set prefs(${w}key) $kbuf
    }
    set kbuf ""
}
