/* TilePanel.m
 * Panel for batch production
 *
 * Copyright (C) 1996-2003 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  1996-04-10
 * modified: 2003-06-26
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#include <AppKit/AppKit.h>
#include <VHFShared/VHFSystemAdditions.h>
#include <VHFShared/vhfCommonFunctions.h>
#include "App.h"
#include "TilePanel.h"
#include "functions.h"
#include "DocView.h"

@interface TilePanel(PrivateMethods)
@end

@implementation TilePanel

- (NSPoint)distance
{   NSPoint	p;

    p.x = convertFromUnit([[distanceMatrix cellAtRow:0 column:0] floatValue]);
    p.y = convertFromUnit([[distanceMatrix cellAtRow:1 column:0] floatValue]);
    return p;
}

- (BOOL)limitSize
{
    return ( [limitsPopUp indexOfSelectedItem] == 0 ) ? NO : YES;
}

- (NSPoint)limits
{   NSPoint	p;

    p.x = [[limitsMatrix cellAtRow:0 column:0] floatValue];
    p.y = [[limitsMatrix cellAtRow:1 column:0] floatValue];
    if ( [self limitSize] )
    {   p.x = convertFromUnit(p.x);
        p.y = convertFromUnit(p.y);
    }

    return p;
}

- (void)createTilesAsCopy:(BOOL)buildCopy
{   id		view = [[(App*)NSApp currentDocument] documentView];
    NSPoint	dist = [self distance], limits = [self limits];
    BOOL	limitSize = [self limitSize];
    NSSize	viewSize = [view bounds].size;

    /* check input */
    if ( [self limitSize] )
    {
        if ( viewSize.width<limits.x || viewSize.height<limits.y )
        {
            [[limitsMatrix cellAtRow:0 column:0] setStringValue:buildRoundedString(convertToUnit(limits.x), 0.0, convertToUnit(viewSize.width))];
            [[limitsMatrix cellAtRow:1 column:0] setStringValue:buildRoundedString(convertToUnit(limits.y), 0.0, convertToUnit(viewSize.height))];
            return;
        }
    }
    else
    {
    }

    if ( buildCopy )
        [view   buildTileCopies:limits limitSize:limitSize distance:dist];
    else
        [view setTileWithLimits:limits limitSize:limitSize distance:dist];
}

/*
 * modified: 16.10.95 02.03.97
 */
- (void)set:sender
{
    [self createTilesAsCopy:NO];
}

/*
 * modified: 16.10.95 02.03.97
 */
- (void)buildCopies:sender
{
    [self createTilesAsCopy:YES];
}

/*
 * modified: 16.10.95 02.03.97
 */
- (void)removeTiles:sender
{
    [[[(App*)NSApp currentDocument] documentView] removeTiles];
}

/*
 * modified: 16.10.95 02.03.97
 * updatePanel: is used to copy the existing situation into the Tile panel
 */
- (void)updatePanel:sender
{   NSPoint	p;
    float	min = convertToUnit(MMToInternal(-500.0)), max = convertToUnit(MMToInternal(500.0));
    id		view = [[(App*)NSApp currentDocument] documentView];

    /* show distance between tiles */
    p = [view tileDistance];
    [[distanceMatrix cellAtRow:0 column:0] setStringValue:buildRoundedString(convertToUnit(p.x), min, max)];
    [[distanceMatrix cellAtRow:1 column:0] setStringValue:buildRoundedString(convertToUnit(p.x), min, max)];

    /* show Defaults for size of material */
    if ( [self limitSize] )
    {   NSPoint	lim = [view tileLimits];

        if ( [view tileLimitSize] )
            lim = NSMakePoint( convertToUnit(lim.x), convertToUnit(lim.y) );
        else
            lim = NSMakePoint( convertMMToUnit(100.0), convertMMToUnit(100.0) );

        [[limitsMatrix cellAtRow:0 column:0] setStringValue:buildRoundedString(lim.x, min, max)];
        [[limitsMatrix cellAtRow:1 column:0] setStringValue:buildRoundedString(lim.y, min, max)];
    }
    /* or number of items */
    else
    {   NSPoint	lim = (![view tileLimitSize]) ? [view tileLimits] : NSMakePoint( 2.0, 2.0 );

        if ( !lim.x || !lim.y )
            lim = NSMakePoint( 2.0, 2.0 );
        [[limitsMatrix cellAtRow:0 column:0] setIntValue:(int)lim.x];
        [[limitsMatrix cellAtRow:1 column:0] setIntValue:(int)lim.y];
    }
}

@end
