/*
 * FormTemplate.h
 *
 * Copyright (C) 1997-2003 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  1997-04-09
 * modified: 
 */

#import <Foundation/Foundation.h>

@interface FormTemplate:NSObject
{
    NSString	*template;
    NSString	*printerName;
}

/* class methods */
+ (FormTemplate*)template;
+ (FormTemplate*)templateWithString:(NSString*)string;

+ (void)printPages:(NSArray*)pages printer:(NSString*)printerName;

/* instance methods */
- copy;

- (BOOL)loadTemplate:(NSString*)fileName;
- (void)setTemplate:(NSString*)string;
- (NSString*)string;

- (NSArray*)splitAt:(NSString*)name lines:(int*)lines;
- (BOOL)removeTagsWithName:(NSString*)name;
- (BOOL)joinHeader:(NSString*)header body:(NSString*)body trailer:(NSString*)trailer;

- (BOOL)hasName:(NSString*)name;
- (void)removeMasks;
- (BOOL)setStrings:(NSString*)string forName:(NSString*)name;
- (int)setString:(NSString*)string forName:(NSString*)name;
- (int)setString:(NSString*)string forName:(NSString*)name removeEmptyLine:(BOOL)removeLine;
- (BOOL)setListWithKeys:(NSArray*)keys replaceWith:(NSArray*)vals forName:(NSString*)name;
- (int)setListWithKeys:(NSArray*)keys replaceWith:(NSArray*)vals offset:(int)offset forName:(NSString*)name;
- (BOOL)removePartWithName:(NSString*)name;

- (void)writeToFile:(NSString*)fileName;
- (void)setPrinterName:(NSString*)printer;
- (BOOL)printPage;

@end
