/*
<!-- 
****** BEGIN LICENSE BLOCK *****
Version: MPL 1.1/GPL 2.0/LGPL 2.1

The contents of this file are subject to the Mozilla Public License Version 
1.1 (the "License"); you may not use this file except in compliance with 
the License. You may obtain a copy of the License at 
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is Checky.

The Initial Developer of the Original Code is
Joachim Schreiber (yobiz@users.sourceforge.net).
Portions created by the Initial Developer are Copyright (C) 2002-2004
the Initial Developer. All Rights Reserved.

Contributor(s):
Mike Hommey (mh@glandium.org)

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

Checky - Resource Validation and Analysis Extension for Mozilla and Firefox.
Easy to use Interface to many different free and commercial Online 
Validation and Analysis Services. Any rights not expressly granted herein 
are reserved by their owners. 
Please visit all Service Web Sites for more informations about terms of usage 
before using Checky the first time. Hyperlinks are located at 
http://checky.sourceforge.net/#Services

***** END LICENSE BLOCK *****
-->

*/

const myProductName = "Checky";
const myProductRegKey = "checky";
const myProductRegVersion = "2.5";
const myProductRegVersionBuild = "20041224";
const myJarFileName = "checky.jar";
const myJSFileName = "checky.js"; // the default prefs file. set it to "" if not used
const myLocales = new Array("en-US", "en"); // the locales available

// global settings
// dont change these
const sysChromeGlobal = getFolder("Chrome");
const sysChromeGlobalJar = getFolder("Chrome", myJarFileName);
const sysChromeUser = getFolder("Current User","chrome");
const sysChromeUserJar = getFolder("Current User", "chrome/" + myJarFileName);
const errPage = "http://devedge.netscape.com/library/manuals/2001/xpinstall/1.0/err.html";

var inst;
// inst is the installation method:
//		1 is in the global chrome folder. This *has* to be the default!
//		2 in in the personal profile folder. This is only supported for newer builds.

var existsInApplication = File.exists(getFolder(getFolder("chrome"), myJarFileName));
var existsInProfile     = File.exists(getFolder(getFolder("Current User", "chrome"), myJarFileName));


// If the extension exists in the application folder or it doesn't exist in the profile folder and the user doesn't want it installed to the profile folder
if(existsInApplication || (!existsInProfile && !confirm("Do you want to install the extension into your profile folder?\n(Cancel will install into the application folder)")))
{

inst = 1;

}
else{
inst = 2;
}

// did the user cancel?
if (inst) {
	var err;
	var err_tmp;

	logComment(myProductName + " version " + myProductRegVersion + " being installed on " + buildID);
	logComment("Installation method is " + inst);

	// init the installation
	err_tmp = initInstall(myProductName, myProductRegKey, myProductRegVersion + "." + myProductRegVersionBuild);


	if (err_tmp) {
		err = err_tmp;
	}

	if (!err) {
		err_tmp = addFile(myProductName, myJSFileName, getFolder("Program","defaults/pref"), myJSFileName);
		if (err_tmp) {
			logComment("Problem adding the pref defaults to: " + getFolder("Program", "defaults/pref") + "\n\tError code: " + err_tmp);
			err = err_tmp;
		}
	}
	
	// add the jar file
	if (!err) {
		if (inst == 2) {
			err_tmp = addFile(myProductName, myProductRegVersion, "chrome/" + myJarFileName, sysChromeUser, null);

		} else {
			err_tmp = addFile(myProductName, myProductRegVersion, "chrome/" + myJarFileName, sysChromeGlobal, null);
		}
		if (err_tmp) {
			logComment("Problem adding jar file. Error code: " + err_tmp);
			err = err_tmp;
		} else {
			logComment("ok adding jar file.");
		}
	}
		
	// register the content
	if (!err) {
		if (inst == 2) {
			err_tmp = registerChrome(PACKAGE | PROFILE_CHROME, sysChromeUserJar, "content/" + myProductRegKey + "/");
		} else {
			err_tmp = registerChrome(PACKAGE | DELAYED_CHROME, sysChromeGlobalJar, "content/" + myProductRegKey + "/");
		}
		if (err_tmp) {
			logComment("Problem registering the content chrome. Error code: " + err_tmp);
			err = err_tmp;
		} else {
			logComment("ok registering the content chrome.");
		}
	}
	
	// register the locale
	if (!err) {
		if (inst == 2) {
			for (var i = 0; i < myLocales.length; i++) {
				err_tmp = registerChrome(LOCALE | PROFILE_CHROME, sysChromeUserJar, "locale/" + myLocales[i] + "/" + myProductRegKey + "/");
				if (err_tmp)
					break;
			}
		} else {
			for (var i = 0; i < myLocales.length; i++) {
				err_tmp = registerChrome(LOCALE | DELAYED_CHROME, sysChromeGlobalJar, "locale/" + myLocales[i] + "/" + myProductRegKey + "/");
				if (err_tmp) {
					break;
				}
			}
		}
		if (err_tmp) {
			logComment("Problem registering the locale chrome. Error code: " + err_tmp);
			err = err_tmp;
		} else {
			logComment("ok registering the locale chrome.");
		}
	}
	
	// do the install
	if (!err) {
		err_tmp = performInstall();
		if (err_tmp < 0) {
			logComment("Problem performing install. Error code: " + err_tmp);
			err = err_tmp;
		} else {
			//alert(myProductName + " version " + myProductRegVersion + " has been successfully installed!\nWhen you right-click on a webpage your will now have a new context menuitem called " + myProductName + "!\n\nYou must restart your browser to complete installation!");
		}
	}
		
	// did it work?
	if (err) {
		logComment("Problem installing. Error code: " + err + ". Error codes can been seen at: " + errPage);
		alert(myProductName + " version " + myProductRegVersion + " was not installed!\nError code: " + err + "\n\nError codes can been seen at:\n" + errPage)
		cancelInstall(err);
	}
} else {
	cancelInstall();
}
