(in-package :odcl)

(defregression (:uri 1)
    "uri-unescape-string invokation"
  (uri-unescape-string "1114625:find-person%3DAdministrator%01%0Bad"))

(defregression (:uri 2)
    "uri-escape-string invokation"
  (uri-escape-string "abcdefghijk#)(*)&)(&#@$)(*"))

;; derived from URI Perl module

(defregression (:uri 3)
    "uri-escaping iso-chars"
  (assert-string=
   (uri-escape-string "|abc") "%7Cabc%E5"))

(defregression (:uri 4)
    "uri-unescaping iso-chars"
  (assert-string=
   (uri-unescape-string "%7Cabc%E5") "|abc"))

(defregression (:uri 5)
    "uri-unescaping @"
  (assert-string=
   (uri-unescape-string "%40A%42") "@AB"))

(defregression (:uri 6)
    "uri-unescaping vanilla"
  (assert-string=
   (uri-unescape-string "CDE") "CDE"))

(defregression (:uri 7)
    "uri-unescaping what needn't be escaped"
  (assert-string=
   (uri-unescape-string "F%47H") "FGH"))

(defregression (:uri 8)
    "escaping URLs"
  (assert-string=
   (uri-escape-string "http://www.example.org/check?uri=http://www.example.net/path/to/yourfile.html&lang=en")
   "http%3A%2F%2Fwww.example.org%2Fcheck%3Furi%3Dhttp%3A%2F%2Fwww.example.net%2Fpath%2Fto%2Fyourfile.html%26lang%3Den"))
