;;; cmail-use-bbdb.el --- use bbdb from cmail

;; Author: Takeshi Morishima (tm@onepost.net)
;; Keywords: mail
;; Created at: Sat Feb 26 15:39:56 JST 2000

;; This file is part of cmail (a mail utility for GNU Emacs)

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or (at
;; your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; This is a cmail option feature module for bbdb.

;;; Code:

(require 'path-util)
(eval-when-compile (require 'cmail-vars))

(cmail-i18n-defgroup cmail-use-bbdb-group nil
  ((ja_JP . "cmail $B$G(B bbdb $B$rMxMQ$9$k$?$a$N@_Dj!#(B")
   (en_US . "Customize group for using bbdb from cmail"))
  :group 'cmail-other-features)

(defun cmail-set-bbdb (var flag)
  (set var nil)
  (if flag
      (if (not (module-installed-p 'bbdb))
	  (message
	   "INFO: BBDB is not installed and cmail option is turned off.")
	(cmail-bbdb-setup)
	(set var flag))
    (cmail-bbdb-unload)))

(defun cmail-bbdb-setup ()
  "Prepare to use bbdb"
  (autoload 'bbdb-insinuate-sendmail "bbdb" "Hook BBDB into sendmail")
  (autoload 'bbdb-insinuate-cmail "cmail-bbdb" "Hook BBDB into cmail")
  (add-hook 'cmail-startup-hook 'bbdb-insinuate-cmail)
  (add-hook 'mail-setup-hook 'bbdb-insinuate-sendmail)
  (add-hook 'mail-setup-hook 'bbdb-define-all-aliases))
    
(defun cmail-bbdb-unload ()
  "Remove bbdb hooks"
  (remove-hook 'cmail-startup-hook 'bbdb-insinuate-cmail)
  (remove-hook 'mail-setup-hook 'bbdb-insinuate-sendmail)
  (remove-hook 'mail-setup-hook 'bbdb-define-all-aliases))

(cmail-i18n-defcustom cmail-use-bbdb (module-installed-p 'bbdb)
  ((ja_JP . "\
*Non nil $B$J$i$P(B bbdb $B$r(B cmail $B$+$i;HMQ$9$k!#(B")
   (en_US . "\
*Non nil means use bbdb from cmail."))
  :type 'boolean
  :set 'cmail-set-bbdb
  :group 'cmail-all-variables
  :group 'cmail-use-bbdb-group)
(cmail-custom-add-init 'cmail-set-bbdb 'cmail-use-bbdb)

(defun cmail-use-bbdb nil)
(provide 'cmail-use-bbdb)

;; end-of-file
