/*
 * Author:	The C-Mix Project <cmix@diku.dk>
 *              Peter Holst Andersen <txix@diku.dk>
 * Last change:	August, 1994
 * Contents:	The function mypower, which computes the nth power of x,
 *		where n is an integer and x is a float, using the russian
 *		pesant algorithm.
 */

#include <stdio.h>
#include "ray.h"

/* 
 * e.g. mypower(x, 27) = x^16 * x^8 * x^2 * x^1 = x^(16+8+2+1) = x^27
 */
myfloat mypower(myfloat x, int n)
{
    myfloat a = 1.0;
    
    do {
	if (1 & n)
	    a *= x;
	x *= x;
    } while (n >>= 1);

    return a;
}
