/*
 * cool_stuff.c
 *
 * crafted - a pud editor for the freecraft project.
 *
 * Copyright (C) 2001-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "craftedintl.h"
#include "crafteddialog.h"

static GtkWidget *flip_map_dialog = NULL;


/*************************************************************************
* flip_map_do
**************************************************************************/
static void flip_map_do(void)
{
  g_print("do flip\n");
}

/*************************************************************************
*  flip_map
**************************************************************************/
void flip_map(void)
{
  g_print("flip\n");

  if (flip_map_dialog)
  {
    if (!GTK_WIDGET_VISIBLE(flip_map_dialog))
      gtk_widget_show(flip_map_dialog);
    else
      gdk_window_raise(flip_map_dialog->window);
  } else
  {
    GtkWidget *hbbox, *button, *vbox, *radio;
    GSList    *group = NULL;

    flip_map_dialog = crafted_dialog_new(_("Flip map"),
                                           "crafted",
                                           GTK_WIN_POS_MOUSE,
                                           FALSE, FALSE, TRUE,
                                           _("Apply"), flip_map_do,
                                           NULL, 1, NULL, TRUE, FALSE,
                                           _("Close"), gtk_widget_destroy,
                                           NULL, 1, NULL, FALSE, TRUE, NULL);
     gtk_signal_connect(GTK_OBJECT(flip_map_dialog), "destroy",
                        (GtkSignalFunc)gtk_widget_destroyed,
                        &flip_map_dialog);
        
    /* The main part */
    vbox = gtk_vbox_new(FALSE, 4);
    gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(flip_map_dialog)->vbox), vbox);

    /* the two radio buttons */
    radio = gtk_radio_button_new_with_label(group,
                                            _("flip horizontally"));
    group = gtk_radio_button_group(GTK_RADIO_BUTTON(radio));
    gtk_box_pack_start_defaults(GTK_BOX(vbox), radio);
    radio = gtk_radio_button_new_with_label(group,
                                            _("flip vertically"));
    gtk_box_pack_start_defaults(GTK_BOX(vbox), radio);

    gtk_widget_show_all(flip_map_dialog);
  }
}
