/***************************************************************************
                          prefs.cpp  -  description
                             -------------------
    begin                : Wed Jul 12 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cuyointl.h"
#include "prefs.h"

Prefs::Prefs(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
}

Prefs::~Prefs(){
}


#define tasten_y 10
#define unf_an_y 150
#define ki_gesch_y 175
#define buttons_y 230
#define fenster_y 270

void  Prefs::initDialog(){
  this->resize(300,fenster_y);
  this->setMinimumSize(0,0);
	this->setCaption(_("Preferences"));

  mOK= new QPushButton(this,"ok");
  mOK->setGeometry(190,buttons_y,100,30);
  mOK->setText(_("OK"));
  mOK->setDefault(true);
	connect(mOK, SIGNAL(clicked()), SLOT(accept()));

  mAbbrechen= new QPushButton(this,"abbrechen");
  mAbbrechen->setGeometry(10,buttons_y,100,30);
  mAbbrechen->setText(_("Cancel"));
  connect(mAbbrechen, SIGNAL(clicked()), SLOT(reject()));

  /* Tasten */
  for (int i = 0; i < anz_spieler_in_dlg; i++) {
    int x0 = 140 * i + 10;
	
    QGroupBox * ra = new QGroupBox(this);
    ra->setGeometry(x0, tasten_y, 130, 130);
    ra->setTitle(i ? _("Right player") : _("Left player"));

    mTasten[i][taste_links] = erzeugTastenBtn(_("Left"),
                                x0 + 5, tasten_y + 50, false);
    mTasten[i][taste_rechts] = erzeugTastenBtn(_("Right"),
                                 x0 + 85, tasten_y + 50, false);
    mTasten[i][taste_dreh] = erzeugTastenBtn(_("Turn"),
                               x0 + 45, tasten_y + 40, false);
    mTasten[i][taste_fall] = erzeugTastenBtn(_("Down"),
                               x0 + 45, tasten_y + 70, true);
  }

  
  mUnfertigeLevel = new QCheckBox(this);
  mUnfertigeLevel->setText("Turn on unfinished levels");
  mUnfertigeLevel->setGeometry(10, unf_an_y, 280, 20);
  
  QLabel * kila = new QLabel(this);
  kila->setGeometry(10, ki_gesch_y, 280, 20);
  kila->setText(_("AI-player speed:"));
  mKIGeschwindigkeit = new QScrollBar(0, 9, 1, 1, 0,
                                      QScrollBar::Horizontal, this);
  mKIGeschwindigkeit->setGeometry(10, ki_gesch_y + 25, 280, 16);
}

/** Erzeugt einen von diesen Buttons, in denen
    eine Taste eingegeben wird */
TastenBtn * Prefs::erzeugTastenBtn(const char * na, int x, int y,
                                   bool text_unten) {
  QLabel * la = new QLabel(this);
  la->setGeometry(x-3, y + (text_unten ? 30 : -20), 46, 20);
  la->setText(na);
  la->setAlignment(AlignCenter);
	
  TastenBtn * bu = new TastenBtn(this);
  bu->move(x, y);
  return bu;
}
