/***************************************************************************
                          sorte.cpp  -  description
                             -------------------
    begin                : Fri Apr 20 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>

#include "cuyointl.h"
#include "leveldaten.h"
#include "datendatei.h"

#include "bilddatei.h"

#include "fehler.h"
#include "pfaditerator.h"
#include "sorte.h"
#include "code.h"
#include "knoten.h"
#include "global.h"

#include "blop.h"




const char cEventNamen[event_anz][33] = {
  "", /* Der Mal-Code heit einfach "wuff" und nicht "wuff.draw" oder so. */
  "init", "turn", "land", "changeside"
};





Sorte::Sorte() {
}
Sorte::~Sorte(){
  loeschBilder();
}

/** Ldt die Sorte mit dem angegebenen Namen. Schaut auch in der
    entsprechenden Gruppe von mLevelConf nach, setzt die Gruppe
    aber danach zurck. blopart muss nur angegeben werden, damit ein
    paar Art-abhngige Defaults richtig gesetzt werden knnen.
    Throwt Fehler, wenn erfolglos. */
void Sorte::laden(__String name, int blopart) {

  /* Wenn der Name direkt eine Bild-Datei ist, wird bei mName
     noch die Endung weggeschnitten. picsEndungWeg() steht
     in global.* */
  mName = picsEndungWeg(name);

  /* Fr die restlichen Variablen erst mal ein paar Defaults setzen */
  /* Rand-Verbindung nur bei nix-Blop. */
  for (int i = 0; i < 4; i++)
    mVerbindetMitRand[i] = blopart == blopart_keins;
  /* Kettenzhlung normal */
  mKetteZaehltNurInnen = false;
  /* Default Nachbarschaft = levelweite Nachbarschaftseinstellung */
  mNachbarschaft = ld->mNachbarschaft;
  /* Keine Bildchen */
  loeschBilder(); // Alte Bilder lschen
  /* Keine Event-Programme */
  for (int i = 0; i < event_anz; i++)
    mEventCode[i] = 0;

  /* Wenn name leer ist, dann gibt's nix zu laden. Das sollte eigentlich
     nur beim Leerbildchen passieren, falls das in der ld-Datei nicht
     angegeben ist. (Wenn der Global-Blop nicht angegeben ist, hat
     es trotzdem den Namen "global"; das einzige, was dann passiert,
     ist, dass weiter unten der Cual-Code nicht geladen wird.) */
  if (name.isEmpty()) {
    /* Fr bessere Debug-Ausgaben setzen wir uns aber trotzdem noch
       einen schnen Namen. */
    switch (blopart) {
      case blopart_keins: mName = _("nothing"); break;
      //case blopart_farbe: mName = _("color"); break;
      //case blopart_gras: mName = _("grass"); break;
      //case blopart_grau: mName = _("grey"); break;
      //case blopart_global: mName = _("global"); break;
      default: throw iFehler(_("Internal Error in Sorte::laden(): blopart = %d"), blopart);
    }
    return;
  }


  /***** Sortenabschnitt laden. *****/
  
  {
  
    /* In den Unterabschnitt zu diesem Bildchen gehen. false heit: Wenn's
       den Abschnitt nicht gibt, nicht gleich throwen */
    DatenDateiPush ddp(*ld->mLevelConf, name, false);

    /* Beim global-Blop sollte es Grafik-Zeug nicht geben. Wir
       versuchen einfach gar nicht erst, es zu laden. Insbesondere
       wollen wir auch kein Default-Bild laden. */
    if (blopart != blopart_global) {

      /* Gibt es zu diesem Bildchen berhaupt einen Abschnitt in
	 der Config-Datei? */
      if (ld->mLevelConf->existiertSquirrelKnoten()) {
	/* OK, es gibt in der Gruppe mit diesem Namen einen pics-Eintrag;
           also gibt's insbesondere diese Gruppe... */

	/* Andere Nachbarschaft als level-weite globale? (optional) */
	mNachbarschaft =
          ld->mLevelConf->getZahlEintrag("neighbours", mNachbarschaft);
	if (mNachbarschaft < 0 || mNachbarschaft > nachbarschaft_letzte)
          throw Fehler(_("neighbours out of range"));

	/* Ketten zhlen nur innen? (optional, z. B. Go-Level) */
	mKetteZaehltNurInnen =
          ld->mLevelConf->getZahlEintrag("onlyinterior", mKetteZaehltNurInnen);

	/* Bilder laden (optional) */
	int anz_bi;
	ListenKnoten * namen = ld->mLevelConf->getListenEintrag("pics");
	if (namen)
          anz_bi = namen->getLaenge();
	else
          anz_bi = 0;
	mBilddateien.resize(anz_bi);

	/* Falls ein Throw whrend des Ladens der Bilder kommt, ist das Array
           erst halb gefllt. Damit es spter richtig gelscht werden kann,
           sollten nicht existente Bilder 0-Pointer sein... */
	for (int i = 0; i < anz_bi; i++)
          mBilddateien[i] = 0;

	for (int bnr = 0; bnr < anz_bi; bnr++) {
          __String bild_name = namen->getWort(bnr);

          //Bilddatei * neu_b = new Bilddatei();
          //neu_b->laden(bild_name);
          //mBilddateien[bnr] = neu_b;
          mBilddateien[bnr] = new Bilddatei();
          mBilddateien[bnr]->laden(bild_name);
	}


	/* Ende: In Config existiert Abschnitt fr dieses Bildchen */
      } else {
	/* Kein Abschnitt in der Config fr dieses Icon. Also direkt den Namen
           als Bilddateinamen verwenden. (Und zwar den Namen _mit_ Endung.) */
	mBilddateien.resize(1);
	mBilddateien[0] = new Bilddatei();
	mBilddateien[0]->laden(name);

      }

    } // Ende von: kein Global-Blop
    

    /***** Mal-cual-Code laden. (Sonderbehandlung; nicht so wie die
           anderen Events.) *****/

    try {
      mEventCode[event_draw] =
           ld->mLevelConf->getCode(namespace_prozedur, mName);
      
    } catch (Fehler fe) {
    
      mEventCode[event_draw] = 0;
      
      /* Wenn's den Code nicht gibt, dann default-Code verwenden; aber
         nur, wenn es sich nicht um den Global-Code handelt. Und wenn's
	 keine Bildchen gibt, wird per default auch nicht gemalt. */
      if (blopart != blopart_global && mBilddateien.size() > 0) {
      
        /* Welchen Default nehmen wir? */
	__String dname;
	if (mBilddateien.size() > 1)
          dname = "default3";
	else if (mBilddateien[0]->anzBildchen() > 1) {
          /* Farbblops und nix-Blops verbinden sich per default;
	     andere nicht. */
          if (blopart == blopart_gras)
            dname = "default2g";
          else
            dname = "default2";
	} else
          dname = "default1";

        if (gDebug)
          fprintf(stderr, "Using %s for %s\n", dname.data(), mName.data());
	mEventCode[event_draw] =
	     ld->mLevelConf->getCode(namespace_prozedur, dname);
      }
    }
    
    /* Den Leveldaten mitteilen, wie viele Bildchen unsere Blops
       hchstens gleichzeitig malen. */
    if (mEventCode[event_draw]) {
      int sh = mEventCode[event_draw]->getStapelHoehe(ld->mNachbarStapelHoehe);
      if (sh > ld->mStapelHoehe)
        ld->mStapelHoehe = sh;
    }
    
    
    /***** Cual-Code fr Events laden (optional) *****/
    
    /* i erst bei 1 los; 0 ist event_draw, der eine Sonderbehandlug ist. */
    for (int i = 1; i < event_anz; i++) {
      try {
        mEventCode[i] = ld->mLevelConf->getCode(namespace_prozedur,
                                mName + "." + cEventNamen[i]);

        /* Wenn im Event-Code Mal-Befehle vorkommen, geben wir
	   im Debug-Modus eine Warnung aus. */
	if (gDebug) {
	  int nsh = 0;
	  if (mEventCode[i]->getStapelHoehe(nsh) > 0 || nsh > 0)
	    fprintf(stderr, _("Warning: %s.%s contains drawing commands.\nDrawing is not allowed during events.\n"),
			    mName.data(), cEventNamen[i]);
        }
      } catch (Fehler fe) {
        // Dann halt nicht...
      }
    }
    

  } // Ende: DatenDatei-Push
}






/** lscht die ganzen Bilder aus dem mBilddateien-Array */
void Sorte::loeschBilder() {
  for (int i = 0; i < (int) mBilddateien.size(); i++)
    if (mBilddateien[i])
      delete mBilddateien[i];
		
  /* Damit keine Pointer in der Luft hngen...: */
  mBilddateien.resize(0);
}



/***** Getter-Methoden, mit denen man auf die ganzen Informationen
       zugreifen kann. *****/


__String Sorte::getName() const {
  return mName;
}


bool Sorte::getVerbindetMitRand(int r) const {
  return mVerbindetMitRand[r];
}

bool Sorte::getKetteZaehltNurInnen() const {
  return mKetteZaehltNurInnen;
}

int Sorte::getNachbarschaft() const {
  return mNachbarschaft;
}


Code * Sorte::getEventCode(int evt) const {
  return mEventCode[evt];
}
  
Bilddatei * Sorte::getBilddatei(int nr) const {
  if (nr < 0 || nr >= (int) mBilddateien.size())
    throw Fehler(_("File number file=%d out of range (allowed: 0 - %d)"), nr,
               mBilddateien.size() - 1);
  return mBilddateien[nr];
}


