%  Copyright (C) 2004 David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

\begin{code}
module CheckFileSystem ( can_I_remove_open_files ) where

import System.Directory ( removeFile )
import Control.Exception ( block )

import Lock ( withOpenTemp )

-- Beware that the below test will return true in any directory where we
-- don't have write permission.  This is risky, but means we'll do the
-- right thing in the common case where we're dealing with posix
-- filesystems and directories in which we don't have permission to write.

can_I_remove_open_files :: IO Bool
can_I_remove_open_files = block $ 
   (withOpenTemp $ \ (_,f) ->
       (do { removeFile f; return True}) `catch` \_ -> return False)
   `catch` \_ -> return True
\end{code}


