/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.functions.Function;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;

public class XPath
implements Serializable {
    private Expression m_mainExp;
    String m_patternString;
    public static final int SELECT = 0;
    public static final int MATCH = 1;
    private static final boolean DEBUG_MATCHES = false;
    public static final double MATCH_SCORE_NONE = Double.NEGATIVE_INFINITY;
    public static final double MATCH_SCORE_QNAME = 0.0;
    public static final double MATCH_SCORE_NSWILD = -0.25;
    public static final double MATCH_SCORE_NODETEST = -0.5;
    public static final double MATCH_SCORE_OTHER = 0.5;

    public XPath(String string, SourceLocator sourceLocator, PrefixResolver prefixResolver, int n) throws TransformerException {
        this(string, sourceLocator, prefixResolver, n, null);
    }

    public XPath(String string, SourceLocator sourceLocator, PrefixResolver prefixResolver, int n, ErrorListener errorListener) throws TransformerException {
        if (errorListener == null) {
            errorListener = new DefaultErrorHandler();
        }
        this.m_patternString = string;
        XPathParser xPathParser = new XPathParser(errorListener, sourceLocator);
        Compiler compiler = new Compiler(errorListener, sourceLocator);
        if (n == 0) {
            xPathParser.initXPath(compiler, string, prefixResolver);
        } else if (n == 1) {
            xPathParser.initMatchPattern(compiler, string, prefixResolver);
        } else {
            throw new RuntimeException(XSLMessages.createXPATHMessage(71, new Object[]{Integer.toString(n)}));
        }
        Expression expression = compiler.compile(0);
        this.setExpression(expression);
    }

    public XPath(Expression expression) {
        this.setExpression(expression);
    }

    public void assertion(boolean bl, String string) {
        if (!bl) {
            String string2 = XSLMessages.createXPATHMessage(30, new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean bool(XPathContext var1_1, int var2_2, PrefixResolver var3_3) throws TransformerException {
        block8: {
            var1_1.pushNamespaceContext(var3_3);
            var1_1.pushCurrentNodeAndExpression(var2_2, var2_2);
            try {
                try {
                    var4_4 = this.m_mainExp.bool(var1_1);
                    var6_5 = null;
                    var1_1.popNamespaceContext();
                    var1_1.popCurrentNodeAndExpression();
                    return var4_4;
                }
                catch (TransformerException var7_8) {
                    var7_8.setLocator(this.getLocator());
                    var8_11 = var1_1.getErrorListener();
                    if (var8_11 != null) {
                        var8_11.error(var7_8);
                        break block8;
                    }
                    throw var7_8;
                }
                catch (Exception var7_9) {
                    ** while (var7_10 instanceof WrappedRuntimeException)
                }
lbl-1000:
                // 1 sources

                {
                    var7_10 = ((WrappedRuntimeException)var7_10).getException();
                    continue;
                }
lbl22:
                // 1 sources

                var8_12 = var7_10.getMessage();
                var8_12 = var8_12 == null || var8_12.length() == 0 ? "Unknown error in XPath" : var8_12;
                var9_13 = new TransformerException(var8_12, this.getLocator(), var7_10);
                var10_14 = var1_1.getErrorListener();
                if (var10_14 != null) {
                    var10_14.fatalError(var9_13);
                    break block8;
                }
                throw var9_13;
            }
            catch (Throwable var5_15) {
                var6_7 = null;
                var1_1.popNamespaceContext();
                var1_1.popCurrentNodeAndExpression();
                throw var5_15;
            }
        }
        var6_6 = null;
        var1_1.popNamespaceContext();
        var1_1.popCurrentNodeAndExpression();
        return false;
    }

    public void error(XPathContext xPathContext, int n, int n2, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHMessage(n2, objectArray);
        ErrorListener errorListener = xPathContext.getErrorListener();
        if (errorListener != null) {
            errorListener.fatalError(new TransformerException(string, (SAXSourceLocator)xPathContext.getSAXLocator()));
        } else {
            SourceLocator sourceLocator = xPathContext.getSAXLocator();
            System.out.println(String.valueOf(string) + "; file " + sourceLocator.getSystemId() + "; line " + sourceLocator.getLineNumber() + "; column " + sourceLocator.getColumnNumber());
        }
    }

    /*
     * Unable to fully structure code
     */
    public XObject execute(XPathContext var1_1, int var2_2, PrefixResolver var3_3) throws TransformerException {
        var1_1.pushNamespaceContext(var3_3);
        var1_1.pushCurrentNodeAndExpression(var2_2, var2_2);
        var4_4 = null;
        try {
            block9: {
                try {
                    var4_4 = this.m_mainExp.execute(var1_1);
                    break block9;
                }
                catch (TransformerException var7_5) {
                    var7_5.setLocator(this.getLocator());
                    var8_8 = var1_1.getErrorListener();
                    if (var8_8 != null) {
                        var8_8.error(var7_5);
                        break block9;
                    }
                    throw var7_5;
                }
                catch (Exception var7_6) {
                    ** while (var7_7 instanceof WrappedRuntimeException)
                }
lbl-1000:
                // 1 sources

                {
                    var7_7 = ((WrappedRuntimeException)var7_7).getException();
                    continue;
                }
lbl19:
                // 1 sources

                var8_9 = var7_7.getMessage();
                var8_9 = var8_9 == null || var8_9.length() == 0 ? "Unknown error in XPath" : var8_9;
                var9_10 = new TransformerException(var8_9, this.getLocator(), var7_7);
                var10_11 = var1_1.getErrorListener();
                if (var10_11 != null) {
                    var10_11.fatalError(var9_10);
                } else {
                    throw var9_10;
                }
            }
            var6_12 = null;
            var1_1.popNamespaceContext();
            var1_1.popCurrentNodeAndExpression();
        }
        catch (Throwable var5_14) {
            var6_13 = null;
            var1_1.popNamespaceContext();
            var1_1.popCurrentNodeAndExpression();
            throw var5_14;
        }
        return var4_4;
    }

    public XObject execute(XPathContext xPathContext, Node node, PrefixResolver prefixResolver) throws TransformerException {
        return this.execute(xPathContext, xPathContext.getDTMHandleFromNode(node), prefixResolver);
    }

    public void fixupVariables(Vector vector, int n) {
        this.m_mainExp.fixupVariables(vector, n);
    }

    public Expression getExpression() {
        return this.m_mainExp;
    }

    public SourceLocator getLocator() {
        return this.m_mainExp.m_slocator;
    }

    public double getMatchScore(XPathContext xPathContext, int n) throws TransformerException {
        xPathContext.pushCurrentNode(n);
        xPathContext.pushCurrentExpressionNode(n);
        try {
            XObject xObject = this.m_mainExp.execute(xPathContext);
            double d = xObject.num();
            Object var6_5 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            return d;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public String getPatternString() {
        return this.m_patternString;
    }

    public void installFunction(String string, int n, Function function) {
        FunctionTable.installFunction(function, n);
    }

    public void setExpression(Expression expression) {
        this.m_mainExp = expression;
    }

    public void setLocator(SourceLocator sourceLocator) {
        this.m_mainExp.setSourceLocator(sourceLocator);
    }

    public void warn(XPathContext xPathContext, int n, int n2, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHWarning(n2, objectArray);
        ErrorListener errorListener = xPathContext.getErrorListener();
        if (errorListener != null) {
            errorListener.warning(new TransformerException(string, (SAXSourceLocator)xPathContext.getSAXLocator()));
        }
    }
}

