/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;

public class StepPattern
extends NodeTest
implements SubContextList {
    protected int m_axis;
    String m_targetString;
    StepPattern m_relativePathPattern;
    Expression[] m_predicates;
    private static final boolean DEBUG_MATCHES = false;

    public StepPattern(int n, int n2, int n3) {
        super(n);
        this.m_axis = n2;
    }

    public StepPattern(int n, String string, String string2, int n2, int n3) {
        super(n, string, string2);
        this.m_axis = n2;
    }

    public void calcScore() {
        if (this.getPredicateCount() > 0 || this.m_relativePathPattern != null) {
            this.m_score = NodeTest.SCORE_OTHER;
        } else {
            super.calcScore();
        }
        if (this.m_targetString == null) {
            this.calcTargetString();
        }
    }

    public void calcTargetString() {
        int n = this.getWhatToShow();
        switch (n) {
            case 128: {
                this.m_targetString = "#comment";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                this.m_targetString = "#text";
                break;
            }
            case -1: {
                this.m_targetString = "*";
                break;
            }
            case 256: 
            case 1280: {
                this.m_targetString = "/";
                break;
            }
            case 1: {
                if (this.m_name == "*") {
                    this.m_targetString = "*";
                    break;
                }
                this.m_targetString = this.m_name;
                break;
            }
            default: {
                this.m_targetString = "*";
            }
        }
    }

    public boolean canTraverseOutsideSubtree() {
        int n = this.getPredicateCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getPredicate(n2).canTraverseOutsideSubtree()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean checkProximityPosition(XPathContext xPathContext, int n, DTM dTM, int n2, int n3) {
        try {
            DTMAxisTraverser dTMAxisTraverser = dTM.getAxisTraverser(12);
            int n4 = dTMAxisTraverser.first(n2);
            while (n4 != -1) {
                Object var10_9;
                try {
                    xPathContext.pushCurrentNode(n4);
                    if (NodeTest.SCORE_NONE != super.execute(xPathContext, n4)) {
                        Object var13_11;
                        boolean bl = true;
                        try {
                            xPathContext.pushSubContextList(this);
                            int n5 = 0;
                            while (n5 < n) {
                                Object var16_13;
                                xPathContext.pushPredicatePos(n5);
                                try {
                                    Object var19_15;
                                    XObject xObject;
                                    block16: {
                                        xObject = this.m_predicates[n5].execute(xPathContext);
                                        try {
                                            if (xObject.getType() == 2) {
                                                throw new Error("Why: Should never have been called");
                                            }
                                            if (xObject.boolWithSideEffects()) break block16;
                                            bl = false;
                                            var19_15 = null;
                                            xObject.detach();
                                        }
                                        catch (Throwable throwable) {
                                            var19_15 = null;
                                            xObject.detach();
                                            throw throwable;
                                        }
                                        var16_13 = null;
                                        xPathContext.popPredicatePos();
                                        break;
                                    }
                                    var19_15 = null;
                                    xObject.detach();
                                }
                                catch (Throwable throwable) {
                                    var16_13 = null;
                                    xPathContext.popPredicatePos();
                                    throw throwable;
                                }
                                var16_13 = null;
                                xPathContext.popPredicatePos();
                                ++n5;
                            }
                        }
                        catch (Throwable throwable) {
                            var13_11 = null;
                            xPathContext.popSubContextList();
                            throw throwable;
                        }
                        var13_11 = null;
                        xPathContext.popSubContextList();
                        if (bl) {
                            --n3;
                        }
                        if (n3 < 1) {
                            boolean bl2 = false;
                            var10_9 = null;
                            xPathContext.popCurrentNode();
                            return bl2;
                        }
                    }
                    var10_9 = null;
                    xPathContext.popCurrentNode();
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    xPathContext.popCurrentNode();
                    throw throwable;
                }
                n4 = dTMAxisTraverser.next(n2, n4);
            }
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException.getMessage());
        }
        if (n3 == 1) return true;
        return false;
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext, xPathContext.getCurrentNode());
    }

    public XObject execute(XPathContext xPathContext, int n) throws TransformerException {
        DTM dTM = xPathContext.getDTM(n);
        if (dTM != null) {
            int n2 = dTM.getExpandedTypeID(n);
            return this.execute(xPathContext, n, dTM, n2);
        }
        return NodeTest.SCORE_NONE;
    }

    public XObject execute(XPathContext xPathContext, int n, DTM dTM, int n2) throws TransformerException {
        if (this.m_whatToShow == 65536) {
            if (this.m_relativePathPattern != null) {
                return this.m_relativePathPattern.execute(xPathContext);
            }
            return NodeTest.SCORE_NONE;
        }
        XObject xObject = super.execute(xPathContext, n, dTM, n2);
        if (xObject == NodeTest.SCORE_NONE) {
            return NodeTest.SCORE_NONE;
        }
        if (this.getPredicateCount() != 0 && !this.executePredicates(xPathContext, dTM, n)) {
            return NodeTest.SCORE_NONE;
        }
        if (this.m_relativePathPattern != null) {
            return this.m_relativePathPattern.executeRelativePathPattern(xPathContext, dTM, n);
        }
        return xObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean executePredicates(XPathContext xPathContext, DTM dTM, int n) throws TransformerException {
        boolean bl = true;
        boolean bl2 = false;
        int n2 = this.getPredicateCount();
        try {
            xPathContext.pushSubContextList(this);
            int n3 = 0;
            while (n3 < n2) {
                Object var11_8;
                block16: {
                    block15: {
                        block14: {
                            xPathContext.pushPredicatePos(n3);
                            try {
                                Object var14_10;
                                XObject xObject;
                                block10: {
                                    block12: {
                                        block11: {
                                            block9: {
                                                xObject = this.m_predicates[n3].execute(xPathContext);
                                                try {
                                                    if (xObject.getType() == 2) {
                                                        int n4 = (int)xObject.num();
                                                        if (bl2) {
                                                            bl = n4 == 1;
                                                            var14_10 = null;
                                                            xObject.detach();
                                                            break block9;
                                                        }
                                                        bl2 = true;
                                                        if (this.checkProximityPosition(xPathContext, n3, dTM, n, n4)) break block10;
                                                        bl = false;
                                                        break block11;
                                                    }
                                                    if (xObject.boolWithSideEffects()) break block10;
                                                    bl = false;
                                                    break block12;
                                                }
                                                catch (Throwable throwable) {
                                                    var14_10 = null;
                                                    xObject.detach();
                                                    throw throwable;
                                                }
                                            }
                                            var11_8 = null;
                                            xPathContext.popPredicatePos();
                                            break;
                                        }
                                        var14_10 = null;
                                        xObject.detach();
                                        break block14;
                                    }
                                    var14_10 = null;
                                    xObject.detach();
                                    break block15;
                                }
                                var14_10 = null;
                                xObject.detach();
                                break block16;
                            }
                            catch (Throwable throwable) {
                                var11_8 = null;
                                xPathContext.popPredicatePos();
                                throw throwable;
                            }
                        }
                        var11_8 = null;
                        xPathContext.popPredicatePos();
                        break;
                    }
                    var11_8 = null;
                    xPathContext.popPredicatePos();
                    break;
                }
                var11_8 = null;
                xPathContext.popPredicatePos();
                ++n3;
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            xPathContext.popSubContextList();
            throw throwable;
        }
        Object var8_14 = null;
        xPathContext.popSubContextList();
        return bl;
    }

    protected final XObject executeRelativePathPattern(XPathContext xPathContext, DTM dTM, int n) throws TransformerException {
        XObject xObject = NodeTest.SCORE_NONE;
        int n2 = n;
        DTMAxisTraverser dTMAxisTraverser = dTM.getAxisTraverser(this.m_axis);
        int n3 = dTMAxisTraverser.first(n2);
        while (n3 != -1) {
            Object var9_8;
            try {
                xPathContext.pushCurrentNode(n3);
                xObject = this.execute(xPathContext);
                if (xObject != NodeTest.SCORE_NONE) {
                    var9_8 = null;
                    xPathContext.popCurrentNode();
                    break;
                }
                var9_8 = null;
                xPathContext.popCurrentNode();
            }
            catch (Throwable throwable) {
                var9_8 = null;
                xPathContext.popCurrentNode();
                throw throwable;
            }
            n3 = dTMAxisTraverser.next(n2, n3);
        }
        return xObject;
    }

    public void fixupVariables(Vector vector, int n) {
        super.fixupVariables(vector, n);
        if (this.m_predicates != null) {
            int n2 = 0;
            while (n2 < this.m_predicates.length) {
                this.m_predicates[n2].fixupVariables(vector, n);
                ++n2;
            }
        }
        if (this.m_relativePathPattern != null) {
            this.m_relativePathPattern.fixupVariables(vector, n);
        }
    }

    public int getAxis() {
        return this.m_axis;
    }

    public int getLastPos(XPathContext xPathContext) {
        return this.getProximityPosition(xPathContext, xPathContext.getPredicatePos(), true);
    }

    public double getMatchScore(XPathContext xPathContext, int n) throws TransformerException {
        xPathContext.pushCurrentNode(n);
        xPathContext.pushCurrentExpressionNode(n);
        try {
            XObject xObject = this.execute(xPathContext);
            double d = xObject.num();
            Object var6_5 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            return d;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public Expression getPredicate(int n) {
        return this.m_predicates[n];
    }

    public final int getPredicateCount() {
        return this.m_predicates == null ? 0 : this.m_predicates.length;
    }

    public Expression[] getPredicates() {
        return this.m_predicates;
    }

    public int getProximityPosition(XPathContext xPathContext) {
        return this.getProximityPosition(xPathContext, xPathContext.getPredicatePos(), false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getProximityPosition(XPathContext xPathContext, int n, boolean bl) {
        int n2 = 0;
        int n3 = xPathContext.getCurrentNode();
        DTM dTM = xPathContext.getDTM(n3);
        int n4 = dTM.getParent(n3);
        try {
            DTMAxisTraverser dTMAxisTraverser = dTM.getAxisTraverser(3);
            int n5 = dTMAxisTraverser.first(n4);
            while (true) {
                Object var12_11;
                if (n5 == -1) {
                    return n2;
                }
                try {
                    xPathContext.pushCurrentNode(n5);
                    if (NodeTest.SCORE_NONE != super.execute(xPathContext, n5)) {
                        Object var15_13;
                        boolean bl2 = true;
                        try {
                            xPathContext.pushSubContextList(this);
                            int n6 = 0;
                            while (n6 < n) {
                                Object var18_15;
                                block22: {
                                    block21: {
                                        xPathContext.pushPredicatePos(n6);
                                        try {
                                            Object var21_17;
                                            XObject xObject;
                                            block17: {
                                                block19: {
                                                    block18: {
                                                        xObject = this.m_predicates[n6].execute(xPathContext);
                                                        try {
                                                            if (xObject.getType() == 2) {
                                                                if (n2 + 1 == (int)xObject.numWithSideEffects()) break block17;
                                                                bl2 = false;
                                                                var21_17 = null;
                                                                xObject.detach();
                                                                break block18;
                                                            }
                                                            if (xObject.boolWithSideEffects()) break block17;
                                                            bl2 = false;
                                                            break block19;
                                                        }
                                                        catch (Throwable throwable) {
                                                            var21_17 = null;
                                                            xObject.detach();
                                                            throw throwable;
                                                        }
                                                    }
                                                    var18_15 = null;
                                                    xPathContext.popPredicatePos();
                                                    break;
                                                }
                                                var21_17 = null;
                                                xObject.detach();
                                                break block21;
                                            }
                                            var21_17 = null;
                                            xObject.detach();
                                            break block22;
                                        }
                                        catch (Throwable throwable) {
                                            var18_15 = null;
                                            xPathContext.popPredicatePos();
                                            throw throwable;
                                        }
                                    }
                                    var18_15 = null;
                                    xPathContext.popPredicatePos();
                                    break;
                                }
                                var18_15 = null;
                                xPathContext.popPredicatePos();
                                ++n6;
                            }
                        }
                        catch (Throwable throwable) {
                            var15_13 = null;
                            xPathContext.popSubContextList();
                            throw throwable;
                        }
                        var15_13 = null;
                        xPathContext.popSubContextList();
                        if (bl2) {
                            ++n2;
                        }
                        if (!bl && n5 == n3) {
                            int n7 = n2;
                            var12_11 = null;
                            xPathContext.popCurrentNode();
                            return n7;
                        }
                    }
                    var12_11 = null;
                    xPathContext.popCurrentNode();
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    xPathContext.popCurrentNode();
                    throw throwable;
                }
                n5 = dTMAxisTraverser.next(n4, n5);
            }
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException.getMessage());
        }
    }

    public StepPattern getRelativePathPattern() {
        return this.m_relativePathPattern;
    }

    public String getTargetString() {
        return this.m_targetString;
    }

    public void setAxis(int n) {
        this.m_axis = n;
    }

    public void setPredicates(Expression[] expressionArray) {
        this.m_predicates = expressionArray;
        this.calcScore();
    }

    public void setRelativePathPattern(StepPattern stepPattern) {
        this.m_relativePathPattern = stepPattern;
        this.calcScore();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StepPattern stepPattern = this;
        while (stepPattern != null) {
            if (stepPattern != this) {
                stringBuffer.append("/");
            }
            stringBuffer.append(Axis.names[stepPattern.m_axis]);
            stringBuffer.append("::");
            if (stepPattern.m_whatToShow == 20480) {
                stringBuffer.append("doc()");
            } else if (stepPattern.m_whatToShow == 65536) {
                stringBuffer.append("function()");
            } else if (stepPattern.m_whatToShow == -1) {
                stringBuffer.append("node()");
            } else if (stepPattern.m_whatToShow == 4) {
                stringBuffer.append("text()");
            } else if (stepPattern.m_whatToShow == 64) {
                stringBuffer.append("processing-instruction(");
                if (stepPattern.m_name != null) {
                    stringBuffer.append(stepPattern.m_name);
                }
                stringBuffer.append(")");
            } else if (stepPattern.m_whatToShow == 128) {
                stringBuffer.append("comment()");
            } else if (stepPattern.m_name != null) {
                if (stepPattern.m_whatToShow == 2) {
                    stringBuffer.append("@");
                }
                if (stepPattern.m_namespace != null) {
                    stringBuffer.append("{");
                    stringBuffer.append(stepPattern.m_namespace);
                    stringBuffer.append("}");
                }
                stringBuffer.append(stepPattern.m_name);
            } else if (stepPattern.m_whatToShow == 2) {
                stringBuffer.append("@");
            } else if (stepPattern.m_whatToShow == 1280) {
                stringBuffer.append("doc-root()");
            } else {
                stringBuffer.append("?" + Integer.toHexString(stepPattern.m_whatToShow));
            }
            if (stepPattern.m_predicates != null) {
                int n = 0;
                while (n < stepPattern.m_predicates.length) {
                    stringBuffer.append("[");
                    stringBuffer.append(stepPattern.m_predicates[n]);
                    stringBuffer.append("]");
                    ++n;
                }
            }
            stepPattern = stepPattern.m_relativePathPattern;
        }
        return stringBuffer.toString();
    }
}

