/*******************************************************************************
File : define.h
Definizioni delle costanti
*******************************************************************************/

#ifndef MY_DEFINE
#define MY_DEFINE

/* ---------------------------------------------------------------- Caratteri */
#define CHR_NULL	0x00
#define	CHR_STX		0x05
#define	CHR_ETX		0x06
#define	CHR_CR		0x0d
#define	CHR_LF		0x0a


/* ----------------------------------------- Valori di ritorno delle funzioni */ 
#define OK		0
#define	ERR		-1

#define	ON		1
#define	OFF		0

#ifndef FALSE
#define FALSE		0
#endif

#ifndef TRUE
#define TRUE		1
#endif

/* Tipi */
#include <sys/types.h>

#ifdef Linux
typedef unsigned char uchar;
#endif

#ifdef Solaris
typedef unsigned char uchar;
#endif

#ifdef FreeBSD
typedef unsigned char uchar;
typedef unsigned long ulong;
#endif

/* Funzioni elementari */
#define max(A,B) A>B?A:B
#define min(A,B) A>B?B:A

/* Costanti per i socket */
#define INVALID_SOCKET -1

#endif
